/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.AgrCreateAgrItemService;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrItemReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrItemRspBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSyncUccReqBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrCreateAgrItemService"})
public class AgrCreateAgrItemServiceImpl
implements AgrCreateAgrItemService {
    private static final Logger log = LoggerFactory.getLogger(AgrCreateAgrItemServiceImpl.class);
    @Autowired
    private IAgrAgrModel agrAgrModel;
    @Value(value="${AGR_SKU_CHANGE_TOPIC}")
    private String agrSkuChangeTopic;
    @Value(value="${AGR_SKU_CHANGE_TAG}")
    private String agrSkuChangeTag;
    @Resource(name="agrSyncSkuStatusMqServiceProvider")
    private ProxyMessageProducer agrSyncSkuStatusMqServiceProvider;

    @PostMapping(value={"createAgrItem"})
    public AgrCreateAgrItemRspBo createAgrItem(@RequestBody AgrCreateAgrItemReqBo agrCreateAgrItemReqBo) {
        AgrCreateAgrItemRspBo rspBo = new AgrCreateAgrItemRspBo();
        this.validParam(agrCreateAgrItemReqBo);
        AgrAgrDo agrAgrDo = (AgrAgrDo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)agrCreateAgrItemReqBo), AgrAgrDo.class);
        this.deleteAgrItem(agrCreateAgrItemReqBo);
        this.agrAgrModel.saveAgrItem(agrAgrDo);
        this.operSkuStatus(agrCreateAgrItemReqBo, agrAgrDo);
        rspBo.setRespCode("0000");
        return rspBo;
    }

    private void deleteAgrItem(AgrCreateAgrItemReqBo agrCreateAgrItemReqBo) {
        ArrayList<Long> agrItemIds = new ArrayList<Long>();
        agrCreateAgrItemReqBo.getAgrItem().forEach(agrItem -> agrItemIds.add(agrItem.getAgrItemId()));
        if (!CollectionUtils.isEmpty(agrItemIds)) {
            AgrAgrDo agrAgrDo1 = new AgrAgrDo();
            agrAgrDo1.setAgrId(agrCreateAgrItemReqBo.getAgrId());
            ArrayList<AgrItem> agrItems = new ArrayList<AgrItem>();
            AgrItem agrItem2 = new AgrItem();
            agrItem2.setAgrId(agrCreateAgrItemReqBo.getAgrId());
            agrItem2.setAgrItemIds(agrItemIds);
            agrItems.add(agrItem2);
            agrAgrDo1.setAgrItem(agrItems);
            this.agrAgrModel.deleteAgrItemByBatch(agrAgrDo1);
        }
    }

    private void validParam(AgrCreateAgrItemReqBo agrCreateAgrItemReqBo) {
        if (agrCreateAgrItemReqBo.getAgrId() == null) {
            throw new BaseBusinessException("22000", "\u534f\u8baeID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)agrCreateAgrItemReqBo.getAgrItem())) {
            throw new BaseBusinessException("22000", "\u534f\u8bae\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String toUpShelf(AgrSyncUccReqBO agrSyncUccReqBO) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        List<Object> agreementIds = new ArrayList<Long>();
        List<Object> agreementItemIds = new ArrayList();
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrId(agrSyncUccReqBO.getAgrId());
        AgrAgrDo agrDetail = this.agrAgrModel.getAgrDetail(agrAgrQryBo);
        if (agrDetail.getAgrType().equals(AgrCommConstant.AgrType.AGR)) {
            List<AgrItem> agrItems = this.agrAgrModel.checkAgrItemUnfreeze(agrSyncUccReqBO);
            if (!CollectionUtil.isNotEmpty(agrItems)) return null;
            agreementIds = agrItems.stream().map(AgrItem::getAgrId).distinct().collect(Collectors.toList());
            agreementItemIds = agrItems.stream().map(AgrItem::getAgrItemId).distinct().collect(Collectors.toList());
        } else {
            if (CollectionUtil.isNotEmpty((Collection)agrSyncUccReqBO.getAgrItemIds())) {
                agreementItemIds.addAll(agrSyncUccReqBO.getAgrItemIds());
            }
            agreementIds.add(agrSyncUccReqBO.getAgrId());
        }
        content.put("changeType", AgrCommConstant.AgrChangeOperType.THAW);
        content.put("agreementIds", agreementIds.stream().distinct().collect(Collectors.toList()));
        content.put("agreementSkuIds", agreementItemIds.stream().distinct().collect(Collectors.toList()));
        content.put("operId", agrSyncUccReqBO.getOperId());
        content.put("operName", agrSyncUccReqBO.getOperName());
        return JSON.toJSONString(content);
    }

    private String toFrozen(AgrSyncUccReqBO agrSyncUccReqBO) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        ArrayList<Long> agreementIds = new ArrayList<Long>();
        ArrayList agreementItemIds = new ArrayList();
        agreementIds.add(agrSyncUccReqBO.getAgrId());
        if (CollectionUtil.isNotEmpty((Collection)agrSyncUccReqBO.getAgrIds())) {
            agreementIds.addAll(agrSyncUccReqBO.getAgrIds());
        }
        if (CollectionUtil.isNotEmpty((Collection)agrSyncUccReqBO.getAgrItemIds())) {
            agreementItemIds.addAll(agrSyncUccReqBO.getAgrItemIds());
        }
        content.put("changeType", AgrCommConstant.AgrChangeOperType.FREZE);
        content.put("agreementIds", agreementIds.stream().distinct().collect(Collectors.toList()));
        content.put("agreementSkuIds", agreementItemIds.stream().distinct().collect(Collectors.toList()));
        content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.AGREEMENT_FREEZEN);
        content.put("operId", agrSyncUccReqBO.getOperId());
        content.put("operName", agrSyncUccReqBO.getOperName());
        return JSON.toJSONString(content);
    }

    private void operSkuStatus(AgrCreateAgrItemReqBo agrCreateAgrItemReqBo, AgrAgrDo agrAgrDo) {
        AgrSyncUccReqBO toUpShelfAgrSyncUccReqBO = new AgrSyncUccReqBO();
        AgrSyncUccReqBO toFrozenAgrSyncUccReqBO = new AgrSyncUccReqBO();
        toUpShelfAgrSyncUccReqBO.setAgrId(agrAgrDo.getAgrId());
        toUpShelfAgrSyncUccReqBO.setOperId(null == agrCreateAgrItemReqBo.getUserId() ? "" : agrCreateAgrItemReqBo.getUserId().toString());
        toUpShelfAgrSyncUccReqBO.setOperName(agrCreateAgrItemReqBo.getUserName());
        toFrozenAgrSyncUccReqBO.setAgrId(agrAgrDo.getAgrId());
        toFrozenAgrSyncUccReqBO.setOperId(null == agrCreateAgrItemReqBo.getUserId() ? "" : agrCreateAgrItemReqBo.getUserId().toString());
        toFrozenAgrSyncUccReqBO.setOperName(agrCreateAgrItemReqBo.getUserName());
        ArrayList<Long> toUpShelfAgrItemIdList = new ArrayList<Long>();
        ArrayList<Long> toFrozenAgrItemIdList = new ArrayList<Long>();
        for (AgrItem agrItem : agrAgrDo.getAgrItem()) {
            if (null == agrItem.getAgrItemId()) continue;
            if (0 == agrItem.getAgrItemStatus()) {
                toFrozenAgrItemIdList.add(agrItem.getAgrItemId());
                continue;
            }
            if (1 != agrItem.getAgrItemStatus()) continue;
            toUpShelfAgrItemIdList.add(agrItem.getAgrItemId());
        }
        String messageContent = "";
        if (!CollectionUtils.isEmpty(toUpShelfAgrItemIdList)) {
            toUpShelfAgrSyncUccReqBO.setAgrItemIds(toUpShelfAgrItemIdList);
            messageContent = this.toUpShelf(toUpShelfAgrSyncUccReqBO);
        }
        if (!CollectionUtils.isEmpty(toFrozenAgrItemIdList)) {
            toFrozenAgrSyncUccReqBO.setAgrItemIds(toFrozenAgrItemIdList);
            messageContent = this.toFrozen(toFrozenAgrSyncUccReqBO);
        }
        this.sendMsg(messageContent);
    }

    private void sendMsg(String content) {
        if (StringUtils.hasText((String)content)) {
            log.info("\u53d1\u6d88\u606f\u540c\u6b65\u5546\u54c1\u5546\u54c1\u4e2d\u5fc3\u5165\u53c2\u4e3a" + content);
            this.agrSyncSkuStatusMqServiceProvider.send(new ProxyMessage(this.agrSkuChangeTopic, this.agrSkuChangeTag, content));
            log.info("\u53d1\u6d88\u606f\u540c\u6b65\u5546\u54c1\u5546\u54c1\u4e2d\u5fc3\u6210\u529f");
        }
    }
}

