/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.StrUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrMainListRspQryBo;
import com.tydic.dyc.agr.service.agr.AgrDealAgrAlertInfoService;
import com.tydic.dyc.agr.service.agr.bo.AgrAlertInfoBO;
import com.tydic.dyc.agr.service.agr.bo.AgrDealAgrAlertInfoReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrDealAgrAlertInfoRspBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrDealAgrAlertInfoService"})
public class AgrDealAgrAlertInfoServiceImpl
implements AgrDealAgrAlertInfoService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @PostMapping(value={"dealAgrAlertInfo"})
    public AgrDealAgrAlertInfoRspBo dealAgrAlertInfo(@RequestBody AgrDealAgrAlertInfoReqBo reqBo) {
        List notInAgrIds;
        AgrAlertInfoBO qryWarningAgrAlertInfoBO = new AgrAlertInfoBO();
        qryWarningAgrAlertInfoBO.setAlertState(AgrCommConstant.AgrAlertStatus.NOT_DEAL);
        List<AgrAlertInfoBO> warningAgrAlertInfoBOList = this.iAgrAgrModel.qryAgrAlertInfoList(qryWarningAgrAlertInfoBO);
        warningAgrAlertInfoBOList.forEach(warningAgrAlertInfoBO -> warningAgrAlertInfoBO.setAlertState(AgrCommConstant.AgrAlertStatus.TO_BE_DEAL));
        if (CollectionUtils.isNotEmpty(warningAgrAlertInfoBOList)) {
            this.iAgrAgrModel.updateAgrAlertStatus(warningAgrAlertInfoBOList);
        }
        List warningAgrIds = warningAgrAlertInfoBOList.stream().map(AgrAlertInfoBO::getObjId).distinct().collect(Collectors.toList());
        List agrIdsAsString = reqBo.getAgrIds().stream().map(Object::toString).collect(Collectors.toList());
        List notInWarningAgrIds = agrIdsAsString.stream().filter(id -> !warningAgrIds.contains(id)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(notInWarningAgrIds)) {
            List<Long> insertAgrIds = notInWarningAgrIds.stream().map(Long::parseLong).collect(Collectors.toList());
            AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
            agrAgrQryBo.setAgrIds(insertAgrIds);
            agrAgrQryBo.setPageNo(-1);
            agrAgrQryBo.setPageSize(-1);
            AgrGetAgrMainListRspQryBo agrMainList = this.iAgrAgrModel.getAgrMainList(agrAgrQryBo);
            Map<Long, AgrAgrDo> agrMap = agrMainList.getRows().stream().collect(Collectors.toMap(AgrAgrDo::getAgrId, agrAgrDo -> agrAgrDo, (k1, k2) -> k1));
            ArrayList<AgrAlertInfoBO> newAgrAlertInfoBOList = new ArrayList<AgrAlertInfoBO>(notInWarningAgrIds.size());
            for (String agrId : notInWarningAgrIds) {
                String[] split;
                AgrAgrDo agrAgrDo2 = agrMap.get(Long.parseLong(agrId));
                AgrAlertInfoBO agrAlertInfoBO = new AgrAlertInfoBO();
                agrAlertInfoBO.setObjId(agrId);
                agrAlertInfoBO.setObjType(AgrCommConstant.AgrAlertType.EXPIRE);
                agrAlertInfoBO.setAlertType(AgrCommConstant.AgrAlertType.EXPIRE);
                agrAlertInfoBO.setCreateTime(new Date());
                agrAlertInfoBO.setAlertState(AgrCommConstant.AgrAlertStatus.NOT_DEAL);
                agrAlertInfoBO.setCreateUserId(agrAgrDo2.getUpdateLoginId());
                if (StrUtil.isNotEmpty((CharSequence)agrAgrDo2.getCreateCompanyIds())) {
                    split = agrAgrDo2.getCreateCompanyIds().split(",");
                    agrAlertInfoBO.setCreateOrgId(Long.valueOf(Long.parseLong(split[0])));
                    agrAlertInfoBO.setCreateCompanyId(Long.valueOf(Long.parseLong(split[0])));
                }
                if (StrUtil.isNotEmpty((CharSequence)agrAgrDo2.getCreateCompanyNames())) {
                    split = agrAgrDo2.getCreateCompanyNames().split(",");
                    agrAlertInfoBO.setCreateOrgName(split[0]);
                    agrAlertInfoBO.setCreateCompanyName(split[0]);
                }
                if (StrUtil.isNotEmpty((CharSequence)agrAgrDo2.getCreateOrgTreePaths())) {
                    split = agrAgrDo2.getCreateOrgTreePaths().split(",");
                    agrAlertInfoBO.setCreateOrgPath(split[0]);
                }
                newAgrAlertInfoBOList.add(agrAlertInfoBO);
            }
            this.iAgrAgrModel.createAgrAlertInfo(newAgrAlertInfoBOList);
        }
        List keepWarningAgrIds = agrIdsAsString.stream().filter(warningAgrIds::contains).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(keepWarningAgrIds)) {
            ArrayList<AgrAlertInfoBO> keepWarningAgrBOList = new ArrayList<AgrAlertInfoBO>(keepWarningAgrIds.size());
            for (String keepWarningAgrId : keepWarningAgrIds) {
                AgrAlertInfoBO agrAlertInfoBO = new AgrAlertInfoBO();
                agrAlertInfoBO.setObjId(keepWarningAgrId);
                agrAlertInfoBO.setAlertState(AgrCommConstant.AgrAlertStatus.NOT_DEAL);
                keepWarningAgrBOList.add(agrAlertInfoBO);
            }
            this.iAgrAgrModel.updateAgrAlertInfo(keepWarningAgrBOList);
        }
        if (CollectionUtils.isNotEmpty(notInAgrIds = warningAgrIds.stream().filter(id -> !agrIdsAsString.contains(id)).collect(Collectors.toList()))) {
            ArrayList<AgrAlertInfoBO> dealedAgrBOList = new ArrayList<AgrAlertInfoBO>(notInAgrIds.size());
            for (String dealedAgrId : notInAgrIds) {
                AgrAlertInfoBO agrAlertInfoBO = new AgrAlertInfoBO();
                agrAlertInfoBO.setObjId(dealedAgrId);
                agrAlertInfoBO.setAlertState(AgrCommConstant.AgrAlertStatus.DEALED);
                dealedAgrBOList.add(agrAlertInfoBO);
            }
            this.iAgrAgrModel.updateAgrAlertInfo(dealedAgrBOList);
        }
        return AgrRu.success(AgrDealAgrAlertInfoRspBo.class);
    }
}

