/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListPriceExecutionQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListPriceExecutionQryRspPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.model.agrchange.sub.AgrItemChng;
import com.tydic.dyc.agr.service.agr.AgrDealAgrItemPriceExecutionSyncService;
import com.tydic.dyc.agr.service.agr.bo.AgrDealAgrItemPriceExecutionSyncReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrDealAgrItemPriceExecutionSyncRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrItemPriceExecutionBo;
import com.tydic.dyc.agr.service.agr.bo.AgrJnAgrSyncItemBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSkuChangePriceBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSyncUccReqBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrDealAgrItemPriceExecutionSyncService"})
public class AgrDealAgrItemPriceExecutionSyncServiceImpl
implements AgrDealAgrItemPriceExecutionSyncService {
    private static final Logger log = LoggerFactory.getLogger(AgrDealAgrItemPriceExecutionSyncServiceImpl.class);
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Value(value="${AGR_SKU_CHANGE_TOPIC}")
    private String agrSkuChangeTopic;
    @Value(value="${AGR_SKU_CHANGE_TAG}")
    private String agrSkuChangeTag;
    @Resource(name="agrSyncSkuStatusMqServiceProvider")
    private ProxyMessageProducer agrSyncSkuStatusMqServiceProvider;

    @PostMapping(value={"dealAgrItemPriceExecutionSync"})
    public AgrDealAgrItemPriceExecutionSyncRspBo dealAgrItemPriceExecutionSync(@RequestBody AgrDealAgrItemPriceExecutionSyncReqBo reqBo) {
        AgrDealAgrItemPriceExecutionSyncRspBo rspBo = new AgrDealAgrItemPriceExecutionSyncRspBo();
        Long agrId = this.getAgrId(reqBo);
        List<String> extAgrItemIds = reqBo.getAgrItem().stream().map(AgrJnAgrSyncItemBo::getExtAgrItemId).distinct().collect(Collectors.toList());
        AgrItemListQryReqPageBo agrItemListQryReqPageBo = new AgrItemListQryReqPageBo();
        agrItemListQryReqPageBo.setAgrId(agrId);
        agrItemListQryReqPageBo.setExtAgrItemIds(extAgrItemIds);
        agrItemListQryReqPageBo.setPageNo(-1);
        agrItemListQryReqPageBo.setPageSize(-1);
        AgrItemListQryRspPageBo agrItemList = this.iAgrAgrModel.getAgrItemList(agrItemListQryReqPageBo);
        Map<String, AgrItem> agrItemExtAgrItemIdMap = agrItemList.getRows().stream().collect(Collectors.toMap(AgrItem::getExtAgrItemId, item -> item));
        List<Long> agrItemIds = agrItemList.getRows().stream().map(AgrItem::getAgrItemId).distinct().collect(Collectors.toList());
        AgrItemListPriceExecutionQryReqPageBo agrItemListPriceExecutionQryReqPageBo = new AgrItemListPriceExecutionQryReqPageBo();
        agrItemListPriceExecutionQryReqPageBo.setAgrItemIds(agrItemIds);
        agrItemListPriceExecutionQryReqPageBo.setPageNo(-1);
        agrItemListPriceExecutionQryReqPageBo.setPageSize(-1);
        AgrItemListPriceExecutionQryRspPageBo agrItemPriceExecutionList = this.iAgrAgrModel.getAgrItemPriceExecutionList(agrItemListPriceExecutionQryReqPageBo);
        Map<String, AgrItemPriceExecutionBo> existPriceExecutionMap = agrItemPriceExecutionList.getRows().stream().filter(item -> item.getExtItemPriceExecutionId() != null && !item.getExtItemPriceExecutionId().isEmpty()).collect(Collectors.toMap(AgrItemPriceExecutionBo::getExtItemPriceExecutionId, item -> item, (existing, replacement) -> existing));
        this.dealAgrItemListPriceExecution(reqBo, agrItemExtAgrItemIdMap, existPriceExecutionMap);
        if (2 == reqBo.getAuditStatus()) {
            List<AgrItemChng> agrItemChngs = this.updateAgrItemPrice(reqBo, agrId, agrItemExtAgrItemIdMap);
            this.syncAgrItemAjustPriceData(agrItemChngs, agrId);
        } else if (1 == reqBo.getAuditStatus()) {
            this.stopAgrItemList(agrItemList);
        } else if (3 == reqBo.getAuditStatus()) {
            this.enableAgrItemList(agrItemList);
            AgrSyncUccReqBO agrSyncUccReqBO = new AgrSyncUccReqBO();
            agrSyncUccReqBO.setAgrIds(Collections.singletonList(agrId));
            agrSyncUccReqBO.setAgrItemIds(agrItemIds);
            this.toUpShelf(agrSyncUccReqBO, reqBo);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setAgrId(agrId);
        rspBo.setAgrItemIds(agrItemIds);
        return rspBo;
    }

    private void dealAgrItemListPriceExecution(AgrDealAgrItemPriceExecutionSyncReqBo reqBo, Map<String, AgrItem> agrItemExtAgrItemIdMap, Map<String, AgrItemPriceExecutionBo> existPriceExecutionMap) {
        ArrayList<AgrItemPriceExecutionBo> addAgrItemPriceExecutionBoList = new ArrayList<AgrItemPriceExecutionBo>();
        ArrayList<AgrItemPriceExecutionBo> updateAgrItemPriceExecutionBoList = new ArrayList<AgrItemPriceExecutionBo>();
        reqBo.getAgrItem().forEach(item -> {
            if (agrItemExtAgrItemIdMap.containsKey(item.getExtAgrItemId())) {
                item.getAgrItemPriceExecutionBoList().forEach(execution -> {
                    if (existPriceExecutionMap.containsKey(execution.getExtItemPriceExecutionId())) {
                        execution.setId(((AgrItemPriceExecutionBo)existPriceExecutionMap.get(execution.getExtItemPriceExecutionId())).getId());
                        execution.setTaxPrice(execution.getNetUnitPrice().add(((AgrItem)agrItemExtAgrItemIdMap.get(item.getExtAgrItemId())).getTaxRate().movePointLeft(2).multiply(execution.getNetUnitPrice())));
                        execution.setAuditStatus(reqBo.getAuditStatus());
                        execution.setAuditId(reqBo.getAuditId());
                        updateAgrItemPriceExecutionBoList.add((AgrItemPriceExecutionBo)execution);
                    } else {
                        execution.setAgrItemId(((AgrItem)agrItemExtAgrItemIdMap.get(item.getExtAgrItemId())).getAgrItemId());
                        execution.setAuditStatus(reqBo.getAuditStatus());
                        execution.setAuditId(reqBo.getAuditId());
                        execution.setTaxPrice(execution.getNetUnitPrice().add(((AgrItem)agrItemExtAgrItemIdMap.get(item.getExtAgrItemId())).getTaxRate().movePointLeft(2).multiply(execution.getNetUnitPrice())));
                        addAgrItemPriceExecutionBoList.add((AgrItemPriceExecutionBo)execution);
                    }
                });
            }
        });
        this.iAgrAgrModel.createAgrItemPriceExecution(addAgrItemPriceExecutionBoList);
        this.iAgrAgrModel.updateAgrItemPriceExecution(updateAgrItemPriceExecutionBoList);
    }

    private List<AgrItemChng> updateAgrItemPrice(AgrDealAgrItemPriceExecutionSyncReqBo reqBo, Long agrId, Map<String, AgrItem> agrItemExtAgrItemIdMap) {
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        agrAgrDo.setAgrId(agrId);
        ArrayList<AgrItem> updateAgrItemList = new ArrayList<AgrItem>();
        ArrayList<AgrItemChng> agrItemChngs = new ArrayList<AgrItemChng>();
        for (AgrJnAgrSyncItemBo agrJnAgrSyncItemBo : reqBo.getAgrItem()) {
            List list = agrJnAgrSyncItemBo.getAgrItemPriceExecutionBoList();
            Optional<AgrItemPriceExecutionBo> latestItem = list.stream().max(Comparator.comparing(AgrItemPriceExecutionBo::getExecutionEffDate));
            AgrItemPriceExecutionBo latest = latestItem.orElse(null);
            if (latest == null || !agrItemExtAgrItemIdMap.containsKey(agrJnAgrSyncItemBo.getExtAgrItemId())) continue;
            AgrItem agrItem = new AgrItem();
            agrItem.setAgrItemId(agrItemExtAgrItemIdMap.get(agrJnAgrSyncItemBo.getExtAgrItemId()).getAgrItemId());
            BigDecimal taxPrice = latest.getNetUnitPrice().add(agrItemExtAgrItemIdMap.get(agrJnAgrSyncItemBo.getExtAgrItemId()).getTaxRate().movePointLeft(2).multiply(latest.getNetUnitPrice()));
            BigDecimal taxAmount = taxPrice.multiply(agrItemExtAgrItemIdMap.get(agrJnAgrSyncItemBo.getExtAgrItemId()).getBuyNumber());
            agrItem.setNoTaxPrice(latest.getNetUnitPrice());
            agrItem.setNoTaxAmount(latest.getNetUnitPrice().multiply(agrItemExtAgrItemIdMap.get(agrJnAgrSyncItemBo.getExtAgrItemId()).getBuyNumber()));
            agrItem.setBuyPrice(taxPrice);
            agrItem.setBuyPriceSum(taxAmount);
            agrItem.setSalePrice(taxPrice);
            agrItem.setSalePriceSum(taxAmount);
            agrItem.setTaxPrice(taxPrice);
            agrItem.setTaxAmount(taxAmount);
            agrItem.setAgrItemStatus(1);
            updateAgrItemList.add(agrItem);
            AgrItemChng agrItemChng = new AgrItemChng();
            agrItemChng.setAgrItemId(agrItemExtAgrItemIdMap.get(agrJnAgrSyncItemBo.getExtAgrItemId()).getAgrItemId());
            agrItemChng.setBuyPrice(taxPrice);
            agrItemChng.setSalePrice(taxPrice);
            agrItemChngs.add(agrItemChng);
        }
        agrAgrDo.setAgrItem(updateAgrItemList);
        this.iAgrAgrModel.updateAgrItemByBatch(agrAgrDo);
        return agrItemChngs;
    }

    private Long getAgrId(AgrDealAgrItemPriceExecutionSyncReqBo reqBO) {
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrCode(reqBO.getAgrCode());
        AgrAgrDo agrAgrDo = this.iAgrAgrModel.getAgrMain(agrAgrQryBo);
        if (null == agrAgrDo) {
            throw new BaseBusinessException("22000", "\u534f\u8bae\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return agrAgrDo.getAgrId();
    }

    private void syncAgrItemAjustPriceData(List<AgrItemChng> agrItemChngs, Long agrId) {
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrId(agrId);
        AgrAgrDo agrMain = this.iAgrAgrModel.getAgrMain(agrAgrQryBo);
        Integer agrStatus = agrMain.getAgrStatus();
        ArrayList skuChangePriceBOs = new ArrayList();
        agrItemChngs.forEach(agrItemChng -> {
            AgrSkuChangePriceBO agrSkuChangePriceBO = new AgrSkuChangePriceBO();
            agrSkuChangePriceBO.setAgreementId(agrId);
            agrSkuChangePriceBO.setAgreementSkuId(agrItemChng.getAgrItemId());
            agrSkuChangePriceBO.setThawFlag(Integer.valueOf(AgrCommConstant.AgreementStatus.ENABLE.equals(agrStatus) ? 1 : 0));
            try {
                agrSkuChangePriceBO.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)agrItemChng.getSalePrice()));
                agrSkuChangePriceBO.setBuyPrice(MoneyUtils.BigDecimal2Long((BigDecimal)agrItemChng.getBuyPrice()));
            }
            catch (Exception e) {
                log.info(e.getMessage());
            }
            skuChangePriceBOs.add(agrSkuChangePriceBO);
        });
        HashMap<String, Serializable> content = new HashMap<String, Serializable>();
        content.put("skuChangePriceBOs", skuChangePriceBOs);
        content.put("changeType", AgrCommConstant.AgrChangeOperType.PRICE);
        this.sendMsg(JSON.toJSONString(content));
    }

    private void stopAgrItemList(AgrItemListQryRspPageBo agrItemList) {
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        ArrayList<AgrItem> updateAgrItemList = new ArrayList<AgrItem>();
        for (AgrItem row : agrItemList.getRows()) {
            AgrItem agrItem = new AgrItem();
            agrItem.setAgrItemId(row.getAgrItemId());
            agrItem.setAgrItemStatus(0);
            updateAgrItemList.add(agrItem);
        }
        agrAgrDo.setAgrItem(updateAgrItemList);
        this.iAgrAgrModel.updateAgrItemByBatch(agrAgrDo);
    }

    private void enableAgrItemList(AgrItemListQryRspPageBo agrItemList) {
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        ArrayList<AgrItem> updateAgrItemList = new ArrayList<AgrItem>();
        for (AgrItem row : agrItemList.getRows()) {
            AgrItem agrItem = new AgrItem();
            agrItem.setAgrItemId(row.getAgrItemId());
            agrItem.setAgrItemStatus(1);
            updateAgrItemList.add(agrItem);
        }
        agrAgrDo.setAgrItem(updateAgrItemList);
        this.iAgrAgrModel.updateAgrItemByBatch(agrAgrDo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void toUpShelf(AgrSyncUccReqBO agrSyncUccReqBO, AgrDealAgrItemPriceExecutionSyncReqBo reqBO) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        List<Object> agreementIds = new ArrayList<Long>();
        List<Object> agreementItemIds = new ArrayList();
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrId(this.getAgrId(reqBO));
        AgrAgrDo agrDetail = this.iAgrAgrModel.getAgrDetail(agrAgrQryBo);
        if (agrDetail.getAgrType().equals(AgrCommConstant.AgrType.AGR)) {
            List<AgrItem> agrItems = this.iAgrAgrModel.checkAgrItemUnfreeze(agrSyncUccReqBO);
            if (!CollectionUtil.isNotEmpty(agrItems)) return;
            agreementIds = agrItems.stream().map(AgrItem::getAgrId).distinct().collect(Collectors.toList());
            agreementItemIds = agrItems.stream().map(AgrItem::getAgrItemId).distinct().collect(Collectors.toList());
        } else {
            if (CollectionUtil.isNotEmpty((Collection)agrSyncUccReqBO.getAgrItemIds())) {
                agreementItemIds.addAll(agrSyncUccReqBO.getAgrItemIds());
            }
            agreementIds.add(agrSyncUccReqBO.getAgrId());
        }
        content.put("changeType", AgrCommConstant.AgrChangeOperType.THAW);
        content.put("agreementIds", agreementIds.stream().distinct().collect(Collectors.toList()));
        content.put("agreementSkuIds", agreementItemIds.stream().distinct().collect(Collectors.toList()));
        content.put("operId", agrSyncUccReqBO.getOperId());
        content.put("operName", agrSyncUccReqBO.getOperName());
        this.sendMsg(JSON.toJSONString(content));
    }

    private void sendMsg(String content) {
        if (StringUtils.hasText((String)content)) {
            log.info("\u53d1\u6d88\u606f\u540c\u6b65\u5546\u54c1\u5546\u54c1\u4e2d\u5fc3\u5165\u53c2\u4e3a" + content);
            this.agrSyncSkuStatusMqServiceProvider.send(new ProxyMessage(this.agrSkuChangeTopic, this.agrSkuChangeTag, content));
            log.info("\u53d1\u6d88\u606f\u540c\u6b65\u5546\u54c1\u5546\u54c1\u4e2d\u5fc3\u6210\u529f");
        }
    }
}

