/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.components.es.AgrElasticsearchUtil;
import com.tydic.dyc.agr.config.AgrIndexConfig;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrListQryRspPageBo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyListQryReqPageBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyListQryRspPageBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyListRspBO;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.model.agrchange.sub.AgrChngApply;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.procinst.qrybo.AgrTaskQryBo;
import com.tydic.dyc.agr.service.agr.AgrEsSyncService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrDetailService;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrChngEsBo;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrEsBo;
import com.tydic.dyc.agr.service.agr.bo.AgrEsSyncServiceReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrEsSyncServiceRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrDetailReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrDetailRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrScopeEsBo;
import com.tydic.dyc.agr.service.agr.bo.AgrTastEsBo;
import com.tydic.dyc.agr.service.agrchange.AgrGetAgrChngApplyDetailService;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngApplyDetailReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngApplyDetailRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.utils.JUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrEsSyncService"})
public class AgrEsSyncServiceImpl
implements AgrEsSyncService {
    private static final Logger log = LoggerFactory.getLogger(AgrEsSyncServiceImpl.class);
    @Autowired
    private AgrIndexConfig agrIndexConfig;
    @Autowired
    private AgrElasticsearchUtil agrElasticsearchUtil;
    @Autowired
    private IAgrAgrModel agrAgrModel;
    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;
    @Autowired
    private AgrGetAgrDetailService agrGetAgrDetailService;
    @Autowired
    private AgrGetAgrChngApplyDetailService agrGetAgrChngApplyDetailService;
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;

    @PostMapping(value={"sync"})
    public AgrEsSyncServiceRspBo sync(@RequestBody AgrEsSyncServiceReqBo reqBo) {
        if (!reqBo.getAll().booleanValue()) {
            if (reqBo.getSyncType().equals("1")) {
                this.syncAgrSingle(reqBo.getAgrId());
            } else {
                this.syncAgrChngSingle(reqBo.getAgrId(), reqBo.getChngApplyId());
            }
        } else {
            this.delIdx(this.agrIndexConfig.getAgrIndex());
            this.syncAgrAll();
            this.syncAgrChngAll();
        }
        return AgrRu.success(AgrEsSyncServiceRspBo.class);
    }

    private void syncAgrSingle(Long agrId) {
        AgrGetAgrDetailReqBo agrGetAgrDetailReqBo = new AgrGetAgrDetailReqBo();
        agrGetAgrDetailReqBo.setAgrId(agrId);
        AgrGetAgrDetailRspBo agrGetAgrDetailRspBo = this.agrGetAgrDetailService.getAgrDetail(agrGetAgrDetailReqBo);
        if (agrGetAgrDetailRspBo != null && agrGetAgrDetailRspBo.getAgrMainSaveBO() != null) {
            ArrayList agrTastEsBos;
            AgrProcInstDo agrProcInstDo;
            AgrTaskQryBo agrTaskQryBo;
            AgrAgrEsBo agrAgrEsBo = AgrRu.js(agrGetAgrDetailRspBo.getAgrMainSaveBO(), AgrAgrEsBo.class);
            agrAgrEsBo.setDataType(Integer.valueOf(1));
            agrAgrEsBo.setAuditProclnstld(agrGetAgrDetailRspBo.getProcInstId());
            if (!StringUtils.isBlank((CharSequence)agrAgrEsBo.getAuditProclnstld())) {
                agrTaskQryBo = new AgrTaskQryBo();
                agrTaskQryBo.setProcInstId(agrAgrEsBo.getAuditProclnstld());
                agrTaskQryBo.setOrderId(agrAgrEsBo.getAgrId());
                agrProcInstDo = this.iAgrProcInstModel.getTaskList(agrTaskQryBo);
                agrTastEsBos = new ArrayList();
                agrProcInstDo.getAgrUocOrderTaskInst().forEach(uocOrderTaskInst -> {
                    AgrTastEsBo agrTastEsBo = AgrRu.js(uocOrderTaskInst, AgrTastEsBo.class);
                    agrTastEsBo.setAuditDealResultQryKey(uocOrderTaskInst.getRemark());
                    agrTastEsBos.add(agrTastEsBo);
                });
                agrAgrEsBo.setAuditTaskList(agrTastEsBos);
            }
            agrAgrEsBo.setBusiProclnstld(this.qryBusiProInstId(AgrCommConstant.ObjType.AGREEMENT, agrAgrEsBo.getAgrId(), agrAgrEsBo.getAgrId()));
            if (!StringUtils.isBlank((CharSequence)agrAgrEsBo.getBusiProclnstld())) {
                agrTaskQryBo = new AgrTaskQryBo();
                agrTaskQryBo.setProcInstId(agrAgrEsBo.getBusiProclnstld());
                agrTaskQryBo.setOrderId(agrAgrEsBo.getAgrId());
                agrProcInstDo = this.iAgrProcInstModel.getTaskList(agrTaskQryBo);
                agrTastEsBos = new ArrayList();
                agrProcInstDo.getAgrUocOrderTaskInst().forEach(uocOrderTaskInst -> {
                    AgrTastEsBo agrTastEsBo = AgrRu.js(uocOrderTaskInst, AgrTastEsBo.class);
                    agrTastEsBo.setAuditDealResultQryKey(uocOrderTaskInst.getRemark());
                    agrTastEsBos.add(agrTastEsBo);
                });
                agrAgrEsBo.setBusiTaskList(agrTastEsBos);
            }
            if (AgrCommConstant.WhetherHaveItemEnum.WHETHER_HAVE_ITEM_YES.getValue().equals(agrAgrEsBo.getWhetherHaveItem())) {
                AgrItemListQryReqPageBo agrItemListQryReqPageBo = new AgrItemListQryReqPageBo();
                agrItemListQryReqPageBo.setAgrId(agrId);
                agrItemListQryReqPageBo.setPageNo(1);
                agrItemListQryReqPageBo.setPageSize(1);
                AgrItemListQryRspPageBo agrItemListQryRspPageBo = this.agrAgrModel.getAgrItemList(agrItemListQryReqPageBo);
                if (agrItemListQryRspPageBo != null && agrItemListQryRspPageBo.getRows() != null) {
                    agrAgrEsBo.setAgrItemCount(agrItemListQryRspPageBo.getRecordsTotal());
                } else {
                    agrAgrEsBo.setAgrItemCount(Integer.valueOf(0));
                }
            }
            if (!CollectionUtils.isEmpty((Collection)agrGetAgrDetailRspBo.getAgrAppScopeBOs())) {
                ArrayList scopeIds = new ArrayList();
                agrGetAgrDetailRspBo.getAgrAppScopeBOs().forEach(agrAppScopeBo -> {
                    AgrScopeEsBo bo = (AgrScopeEsBo)JUtil.js((Object)agrAppScopeBo, AgrScopeEsBo.class);
                    bo.setScopeId(agrAppScopeBo.getScopeCode());
                    scopeIds.add(bo);
                });
                agrAgrEsBo.setScopeIds(scopeIds);
            }
            AgrAgrChngApplyQryBo agrAgrChngApplyQryBo = new AgrAgrChngApplyQryBo();
            agrAgrChngApplyQryBo.setAgrId(agrAgrEsBo.getAgrId());
            agrAgrChngApplyQryBo.setOrderBy("create_time desc LIMIT 1");
            AgrAgrChngApplyListRspBO rspBO = this.iAgrChngApplyModel.getAgrChngApplyList(agrAgrChngApplyQryBo);
            if (rspBO != null && !CollectionUtils.isEmpty(rspBO.getAgrChngApply())) {
                AgrChngApply agrChngApply = rspBO.getAgrChngApply().get(0);
                AgrTaskQryBo agrTaskQryBo2 = new AgrTaskQryBo();
                agrTaskQryBo2.setOrderId(agrAgrEsBo.getAgrId());
                agrTaskQryBo2.setObjId(agrChngApply.getChngApplyId());
                agrTaskQryBo2.setObjType(AgrCommConstant.ObjType.CHANGE);
                agrTaskQryBo2.setFinishTag(AgrCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
                AgrProcInstDo agrProcInstDo2 = this.iAgrProcInstModel.getTaskList(agrTaskQryBo2);
                if (!CollectionUtils.isEmpty(agrProcInstDo2.getAgrUocOrderTaskInst())) {
                    agrAgrEsBo.setHaveProcessingChng(Integer.valueOf(1));
                    agrAgrEsBo.setHaveProcessingChngStr("\u5426");
                } else {
                    agrAgrEsBo.setHaveProcessingChng(Integer.valueOf(2));
                    agrAgrEsBo.setHaveProcessingChngStr("\u662f");
                }
            } else {
                agrAgrEsBo.setHaveProcessingChng(Integer.valueOf(2));
                agrAgrEsBo.setHaveProcessingChngStr("\u662f");
            }
            this.agrElasticsearchUtil.addJsonData(this.agrIndexConfig.getAgrIndex(), agrId.toString(), JSON.toJSONString((Object)agrAgrEsBo));
        }
    }

    private String qryBusiProInstId(Integer objType, Long orderId, Long objId) {
        String procInstId = "";
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        agrProcInstDo.setOrderId(orderId);
        agrProcInstDo.setObjId(objId);
        agrProcInstDo.setObjType(objType);
        agrProcInstDo.setOrderBy("id desc LIMIT 1");
        AgrProcInstDo agrProcInstDo1 = this.iAgrProcInstModel.getProcInst(agrProcInstDo);
        if (agrProcInstDo1 != null) {
            procInstId = agrProcInstDo1.getProcInstId();
        }
        return procInstId;
    }

    private void syncAgrAll() {
        AgrListQryReqPageBo agrListQryReqPageBo = new AgrListQryReqPageBo();
        agrListQryReqPageBo.setPageNo(1);
        agrListQryReqPageBo.setPageSize(1000);
        AgrListQryRspPageBo agrListQryRspPageBo = this.agrAgrModel.getAllAgrList(agrListQryReqPageBo);
        if (!CollectionUtils.isEmpty(agrListQryRspPageBo.getRows())) {
            int total = agrListQryRspPageBo.getTotal();
            for (int i = 1; i <= total; ++i) {
                agrListQryReqPageBo.setPageNo(i);
                agrListQryReqPageBo.setPageSize(1000);
                AgrListQryRspPageBo agrListQryRspPageBo1 = this.agrAgrModel.getAllAgrList(agrListQryReqPageBo);
                agrListQryRspPageBo1.getRows().forEach(agrAgrDo -> this.syncAgrSingle(agrAgrDo.getAgrId()));
            }
        }
    }

    private void syncAgrChngSingle(Long agrId, Long chngApplyId) {
        AgrGetAgrDetailReqBo agrGetAgrDetailReqBo = new AgrGetAgrDetailReqBo();
        agrGetAgrDetailReqBo.setAgrId(agrId);
        AgrGetAgrDetailRspBo agrGetAgrDetailRspBo = this.agrGetAgrDetailService.getAgrDetail(agrGetAgrDetailReqBo);
        if (agrGetAgrDetailRspBo != null && agrGetAgrDetailRspBo.getAgrMainSaveBO() != null) {
            AgrGetAgrChngApplyDetailReqBO applyDetailReqBO = new AgrGetAgrChngApplyDetailReqBO();
            applyDetailReqBO.setAgrId(agrId);
            applyDetailReqBO.setChngApplyId(chngApplyId);
            AgrGetAgrChngApplyDetailRspBO agrChngApplyDetail = this.agrGetAgrChngApplyDetailService.getAgrChngApplyDetail(applyDetailReqBO);
            if (agrChngApplyDetail != null) {
                ArrayList agrTastEsBos;
                AgrProcInstDo agrProcInstDo;
                AgrTaskQryBo agrTaskQryBo;
                AgrAgrChngEsBo agrAgrChngEsBo = AgrRu.js(agrGetAgrDetailRspBo.getAgrMainSaveBO(), AgrAgrChngEsBo.class);
                if (!CollectionUtils.isEmpty((Collection)agrGetAgrDetailRspBo.getAgrAppScopeBOs())) {
                    ArrayList scopeIds = new ArrayList();
                    agrGetAgrDetailRspBo.getAgrAppScopeBOs().forEach(agrAppScopeBo -> {
                        AgrScopeEsBo bo = (AgrScopeEsBo)JUtil.js((Object)agrAppScopeBo, AgrScopeEsBo.class);
                        bo.setScopeId(agrAppScopeBo.getScopeCode());
                        scopeIds.add(bo);
                    });
                    agrAgrChngEsBo.setScopeIds(scopeIds);
                }
                agrAgrChngEsBo.setChngApplyId(agrChngApplyDetail.getChngApplyId());
                agrAgrChngEsBo.setChngApplyNo(agrChngApplyDetail.getChngApplyNo());
                agrAgrChngEsBo.setChngApplyStatus(agrChngApplyDetail.getChngApplyStatus());
                agrAgrChngEsBo.setChngType(agrChngApplyDetail.getChngType());
                agrAgrChngEsBo.setApplyCreateTime(agrChngApplyDetail.getCreateTime());
                agrAgrChngEsBo.setApplyCreateName(agrChngApplyDetail.getCreateName());
                agrAgrChngEsBo.setChngTypeStr(agrChngApplyDetail.getChngTypeStr());
                agrAgrChngEsBo.setChngApplyStatusStr(agrChngApplyDetail.getChngApplyStatusStr());
                agrAgrChngEsBo.setDataType(Integer.valueOf(2));
                agrAgrChngEsBo.setAuditProclnstld(agrChngApplyDetail.getProcInstId());
                if (!StringUtils.isBlank((CharSequence)agrAgrChngEsBo.getAuditProclnstld())) {
                    agrTaskQryBo = new AgrTaskQryBo();
                    agrTaskQryBo.setProcInstId(agrAgrChngEsBo.getAuditProclnstld());
                    agrTaskQryBo.setOrderId(agrAgrChngEsBo.getAgrId());
                    agrProcInstDo = this.iAgrProcInstModel.getTaskList(agrTaskQryBo);
                    agrTastEsBos = new ArrayList();
                    agrProcInstDo.getAgrUocOrderTaskInst().forEach(uocOrderTaskInst -> {
                        AgrTastEsBo agrTastEsBo = AgrRu.js(uocOrderTaskInst, AgrTastEsBo.class);
                        agrTastEsBo.setAuditDealResultQryKey(uocOrderTaskInst.getRemark());
                        agrTastEsBos.add(agrTastEsBo);
                    });
                    agrAgrChngEsBo.setAuditTaskList(agrTastEsBos);
                }
                agrAgrChngEsBo.setBusiProclnstld(this.qryBusiProInstId(AgrCommConstant.ObjType.CHANGE, agrAgrChngEsBo.getAgrId(), agrAgrChngEsBo.getChngApplyId()));
                if (!StringUtils.isBlank((CharSequence)agrAgrChngEsBo.getBusiProclnstld())) {
                    agrTaskQryBo = new AgrTaskQryBo();
                    agrTaskQryBo.setProcInstId(agrAgrChngEsBo.getBusiProclnstld());
                    agrTaskQryBo.setOrderId(agrAgrChngEsBo.getAgrId());
                    agrProcInstDo = this.iAgrProcInstModel.getTaskList(agrTaskQryBo);
                    agrTastEsBos = new ArrayList();
                    agrProcInstDo.getAgrUocOrderTaskInst().forEach(uocOrderTaskInst -> {
                        AgrTastEsBo agrTastEsBo = AgrRu.js(uocOrderTaskInst, AgrTastEsBo.class);
                        agrTastEsBo.setAuditDealResultQryKey(uocOrderTaskInst.getRemark());
                        agrTastEsBos.add(agrTastEsBo);
                    });
                    agrAgrChngEsBo.setBusiTaskList(agrTastEsBos);
                }
                this.agrElasticsearchUtil.addJsonData(this.agrIndexConfig.getAgrIndex(), chngApplyId.toString(), JSON.toJSONString((Object)agrAgrChngEsBo));
            }
        }
    }

    private void syncAgrChngAll() {
        AgrAgrChngApplyListQryReqPageBo agrAgrChngApplyListQryReqPageBo = new AgrAgrChngApplyListQryReqPageBo();
        agrAgrChngApplyListQryReqPageBo.setPageNo(1);
        agrAgrChngApplyListQryReqPageBo.setPageSize(1000);
        AgrAgrChngApplyListQryRspPageBo agrAgrChngApplyListQryRspPageBo = this.iAgrChngApplyModel.getAllChngByPage(agrAgrChngApplyListQryReqPageBo);
        if (!CollectionUtils.isEmpty(agrAgrChngApplyListQryRspPageBo.getRows())) {
            int total = agrAgrChngApplyListQryRspPageBo.getTotal();
            for (int i = 1; i <= total; ++i) {
                agrAgrChngApplyListQryReqPageBo.setPageNo(i);
                agrAgrChngApplyListQryReqPageBo.setPageSize(1000);
                AgrAgrChngApplyListQryRspPageBo agrAgrChngApplyListQryRspPageBo1 = this.iAgrChngApplyModel.getAllChngByPage(agrAgrChngApplyListQryReqPageBo);
                agrAgrChngApplyListQryRspPageBo1.getRows().forEach(agrChngApply -> this.syncAgrChngSingle(agrChngApply.getAgrId(), agrChngApply.getChngApplyId()));
            }
        }
    }

    private void delIdx(String idx) {
        block2: {
            try {
                this.agrElasticsearchUtil.deleteIndex(idx);
            }
            catch (Exception e) {
                String eCause = JSON.toJSONString((Object)e.getCause());
                log.error(eCause);
                if (!eCause.contains("index_not_found_exception")) break block2;
                log.info("\u7d22\u5f15\u4e0d\u5b58\u5728");
            }
        }
    }
}

