/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrMainListRspQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.model.sysDicDictionary.IAgrDictionaryModel;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.DicDictionaryBo;
import com.tydic.dyc.agr.service.agr.AgrGetAgrItemListService;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrGetAgrItemListService"})
public class AgrGetAgrItemListServiceImpl
implements AgrGetAgrItemListService {
    private static final Logger log = LoggerFactory.getLogger(AgrGetAgrItemListServiceImpl.class);
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Autowired
    private IAgrDictionaryModel iAgrDictionaryModel;

    @PostMapping(value={"getAgrItemList"})
    public AgrGetAgrItemListRspBO getAgrItemList(@RequestBody AgrGetAgrItemListReqBO reqBO) {
        AgrItemListQryReqPageBo agrItemListQryReqPageBo = AgrRu.js(reqBO, AgrItemListQryReqPageBo.class);
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = this.iAgrAgrModel.getAgrItemList(agrItemListQryReqPageBo);
        List<Long> agrIds = agrItemListQryRspPageBo.getRows().stream().map(AgrItem::getAgrId).distinct().collect(Collectors.toList());
        HashMap<Long, AgrAgrDo> agrMap = new HashMap(agrIds.size());
        if (CollectionUtil.isNotEmpty(agrIds)) {
            AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
            agrAgrQryBo.setAgrIds(agrIds);
            agrAgrQryBo.setPageNo(-1);
            agrAgrQryBo.setPageSize(-1);
            AgrGetAgrMainListRspQryBo agrMainList = this.iAgrAgrModel.getAgrMainList(agrAgrQryBo);
            agrMap = agrMainList.getRows().stream().collect(Collectors.toMap(AgrAgrDo::getAgrId, agrAgrDo -> agrAgrDo, (k1, k2) -> k1));
        }
        AgrGetAgrItemListRspBO rspBO = (AgrGetAgrItemListRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)agrItemListQryRspPageBo), AgrGetAgrItemListRspBO.class);
        ArrayList<String> pCodeList = new ArrayList<String>();
        pCodeList.add("AGR_ITEM_IS_CONTROL_PCODE");
        pCodeList.add("AGR_ITEM_IS_PRICE_ADJUST_PCODE");
        pCodeList.add("AGR_ITEM_STATUS_PCODE");
        pCodeList.add("AGR_ITEM_IS_SUPERMARKET");
        pCodeList.add("AGR_ITEM_IS_CENTRALIZED_PURCHASING");
        pCodeList.add("AGR_PUR_TYPE");
        Map<String, Map<String, DicDictionaryBo>> dicMap = this.iAgrDictionaryModel.selectByPCodeListToMap(pCodeList);
        this.translation(rspBO, dicMap, agrMap);
        log.debug("\u534f\u8bae\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)rspBO));
        return rspBO;
    }

    private void translation(AgrGetAgrItemListRspBO rspBO, Map<String, Map<String, DicDictionaryBo>> dicMap, Map<Long, AgrAgrDo> agrMap) {
        List rows;
        if (rspBO != null && !CollectionUtils.isEmpty((Collection)(rows = rspBO.getRows()))) {
            rows.forEach(x -> {
                Integer whetherOil;
                if (agrMap.containsKey(x.getAgrId())) {
                    x.setAgrCode(((AgrAgrDo)agrMap.get(x.getAgrId())).getAgrCode());
                    x.setPurType(((AgrAgrDo)agrMap.get(x.getAgrId())).getPurType());
                    if (x.getPurType() != null) {
                        x.setPurTypeStr(MapUtil.isEmpty((Map)((Map)dicMap.get("AGR_PUR_TYPE"))) ? null : ((DicDictionaryBo)((Map)dicMap.get("AGR_PUR_TYPE")).get(x.getPurType().toString())).getTitle());
                    }
                }
                if ((whetherOil = x.getWhetherOil()) != null) {
                    x.setWhetherOilStr(AgrCommConstant.IsOilPcodeEnum.getValueByCode((Integer)whetherOil));
                }
                if (x.getIsControlPurchaseNum() != null) {
                    x.setIsControlPurchaseNumStr(MapUtil.isEmpty((Map)((Map)dicMap.get("AGR_ITEM_IS_CONTROL_PCODE"))) ? null : ((DicDictionaryBo)((Map)dicMap.get("AGR_ITEM_IS_CONTROL_PCODE")).get(x.getIsControlPurchaseNum().toString())).getTitle());
                }
                if (x.getIsPriceAdjust() != null) {
                    x.setIsPriceAdjustStr(MapUtil.isEmpty((Map)((Map)dicMap.get("AGR_ITEM_IS_PRICE_ADJUST_PCODE"))) ? null : ((DicDictionaryBo)((Map)dicMap.get("AGR_ITEM_IS_PRICE_ADJUST_PCODE")).get(x.getIsPriceAdjust().toString())).getTitle());
                }
                if (x.getAgrItemStatus() != null) {
                    x.setAgrItemStatusStr(MapUtil.isEmpty((Map)((Map)dicMap.get("AGR_ITEM_STATUS_PCODE"))) ? null : ((DicDictionaryBo)((Map)dicMap.get("AGR_ITEM_STATUS_PCODE")).get(x.getAgrItemStatus().toString())).getTitle());
                }
                if (x.getIsSupermarket() != null) {
                    x.setIsSupermarketStr(MapUtil.isEmpty((Map)((Map)dicMap.get("AGR_ITEM_IS_SUPERMARKET"))) ? null : ((DicDictionaryBo)((Map)dicMap.get("AGR_ITEM_IS_SUPERMARKET")).get(x.getIsSupermarket().toString())).getTitle());
                }
                if (x.getIsCentralizedPurchasing() != null) {
                    x.setIsCentralizedPurchasingStr(MapUtil.isEmpty((Map)((Map)dicMap.get("AGR_ITEM_IS_CENTRALIZED_PURCHASING"))) ? null : ((DicDictionaryBo)((Map)dicMap.get("AGR_ITEM_IS_CENTRALIZED_PURCHASING")).get(x.getIsCentralizedPurchasing().toString())).getTitle());
                }
                if (StrUtil.isNotBlank((CharSequence)x.getPurchaseOrgTreePath())) {
                    x.setPurchaseOrgTreePaths(Arrays.asList(x.getPurchaseOrgTreePath().split(",")));
                }
            });
        }
    }
}

