/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.bo.CfcEncodedRuleBO;
import com.tydic.cfc.ability.bo.CfcEncodedRuleDetailedBO;
import com.tydic.cfc.ability.bo.CfcEncodedRuleSyncBO;
import com.tydic.cfc.busi.api.CfcDictionaryBusiService;
import com.tydic.cfc.busi.api.CfcEncodedRuleUpdateListBusiService;
import com.tydic.cfc.busi.bo.CfcEncodedRuleUpdateListBusiReqBO;
import com.tydic.cfc.busi.bo.CfcEncodedRuleUpdateListBusiRspBO;
import com.tydic.cfc.constants.CfcCommConstant;
import com.tydic.cfc.dao.CfcEncodedGroupMapper;
import com.tydic.cfc.dao.CfcEncodedRuleDetailedMapper;
import com.tydic.cfc.dao.CfcEncodedRuleMapper;
import com.tydic.cfc.exceptions.CfcBusinessException;
import com.tydic.cfc.po.CfcEncodedGroup;
import com.tydic.cfc.po.CfcEncodedRuleDetailedPO;
import com.tydic.cfc.po.CfcEncodedRulePO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CfcEncodedRuleUpdateListBusiServiceImpl
implements CfcEncodedRuleUpdateListBusiService {
    @Autowired
    private CfcEncodedRuleMapper cfcEncodedRuleMapper;
    @Autowired
    private CfcEncodedRuleDetailedMapper cfcEncodedRuleDetailedMapper;
    @Autowired
    private CfcEncodedGroupMapper cfcEncodedGroupMapper;
    @Autowired
    private CfcDictionaryBusiService dictionaryAbilityService;

    @Override
    public CfcEncodedRuleUpdateListBusiRspBO updateCfcEncodedRuleUpdateList(CfcEncodedRuleUpdateListBusiReqBO reqBO) {
        CfcEncodedRuleUpdateListBusiRspBO rspBO = new CfcEncodedRuleUpdateListBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Map<String, String> replaceType = this.dictionaryAbilityService.queryBypCodeBackMap("ENCODED_RULE_DETAILED_REPLACE_TYPE");
        Map<String, String> busiTypeMap = this.dictionaryAbilityService.queryBypCodeBackMap("ENCODED_RULE_BUSI_TYPE");
        ArrayList<CfcEncodedRuleSyncBO> syncBOS = new ArrayList<CfcEncodedRuleSyncBO>();
        for (CfcEncodedRuleBO bo : reqBO.getCfcEncodedRuleBOList()) {
            CfcEncodedRulePO cfcEncodedRulePO = new CfcEncodedRulePO();
            cfcEncodedRulePO.setId(bo.getId());
            cfcEncodedRulePO.setOperateName(reqBO.getName());
            cfcEncodedRulePO.setOperateNo(reqBO.getMemIdIn());
            cfcEncodedRulePO.setOperateTime(new Date());
            this.updateCfcEncodedRule(bo, cfcEncodedRulePO, replaceType, busiTypeMap);
            cfcEncodedRulePO = this.cfcEncodedRuleMapper.selectByPrimaryKey(cfcEncodedRulePO.getId());
            CfcEncodedRuleBO cfcEncodedRuleBO = new CfcEncodedRuleBO();
            BeanUtils.copyProperties((Object)cfcEncodedRulePO, (Object)cfcEncodedRuleBO);
            cfcEncodedRuleBO.setRestartFlag(reqBO.getRestartFlag());
            CfcEncodedRuleSyncBO syncBO = new CfcEncodedRuleSyncBO();
            syncBO.setId(cfcEncodedRuleBO.getId());
            syncBO.setRestartFlag(cfcEncodedRuleBO.getRestartFlag());
            syncBO.setCenter(cfcEncodedRulePO.getCenter());
            syncBOS.add(syncBO);
        }
        this.updateEncodeGroup(reqBO);
        rspBO.setSyncBOLIst(syncBOS);
        return rspBO;
    }

    private void updateCfcEncodedRule(CfcEncodedRuleBO bo, CfcEncodedRulePO cfcEncodedRulePO, Map<String, String> replaceType, Map<String, String> busiTypeMap) {
        String encodedRuleStyle = "";
        Integer encodeEffCode = CfcCommConstant.EncodeEffFlag.NONE.getCode();
        DateTime nowTime = DateTime.now();
        ArrayList<CfcEncodedRuleDetailedPO> cfcEncodedRuleDetailedPOS = new ArrayList<CfcEncodedRuleDetailedPO>();
        if (bo.getDetaileds() != null && bo.getDetaileds().size() > 0) {
            int orderId = 1;
            for (CfcEncodedRuleDetailedBO itemBO : bo.getDetaileds()) {
                CfcEncodedRuleDetailedPO cfcEncodedRuleDetailedPO = new CfcEncodedRuleDetailedPO();
                itemBO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                itemBO.setEncodedRuleId(cfcEncodedRulePO.getId());
                itemBO.setOrderId(Integer.valueOf(orderId));
                ++orderId;
                if ("text".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + itemBO.getDetailedContent();
                } else if ("year".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + nowTime.toString("yyyy");
                    encodeEffCode = encodeEffCode > CfcCommConstant.EncodeEffFlag.YEAR.getCode() ? encodeEffCode : CfcCommConstant.EncodeEffFlag.YEAR.getCode();
                } else if ("month".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + nowTime.toString("MM");
                    encodeEffCode = encodeEffCode > CfcCommConstant.EncodeEffFlag.MONTH.getCode() ? encodeEffCode : CfcCommConstant.EncodeEffFlag.MONTH.getCode();
                } else if ("day".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + nowTime.toString("dd");
                    encodeEffCode = encodeEffCode > CfcCommConstant.EncodeEffFlag.DAY.getCode() ? encodeEffCode : CfcCommConstant.EncodeEffFlag.DAY.getCode();
                } else if ("date".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + nowTime.toString("yyyyMMdd");
                    encodeEffCode = encodeEffCode > CfcCommConstant.EncodeEffFlag.DATE.getCode() ? encodeEffCode : CfcCommConstant.EncodeEffFlag.DATE.getCode();
                } else if ("replace".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + itemBO.getDetailedStyle();
                } else if ("serial".equals(itemBO.getDetailedType())) {
                    int serial;
                    if (StringUtils.isEmpty((Object)itemBO.getDetailedContent())) {
                        itemBO.setDetailedContent("4");
                    }
                    if ((serial = Integer.parseInt(itemBO.getDetailedContent())) > 0) {
                        for (int i = 1; i < serial; ++i) {
                            encodedRuleStyle = encodedRuleStyle + "0";
                        }
                        encodedRuleStyle = encodedRuleStyle + "1";
                    }
                } else if ("busiType".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + busiTypeMap.get(itemBO.getDetailedContent());
                    itemBO.setDetailedContent(busiTypeMap.get(itemBO.getDetailedType()));
                } else if ("orgCode".equals(itemBO.getDetailedType())) {
                    CfcEncodedRulePO oriRule;
                    String orgCodeStr = itemBO.getDetailedContent();
                    if (StringUtils.isEmpty((Object)itemBO.getDetailedContent()) && null != (oriRule = this.cfcEncodedRuleMapper.selectByPrimaryKey(cfcEncodedRulePO.getId()))) {
                        CfcEncodedRuleBO cfcBO = new CfcEncodedRuleBO();
                        cfcBO.setCenter(oriRule.getCenter());
                        cfcBO.setEncodedRuleCode(oriRule.getEncodedRuleCode());
                        cfcBO.setEncodedRuleType("1");
                        List<CfcEncodedRulePO> cfcEncodedRulePOS = this.cfcEncodedRuleMapper.getList(cfcBO);
                        if (!CollectionUtils.isEmpty(cfcEncodedRulePOS)) {
                            CfcEncodedRulePO mainPO = cfcEncodedRulePOS.get(0);
                            orgCodeStr = mainPO.getRelCode();
                        }
                    }
                    encodedRuleStyle = encodedRuleStyle + orgCodeStr;
                    itemBO.setDetailedContent(orgCodeStr);
                    itemBO.setDetailedStyle(orgCodeStr);
                } else if (replaceType.containsKey(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + itemBO.getDetailedContent();
                    itemBO.setDetailedStyle(itemBO.getDetailedContent());
                }
                BeanUtils.copyProperties((Object)itemBO, (Object)cfcEncodedRuleDetailedPO);
                cfcEncodedRuleDetailedPOS.add(cfcEncodedRuleDetailedPO);
            }
        }
        cfcEncodedRulePO.setEffType(CfcCommConstant.EncodeEffFlag.getValueByCode((Integer)encodeEffCode));
        cfcEncodedRulePO.setEncodedRuleStyle(encodedRuleStyle);
        int update = this.cfcEncodedRuleMapper.updateByPrimaryKeySelective(cfcEncodedRulePO);
        if (update < 1) {
            throw new CfcBusinessException("223113", "\u7f16\u7801\u89c4\u5219\u4fee\u6539\u5931\u8d25");
        }
        if (cfcEncodedRuleDetailedPOS.size() > 0) {
            this.cfcEncodedRuleDetailedMapper.deleteByEncodedRuleId(bo.getId());
            update = this.cfcEncodedRuleDetailedMapper.insertBatch(cfcEncodedRuleDetailedPOS);
            if (update < 1) {
                throw new CfcBusinessException("223113", "\u7f16\u7801\u89c4\u5219\u660e\u7ec6\u4fee\u6539\u5931\u8d25");
            }
        }
    }

    private void updateEncodeGroup(CfcEncodedRuleUpdateListBusiReqBO reqBO) {
        List<CfcEncodedRuleBO> cfcEncodedRuleBOList = reqBO.getCfcEncodedRuleBOList();
        CfcEncodedRuleBO ruleBO = cfcEncodedRuleBOList.get(0);
        CfcEncodedGroup groupBO = new CfcEncodedGroup();
        groupBO.setId(ruleBO.getGroupId());
        groupBO.setOperateName(reqBO.getUserName());
        groupBO.setOperateNo(reqBO.getUserId());
        groupBO.setOperateTime(this.cfcEncodedGroupMapper.getDbDate());
        this.cfcEncodedGroupMapper.updateByPrimaryKeySelective(groupBO);
    }
}

