/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.listener;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.cfc.ability.api.CfcTransRollbackAbilityService;
import com.tydic.cfc.ability.bo.CfcTransRollbackReqBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class TransactionConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(TransactionConsumer.class);
    private static final int EXPIRE_TIME = 21600;
    private static final String CONSUME_FLAG = "1";
    @Autowired
    private CfcTransRollbackAbilityService cfcTransRollbackAbilityService;
    @Autowired
    private CacheClient cacheClient;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        String messageId = message.getMessageId();
        String value = (String)this.cacheClient.get(messageId, String.class);
        if (!StringUtils.isEmpty((Object)value)) {
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
        log.info("\u76d1\u542c\u5230\u4e8b\u52a1\u56de\u6eda\u6d88\u606f\uff0c message: {} ", (Object)message.getContent());
        CfcTransRollbackReqBO reqBO = new CfcTransRollbackReqBO();
        reqBO.setTransactionInfo(message.getContent());
        this.cfcTransRollbackAbilityService.doRollback(reqBO);
        this.cacheClient.set(messageId, (Object)CONSUME_FLAG, 21600);
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

