/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.init;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.cfc.dao.CfcServiceParamCheckConfigMapper;
import com.tydic.cfc.po.CfcServiceParamCheckConfigPO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class CfcServiceParamCheckConfigRedisInit
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(CfcServiceParamCheckConfigRedisInit.class);
    @Autowired
    private CfcServiceParamCheckConfigMapper cfcServiceParamCheckConfigMapper;
    @Autowired
    private CacheClient cacheService;

    public void run(String ... args) throws Exception {
        log.info("\u670d\u52a1\u6821\u9a8c\u914d\u7f6e\u67e5\u8be2\u540c\u6b65redis\u5f00\u59cb==========");
        try {
            CfcServiceParamCheckConfigPO cfcServiceParamCheckConfigPO = new CfcServiceParamCheckConfigPO();
            cfcServiceParamCheckConfigPO.setGroupBy(" method_url ");
            List<CfcServiceParamCheckConfigPO> pos = this.cfcServiceParamCheckConfigMapper.getList(cfcServiceParamCheckConfigPO);
            if (!StringUtils.isEmpty(pos)) {
                for (CfcServiceParamCheckConfigPO po : pos) {
                    CfcServiceParamCheckConfigPO cfcServiceParamCheckConfigPO1 = new CfcServiceParamCheckConfigPO();
                    cfcServiceParamCheckConfigPO1.setMethodUrl(po.getMethodUrl());
                    List<CfcServiceParamCheckConfigPO> pos1 = this.cfcServiceParamCheckConfigMapper.getList(cfcServiceParamCheckConfigPO1);
                    if (CollectionUtils.isEmpty(pos1)) continue;
                    Map<String, CfcServiceParamCheckConfigPO> map = pos1.stream().collect(Collectors.toMap(CfcServiceParamCheckConfigPO::getFieldUrl, a -> a, (k1, k2) -> k1));
                    String redisKey = po.getCenter() + "_PARAM_CHECK_" + po.getMethodUrl();
                    this.cacheService.set(redisKey, (Object)JSON.toJSONString(map));
                }
            }
        }
        catch (Exception e) {
            log.error("\u670d\u52a1\u6821\u9a8c\u914d\u7f6e\u67e5\u8be2\u540c\u6b65redis\u5f02\u5e38", (Throwable)e);
        }
        log.info("\u670d\u52a1\u6821\u9a8c\u914d\u7f6e\u67e5\u8be2\u540c\u6b65redis\u7ed3\u675f==========");
    }
}

