/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.cfc.busi.api.ServiceIndexCacheService;
import com.tydic.cfc.dao.CfcFieldMappingDetailMapper;
import com.tydic.cfc.dao.CfcRelServiceIndexMapper;
import com.tydic.cfc.dao.CfcSubQueryInfoMapper;
import com.tydic.cfc.po.CfcFieldMappingDetailPO;
import com.tydic.cfc.po.CfcRelServiceIndexPO;
import com.tydic.cfc.po.CfcSubQueryInfoPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ServiceIndexCacheServiceImpl
implements ServiceIndexCacheService {
    private static final Logger log = LoggerFactory.getLogger(ServiceIndexCacheServiceImpl.class);
    private static final String EXT_FIELD = "EXT_FIELD";
    private static final String FIELD = "FIELD";
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private CfcRelServiceIndexMapper cfcRelServiceIndexMapper;
    @Autowired
    private CfcFieldMappingDetailMapper cfcFieldMappingDetailMapper;
    @Autowired
    private CfcSubQueryInfoMapper cfcSubQueryInfoMapper;

    @Override
    public void cache(String serviceName, String methodName) {
        List<CfcRelServiceIndexPO> relServiceIndexList = this.getRelServiceIndexList(serviceName, methodName);
        if (CollectionUtils.isEmpty(relServiceIndexList)) {
            return;
        }
        ArrayList<ValueBO> valueBOS = new ArrayList<ValueBO>();
        for (CfcRelServiceIndexPO relServiceIndexPO : relServiceIndexList) {
            List<SubQuery> collect;
            SubQuery subQuery;
            int i;
            ValueBO valueBO = new ValueBO();
            valueBO.setDocValueField(relServiceIndexPO.getDocField());
            valueBO.setDataFilter(relServiceIndexPO.getQueryDataSql());
            valueBO.setIndexName(relServiceIndexPO.getIndexName());
            valueBO.setBusiCode(relServiceIndexPO.getBusiCenter());
            valueBO.setEventType(relServiceIndexPO.getEventType());
            valueBO.setSyncType(relServiceIndexPO.getSyncType());
            this.buildMappinginfo(valueBO, relServiceIndexPO.getId(), 0, 0);
            ArrayList<SubQuery> subQueries = new ArrayList<SubQuery>();
            valueBO.setSubQuery(subQueries);
            CfcSubQueryInfoPO cfcSubQueryInfoPO = new CfcSubQueryInfoPO();
            cfcSubQueryInfoPO.setServiceIndexId(relServiceIndexPO.getId());
            List<CfcSubQueryInfoPO> subQueryList = this.cfcSubQueryInfoMapper.getList(cfcSubQueryInfoPO);
            CfcFieldMappingDetailPO detailPO = new CfcFieldMappingDetailPO();
            detailPO.setServiceIndexId(relServiceIndexPO.getId());
            List<CfcFieldMappingDetailPO> detailPList = this.cfcFieldMappingDetailMapper.getList(detailPO);
            ArrayList<SubQuery> noOrderSubQueryList = new ArrayList<SubQuery>();
            for (CfcSubQueryInfoPO subQueryInfoPO : subQueryList) {
                SubQuery subQuery2 = new SubQuery();
                List resultDetailList = detailPList.stream().filter(po -> po.getLevel().equals(subQueryInfoPO.getLevel()) && po.getSubQueryId().equals(subQueryInfoPO.getId())).collect(Collectors.toList());
                HashMap<String, String> map = new HashMap<String, String>();
                for (CfcFieldMappingDetailPO dpo : resultDetailList) {
                    map.put(dpo.getDataFieldCode(), dpo.getIndexFieldCode());
                }
                subQuery2.setDataFilter(subQueryInfoPO.getSubQuerySql());
                if (!subQueryInfoPO.getSubQueryType().equals(EXT_FIELD) || !subQueryInfoPO.getSubQueryType().equals(FIELD)) {
                    subQuery2.setParentField(subQueryInfoPO.getSubQueryParentField());
                }
                subQuery2.setDataType(subQueryInfoPO.getSubQueryType());
                subQuery2.setLevel(subQueryInfoPO.getLevel());
                subQuery2.setParentId(subQueryInfoPO.getParentId());
                subQuery2.setId(subQueryInfoPO.getId());
                subQuery2.setParentField(subQueryInfoPO.getSubQueryParentField());
                subQuery2.setMappingInfo(JSON.toJSONString(map));
                noOrderSubQueryList.add(subQuery2);
            }
            List level1 = noOrderSubQueryList.stream().filter(po -> po.getLevel().equals(1)).collect(Collectors.toList());
            ArrayList<SubQuery> doOrderSubQueryList = new ArrayList<SubQuery>(level1);
            List level2 = noOrderSubQueryList.stream().filter(po -> po.getLevel().equals(2)).collect(Collectors.toList());
            List level3 = noOrderSubQueryList.stream().filter(po -> po.getLevel().equals(3)).collect(Collectors.toList());
            for (i = 0; i < level1.size(); ++i) {
                subQuery = (SubQuery)level1.get(i);
                collect = level2.stream().filter(po -> po.getParentId().equals(subQuery.getId())).collect(Collectors.toList());
                ((SubQuery)level1.get(i)).setSubQuery(collect);
            }
            for (i = 0; i < level2.size(); ++i) {
                subQuery = (SubQuery)level2.get(i);
                collect = level3.stream().filter(po -> po.getParentId().equals(subQuery.getId())).collect(Collectors.toList());
                ((SubQuery)level2.get(i)).setSubQuery(collect);
            }
            valueBO.setSubQuery(doOrderSubQueryList);
            valueBOS.add(valueBO);
        }
        String key = serviceName + "." + methodName;
        String value = JSON.toJSONString(valueBOS);
        log.info("\u5f00\u59cb\u540c\u6b65\u6570\u636e\uff0ckey:{}, value:{}", (Object)key, (Object)value);
        this.cacheClient.set(key, (Object)value);
    }

    public List<CfcRelServiceIndexPO> getRelServiceIndexList(String serviceName, String methodName) {
        CfcRelServiceIndexPO serviceIndexPo = new CfcRelServiceIndexPO();
        serviceIndexPo.setServiceName(serviceName);
        serviceIndexPo.setMethodName(methodName);
        return this.cfcRelServiceIndexMapper.getList(serviceIndexPo);
    }

    private void buildMappinginfo(ValueBO valueBO, int serviceIndexId, int level, int subQueryId) {
        CfcFieldMappingDetailPO detailPO = new CfcFieldMappingDetailPO();
        detailPO.setServiceIndexId(serviceIndexId);
        detailPO.setLevel(level);
        detailPO.setSubQueryId(subQueryId);
        List<CfcFieldMappingDetailPO> detailPOS = this.cfcFieldMappingDetailMapper.getList(detailPO);
        HashMap<String, String> mappingInfo = new HashMap<String, String>();
        for (CfcFieldMappingDetailPO dpo : detailPOS) {
            mappingInfo.put(dpo.getDataFieldCode(), dpo.getIndexFieldCode());
        }
        valueBO.setMappingInfo(JSON.toJSONString(mappingInfo));
    }

    public static class SubQuery {
        @JsonIgnore
        private Integer id;
        @JsonIgnore
        private Integer level;
        @JsonIgnore
        private Integer parentId;
        private String dataFilter;
        private String mappingInfo;
        private String dataType;
        private String parentField;
        private List<SubQuery> subQuery;

        public Integer getId() {
            return this.id;
        }

        public Integer getLevel() {
            return this.level;
        }

        public Integer getParentId() {
            return this.parentId;
        }

        public String getDataFilter() {
            return this.dataFilter;
        }

        public String getMappingInfo() {
            return this.mappingInfo;
        }

        public String getDataType() {
            return this.dataType;
        }

        public String getParentField() {
            return this.parentField;
        }

        public List<SubQuery> getSubQuery() {
            return this.subQuery;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public void setLevel(Integer level) {
            this.level = level;
        }

        public void setParentId(Integer parentId) {
            this.parentId = parentId;
        }

        public void setDataFilter(String dataFilter) {
            this.dataFilter = dataFilter;
        }

        public void setMappingInfo(String mappingInfo) {
            this.mappingInfo = mappingInfo;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public void setParentField(String parentField) {
            this.parentField = parentField;
        }

        public void setSubQuery(List<SubQuery> subQuery) {
            this.subQuery = subQuery;
        }

        public String toString() {
            return "ServiceIndexCacheServiceImpl.SubQuery(id=" + this.getId() + ", level=" + this.getLevel() + ", parentId=" + this.getParentId() + ", dataFilter=" + this.getDataFilter() + ", mappingInfo=" + this.getMappingInfo() + ", dataType=" + this.getDataType() + ", parentField=" + this.getParentField() + ", subQuery=" + this.getSubQuery() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubQuery)) {
                return false;
            }
            SubQuery other = (SubQuery)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$id = this.getId();
            Integer other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Integer this$level = this.getLevel();
            Integer other$level = other.getLevel();
            if (this$level == null ? other$level != null : !((Object)this$level).equals(other$level)) {
                return false;
            }
            Integer this$parentId = this.getParentId();
            Integer other$parentId = other.getParentId();
            if (this$parentId == null ? other$parentId != null : !((Object)this$parentId).equals(other$parentId)) {
                return false;
            }
            String this$dataFilter = this.getDataFilter();
            String other$dataFilter = other.getDataFilter();
            if (this$dataFilter == null ? other$dataFilter != null : !this$dataFilter.equals(other$dataFilter)) {
                return false;
            }
            String this$mappingInfo = this.getMappingInfo();
            String other$mappingInfo = other.getMappingInfo();
            if (this$mappingInfo == null ? other$mappingInfo != null : !this$mappingInfo.equals(other$mappingInfo)) {
                return false;
            }
            String this$dataType = this.getDataType();
            String other$dataType = other.getDataType();
            if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
                return false;
            }
            String this$parentField = this.getParentField();
            String other$parentField = other.getParentField();
            if (this$parentField == null ? other$parentField != null : !this$parentField.equals(other$parentField)) {
                return false;
            }
            List<SubQuery> this$subQuery = this.getSubQuery();
            List<SubQuery> other$subQuery = other.getSubQuery();
            return !(this$subQuery == null ? other$subQuery != null : !((Object)this$subQuery).equals(other$subQuery));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SubQuery;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Integer $level = this.getLevel();
            result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
            Integer $parentId = this.getParentId();
            result = result * 59 + ($parentId == null ? 43 : ((Object)$parentId).hashCode());
            String $dataFilter = this.getDataFilter();
            result = result * 59 + ($dataFilter == null ? 43 : $dataFilter.hashCode());
            String $mappingInfo = this.getMappingInfo();
            result = result * 59 + ($mappingInfo == null ? 43 : $mappingInfo.hashCode());
            String $dataType = this.getDataType();
            result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
            String $parentField = this.getParentField();
            result = result * 59 + ($parentField == null ? 43 : $parentField.hashCode());
            List<SubQuery> $subQuery = this.getSubQuery();
            result = result * 59 + ($subQuery == null ? 43 : ((Object)$subQuery).hashCode());
            return result;
        }
    }

    public static class ValueBO {
        @JSONField(name="docValueFiled")
        private String docValueField;
        private String dataFilter;
        private String mappingInfo;
        private String indexName;
        private String busiCode;
        private int eventType;
        private int syncType;
        private List<SubQuery> subQuery;

        public String getDocValueField() {
            return this.docValueField;
        }

        public String getDataFilter() {
            return this.dataFilter;
        }

        public String getMappingInfo() {
            return this.mappingInfo;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public String getBusiCode() {
            return this.busiCode;
        }

        public int getEventType() {
            return this.eventType;
        }

        public int getSyncType() {
            return this.syncType;
        }

        public List<SubQuery> getSubQuery() {
            return this.subQuery;
        }

        public void setDocValueField(String docValueField) {
            this.docValueField = docValueField;
        }

        public void setDataFilter(String dataFilter) {
            this.dataFilter = dataFilter;
        }

        public void setMappingInfo(String mappingInfo) {
            this.mappingInfo = mappingInfo;
        }

        public void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public void setBusiCode(String busiCode) {
            this.busiCode = busiCode;
        }

        public void setEventType(int eventType) {
            this.eventType = eventType;
        }

        public void setSyncType(int syncType) {
            this.syncType = syncType;
        }

        public void setSubQuery(List<SubQuery> subQuery) {
            this.subQuery = subQuery;
        }

        public String toString() {
            return "ServiceIndexCacheServiceImpl.ValueBO(docValueField=" + this.getDocValueField() + ", dataFilter=" + this.getDataFilter() + ", mappingInfo=" + this.getMappingInfo() + ", indexName=" + this.getIndexName() + ", busiCode=" + this.getBusiCode() + ", eventType=" + this.getEventType() + ", syncType=" + this.getSyncType() + ", subQuery=" + this.getSubQuery() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValueBO)) {
                return false;
            }
            ValueBO other = (ValueBO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$docValueField = this.getDocValueField();
            String other$docValueField = other.getDocValueField();
            if (this$docValueField == null ? other$docValueField != null : !this$docValueField.equals(other$docValueField)) {
                return false;
            }
            String this$dataFilter = this.getDataFilter();
            String other$dataFilter = other.getDataFilter();
            if (this$dataFilter == null ? other$dataFilter != null : !this$dataFilter.equals(other$dataFilter)) {
                return false;
            }
            String this$mappingInfo = this.getMappingInfo();
            String other$mappingInfo = other.getMappingInfo();
            if (this$mappingInfo == null ? other$mappingInfo != null : !this$mappingInfo.equals(other$mappingInfo)) {
                return false;
            }
            String this$indexName = this.getIndexName();
            String other$indexName = other.getIndexName();
            if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
                return false;
            }
            String this$busiCode = this.getBusiCode();
            String other$busiCode = other.getBusiCode();
            if (this$busiCode == null ? other$busiCode != null : !this$busiCode.equals(other$busiCode)) {
                return false;
            }
            if (this.getEventType() != other.getEventType()) {
                return false;
            }
            if (this.getSyncType() != other.getSyncType()) {
                return false;
            }
            List<SubQuery> this$subQuery = this.getSubQuery();
            List<SubQuery> other$subQuery = other.getSubQuery();
            return !(this$subQuery == null ? other$subQuery != null : !((Object)this$subQuery).equals(other$subQuery));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ValueBO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $docValueField = this.getDocValueField();
            result = result * 59 + ($docValueField == null ? 43 : $docValueField.hashCode());
            String $dataFilter = this.getDataFilter();
            result = result * 59 + ($dataFilter == null ? 43 : $dataFilter.hashCode());
            String $mappingInfo = this.getMappingInfo();
            result = result * 59 + ($mappingInfo == null ? 43 : $mappingInfo.hashCode());
            String $indexName = this.getIndexName();
            result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
            String $busiCode = this.getBusiCode();
            result = result * 59 + ($busiCode == null ? 43 : $busiCode.hashCode());
            result = result * 59 + this.getEventType();
            result = result * 59 + this.getSyncType();
            List<SubQuery> $subQuery = this.getSubQuery();
            result = result * 59 + ($subQuery == null ? 43 : ((Object)$subQuery).hashCode());
            return result;
        }
    }
}

