/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.utils.npc.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.dubbo.rpc.service.GenericService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taobao.hsf.app.api.util.HSFApiConsumerBean;
import com.tydic.utils.npc.bo.NpcRpcControllerReqBo;
import com.tydic.utils.npc.bo.NpcRpcControllerRspBo;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import lombok.extern.ohaotian.TempServiceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnProperty(name={"npc.native.is-open-rpc"}, havingValue="true")
public class NpcRpcController {
    private static final Logger log = LoggerFactory.getLogger(NpcRpcController.class);
    private static final String HSF_RPC_TYPE = "HSF";
    private static final String SPRING_CLOUD_RPC_TYPE = "SpringCloud";
    private static final String NO_QUALIFYING_BEAN_OF_TYPE = "No qualifying bean of type";
    @Autowired
    private ApplicationContext context;

    @PostMapping(value={"${npc.native.url-suffix:/deploy/federate/noauth/rpc}"})
    public NpcRpcControllerRspBo callNpcRpc(@RequestBody NpcRpcControllerReqBo reqBo) {
        Class<?> aClass;
        String validateArg = this.validateArg(reqBo);
        if (null != validateArg) {
            return this.failed(validateArg);
        }
        String interClass = reqBo.getInterClass();
        String methodName = reqBo.getMethod();
        try {
            aClass = Class.forName(interClass);
        }
        catch (ClassNotFoundException e) {
            return this.failed("\u8be5class(" + interClass + ")\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8be5maven\u4f9d\u8d56");
        }
        Object reqDataObj = reqBo.getData();
        String reqDataJson = JSON.toJSONString((Object)reqDataObj);
        log.info("RPC\u8c03\u7528\u670d\u52a1\u5165\u53c2\uff1a" + reqDataJson);
        Method method = ReflectUtil.getMethodByName(aClass, (String)methodName);
        if (method == null) {
            return this.failed("\u8be5\u670d\u52a1(" + interClass + ")\u7684\u65b9\u6cd5(" + methodName + ")\u4e0d\u5b58\u5728");
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?> parameterType = parameterTypes[0];
        TempServiceInfo tempAnnotation = aClass.getAnnotation(TempServiceInfo.class);
        if (tempAnnotation == null) {
            return this.invokeLocalBeanMethod(reqDataJson, aClass, parameterType, method);
        }
        String version = tempAnnotation.version();
        String group = tempAnnotation.group();
        String rpcType = tempAnnotation.invokeTypes()[0].toString();
        log.info("TempServiceInfo\u5185\u5bb9\u4e3a:version:{};group:{};rpcType:{}", new Object[]{version, group, rpcType});
        if (HSF_RPC_TYPE.equalsIgnoreCase(rpcType)) {
            try {
                HSFApiConsumerBean hsfApiConsumerBean = new HSFApiConsumerBean();
                hsfApiConsumerBean.setInterfaceName(interClass);
                hsfApiConsumerBean.setVersion(version);
                hsfApiConsumerBean.setGroup(group);
                hsfApiConsumerBean.init(true);
                JSONObject reqJsonObject = (JSONObject)JSON.parseObject((String)reqDataJson, JSONObject.class);
                HashMap reqMap = new HashMap(reqJsonObject.size());
                for (Map.Entry reqJsonEntry : reqJsonObject.entrySet()) {
                    Object value = reqJsonEntry.getValue();
                    if (!ObjectUtil.isNotEmpty(value)) continue;
                    reqMap.put((String)reqJsonEntry.getKey(), value);
                }
                GenericService genericOrderService = (GenericService)hsfApiConsumerBean.getObject();
                Object rspObject = genericOrderService.$invoke(methodName, new String[]{parameterType.getName()}, new Object[]{reqMap});
                JSONObject rspJsonObject = (JSONObject)JSON.parseObject((String)JSONObject.toJSONString((Object)rspObject), JSONObject.class);
                rspJsonObject.remove((Object)"class");
                log.info("RPC\u8c03\u7528\u670d\u52a1\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspJsonObject));
                return this.success(rspJsonObject);
            }
            catch (Exception e) {
                return this.failed("[" + rpcType + "]\u670d\u52a1\u8c03\u7528\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        if (SPRING_CLOUD_RPC_TYPE.equalsIgnoreCase(rpcType)) {
            return this.invokeLocalBeanMethod(reqDataJson, aClass, parameterType, method);
        }
        return this.failed("\u8be5\u670d\u52a1\u8c03\u7528RPC\u7c7b\u578b(" + rpcType + ")\u4e0d\u652f\u6301");
    }

    private String validateArg(NpcRpcControllerReqBo reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getInterClass())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[interClass]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getMethod())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[method]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private NpcRpcControllerRspBo invokeLocalBeanMethod(String reqDataJson, Class<?> aClass, Class<?> parameterType, Method method) {
        Object bean;
        try {
            bean = this.context.getBean(aClass);
        }
        catch (Exception e) {
            if (e.getMessage().contains(NO_QUALIFYING_BEAN_OF_TYPE)) {
                return this.failed("\u8be5\u670d\u52a1(" + aClass.getName() + ")\u4e0d\u5b58\u5728");
            }
            return this.failed("getBean\u5f02\u5e38:" + e.getMessage());
        }
        Object invoke = ReflectUtil.invoke((Object)bean, (Method)method, (Object[])new Object[]{JSON.parseObject((String)reqDataJson, parameterType)});
        String jsonStr = JSON.toJSONString((Object)invoke);
        log.info("RPC\u8c03\u7528\u670d\u52a1\u51fa\u53c2\uff1a" + jsonStr);
        return this.success(invoke);
    }

    private NpcRpcControllerRspBo failed(String errorMessage) {
        NpcRpcControllerRspBo rspBo = new NpcRpcControllerRspBo();
        rspBo.setCode("1");
        rspBo.setMessage(errorMessage);
        log.info("RPC\u8c03\u7528\u670d\u52a1\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)errorMessage);
        return rspBo;
    }

    private NpcRpcControllerRspBo success(Object data) {
        NpcRpcControllerRspBo rspBo = new NpcRpcControllerRspBo();
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        rspBo.setData(data);
        return rspBo;
    }
}

