/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.busi.api.FscSystemBusiLogBusiService;
import com.tydic.fsc.busibase.busi.bo.FscSystemBusiLogBusiServiceReqBo;
import com.tydic.fsc.busibase.external.api.bo.FscBuriedPointCallBo;
import com.tydic.fsc.busibase.external.api.bo.FscBuriedPointCallExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscBuriedPointCallExternalRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscEcomInvoiceCancelExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscEcomInvoiceCancelExternalRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscBuriedPointCallExternalService;
import com.tydic.fsc.busibase.external.api.esb.FscEcomInvoiceCancelExternalService;
import com.tydic.fsc.common.ability.api.FscComOrderCancelAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderCancelAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderCancelAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscComOrderCancelBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderCancelBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderCancelBusiRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComOrderCancelAbilityService"})
public class FscComOrderCancelAbilityServiceImpl
implements FscComOrderCancelAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderCancelAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscComOrderCancelBusiService fscComOrderCancelBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscEcomInvoiceCancelExternalService fscEcomInvoiceCancelExternalService;
    @Autowired
    private FscSystemBusiLogBusiService fscSystemBusiLogBusiService;
    @Autowired
    private FscComOrderCancelAbilityService fscComOrderCancelAbilityService;
    public static final Integer YES = 1;
    @Autowired
    private FscBuriedPointCallExternalService fscBuriedPointCallExternalService;

    @PostMapping(value={"dealOrderCancel"})
    public FscComOrderCancelAbilityRspBO dealOrderCancel(@RequestBody FscComOrderCancelAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderIds()) && null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderId]\u548c[orderIds]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if ("2".equals(reqBO.getIsprofess())) {
            throw new FscBusinessException("191125", "\u4f9b\u5e94\u5546\u7528\u6237\u4e0d\u80fd\u53d6\u6d88\u7ed3\u7b97\u5355");
        }
        List fscOrderIds = Optional.ofNullable(reqBO.getOrderIds()).map(ArrayList::new).orElse(new ArrayList());
        if (null != reqBO.getOrderId()) {
            fscOrderIds.add(reqBO.getOrderId());
        }
        FscComOrderCancelAbilityRspBO rspBO = new FscComOrderCancelAbilityRspBO();
        FscOrderPO fscOrder = new FscOrderPO();
        fscOrder.setFscOrderIds(fscOrderIds);
        List fscOrderPOS = this.fscOrderMapper.getList(fscOrder);
        if (!CollectionUtils.isEmpty((Collection)fscOrderPOS)) {
            fscOrderPOS.forEach(fscOrderPO -> {
                if (!YES.equals(reqBO.getOperFlag())) {
                    if (FscConstants.FscOrderMakeType.SUPPLIER.equals(fscOrderPO.getMakeType()) && !FscBillStatus.TO_BE_RECONCILED.getCode().equals(fscOrderPO.getOrderState())) {
                        throw new FscBusinessException("191125", "\u4f9b\u5e94\u5546\u4fa7\u7ed3\u7b97\u5355\u53d6\u6d88\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u72b6\u6001");
                    }
                    if (FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) && !FscBillStatus.PENDING_FEEDBACK.getCode().equals(fscOrderPO.getOrderState())) {
                        throw new FscBusinessException("191125", "\u8d38\u6613\u6a21\u5f0f\u7ed3\u7b97\u5355\u53d6\u6d88\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u72b6\u6001");
                    }
                }
            });
            for (FscOrderPO fscOrderPO2 : fscOrderPOS) {
                if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPO2.getMakeType()) && FscBillStatus.INVOICING_DEALLING.getCode().equals(fscOrderPO2.getOrderState())) {
                    FscEcomInvoiceCancelExternalReqBO fscEcomInvoiceCancelExternalReqBO = new FscEcomInvoiceCancelExternalReqBO();
                    fscEcomInvoiceCancelExternalReqBO.setMarkId(reqBO.getOrderId().toString());
                    fscEcomInvoiceCancelExternalReqBO.setSupplierId(Convert.toStr((Object)fscOrderPO2.getSupplierId()));
                    fscEcomInvoiceCancelExternalReqBO.setPurchaserId(fscOrderPO2.getPurchaserId());
                    FscEcomInvoiceCancelExternalRspBO fscEcomInvoiceCancelExternalRspBO = this.fscEcomInvoiceCancelExternalService.cancelInvoice(fscEcomInvoiceCancelExternalReqBO);
                    if (!"0000".equals(fscEcomInvoiceCancelExternalRspBO.getRespCode())) {
                        this.systemBusiLog(reqBO.getOrderId(), JSON.toJSONString((Object)fscEcomInvoiceCancelExternalReqBO), JSON.toJSONString((Object)fscEcomInvoiceCancelExternalRspBO), new Date(), fscEcomInvoiceCancelExternalRspBO.getResultMessage());
                        rspBO.setCancelFlag(Boolean.valueOf(false));
                        return rspBO;
                    }
                }
                reqBO.setOrderState(fscOrderPO2.getOrderState());
                String jsonString = JSON.toJSONString((Object)reqBO);
                FscComOrderCancelBusiReqBO busiReqBO = (FscComOrderCancelBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscComOrderCancelBusiReqBO.class));
                busiReqBO.setOrderFlow(fscOrderPO2.getOrderFlow());
                busiReqBO.setOrderId(fscOrderPO2.getFscOrderId());
                FscComOrderCancelBusiRspBO fscComOrderCancelBusiRspBO = this.fscComOrderCancelBusiService.dealOrderCancel(busiReqBO);
                if (!"0000".equals(fscComOrderCancelBusiRspBO.getRespCode())) {
                    throw new FscBusinessException("191125", fscComOrderCancelBusiRspBO.getRespDesc());
                }
                JSONObject req = new JSONObject();
                req.put("fscOrderId", (Object)fscOrderPO2.getFscOrderId());
                req.put("userId", (Object)reqBO.getUserId());
                this.fscComOrderCancelAbilityService.dealCancelTodo(req);
                this.sendMq(fscOrderPO2.getFscOrderId());
                this.sapBuryPoint(fscOrderPO2.getFscOrderId());
            }
        }
        return rspBO;
    }

    private void systemBusiLog(Long orderId, String reqStr, String rspStr, Date createTime, String failureReason) {
        FscSystemBusiLogBusiServiceReqBo logBusiServiceReqBo = new FscSystemBusiLogBusiServiceReqBo();
        logBusiServiceReqBo.setSystemType(FscConstants.SystemType.EXT);
        logBusiServiceReqBo.setLogType(FscConstants.SystemLogType.FORWARD);
        logBusiServiceReqBo.setLogFlag(FscConstants.SystemLogFlag.FAIL);
        logBusiServiceReqBo.setBusiType(FscConstants.SystemLogBusiType.CANCEL_INVOICE);
        logBusiServiceReqBo.setCallService("com.tydic.fsc.busibase.external.api.esb.FscEcomInvoiceCancelExternalService");
        logBusiServiceReqBo.setSendService("com.tydic.fsc.common.ability.api.FscComOrderCancelAbilityService");
        logBusiServiceReqBo.setReqParam(reqStr);
        logBusiServiceReqBo.setRspParam(rspStr);
        logBusiServiceReqBo.setBusiObjId(orderId);
        if (null == createTime) {
            logBusiServiceReqBo.setCreateTime(new Date());
        } else {
            logBusiServiceReqBo.setCreateTime(createTime);
        }
        logBusiServiceReqBo.setFailureReason(failureReason);
        this.fscSystemBusiLogBusiService.systemBusiLog(logBusiServiceReqBo);
    }

    private void sendMq(Long fscOrderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        fscComOrderListSyncAbilityReqBO.setCreateTime(new Date());
        fscComOrderListSyncAbilityReqBO.setSendService(this.getClass().getName());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    @PostMapping(value={"dealCancelTodo"})
    public JSONObject dealCancelTodo(@RequestBody JSONObject reqBO) {
        JSONObject rspBO = new JSONObject();
        rspBO.put("respCode", (Object)"0000");
        rspBO.put("respDesc", (Object)"\u6210\u529f");
        return rspBO;
    }

    private void sapBuryPoint(Long orderId) {
        FscBuriedPointCallExternalReqBO funcReqBo = new FscBuriedPointCallExternalReqBO();
        ArrayList<FscBuriedPointCallBo> buildsList = new ArrayList<FscBuriedPointCallBo>();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("fscOrderId", (Object)orderId);
        FscBuriedPointCallBo bo = new FscBuriedPointCallBo();
        bo.setDycBusiCode("syncInvoiceState");
        bo.setData((Object)jsonObject);
        bo.setDycCenterCode("FSC");
        buildsList.add(bo);
        funcReqBo.setBusiList(buildsList);
        FscBuriedPointCallExternalRspBO funcRspBo = this.fscBuriedPointCallExternalService.callAbility(funcReqBo);
        if (!"0000".equals(funcRspBo.getRespCode())) {
            log.error("\u7ed3\u7b97\u5355\u53d6\u6d88\u63a8\u9001\u7535\u5546\u5e73\u53f0\u5f00\u7968\u72b6\u6001\u57cb\u70b9\u5931\u8d25\uff1a" + funcRspBo.getRespDesc());
        }
    }
}

