/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.InvoiceBO;
import com.tydic.fsc.busibase.busi.bo.FscComInvoiceListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscComInvoiceListPageQueryBusiRspBO;
import com.tydic.fsc.busibase.config.FscEsConfig;
import com.tydic.fsc.common.busi.api.FscEsQryComInvoiceListBusiService;
import com.tydic.fsc.utils.FscBuildEsQrySqlConditionUtil;
import com.tydic.fsc.utils.FscElasticsearchUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscEsQryComInvoiceListBusiServiceImpl
implements FscEsQryComInvoiceListBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscEsQryComInvoiceListBusiServiceImpl.class);
    private final FscEsConfig fscEsConfig;
    private final FscElasticsearchUtil fscElasticsearchUtil;
    private final FscBuildEsQrySqlConditionUtil buildEsQrySqlConditionUtil;

    @Autowired
    public FscEsQryComInvoiceListBusiServiceImpl(FscEsConfig fscEsConfig, FscElasticsearchUtil fscElasticsearchUtil) {
        this.fscEsConfig = fscEsConfig;
        this.fscElasticsearchUtil = fscElasticsearchUtil;
        this.buildEsQrySqlConditionUtil = new FscBuildEsQrySqlConditionUtil();
    }

    @Override
    public FscComInvoiceListPageQueryBusiRspBO esQryComInvoiceList(FscComInvoiceListPageQueryBusiReqBO reqBO) {
        FscComInvoiceListPageQueryBusiRspBO rspBO = new FscComInvoiceListPageQueryBusiRspBO();
        String qryString = this.buildEsQrySqlConditionUtil.buildComInvoiceEsSql(reqBO);
        log.debug("ES\u67e5\u5bfb\u53d1\u7968\u5217\u8868\u67e5\u8be2\u6761\u4ef6---->{}", (Object)qryString);
        String endPoint = "/" + this.fscEsConfig.getInvoiceIndexName() + "/_search";
        String result = null;
        Request request = new Request("POST", endPoint);
        request.setJsonEntity(qryString);
        try {
            Response response = this.fscElasticsearchUtil.performRequest(request);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            String ioExceptionStr = JSON.toJSONString((Object)e.getCause());
            if (ioExceptionStr.contains("index_not_found_exception")) {
                boolean index = this.fscElasticsearchUtil.createIndex(this.fscEsConfig.getOrderIndexName());
                if (!index) {
                    log.error("\u81ea\u52a8\u521b\u5efa\u9a8c\u6536\u7d22\u5f15\u5931\u8d25");
                    rspBO.setRespCode("191001");
                    rspBO.setRespDesc("\u81ea\u52a8\u521b\u5efa\u9a8c\u6536\u7d22\u5f15\u5931\u8d25");
                    return rspBO;
                }
                try {
                    Response response = this.fscElasticsearchUtil.performRequest(request);
                    result = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (IOException childE) {
                    log.error("ioException", (Throwable)childE);
                    rspBO.setRespCode("\u5931\u8d25");
                    rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u53d1\u7968\u5217\u8868\u5931\u8d25!");
                    return rspBO;
                }
            }
            log.error("ioException", (Throwable)e);
            rspBO.setRespCode("\u5931\u8d25");
            rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u53d1\u7968\u5217\u8868\u5931\u8d25!");
            return rspBO;
        }
        log.debug("ES\u67e5\u8be2\u53d1\u7968\u5217\u8868result---->{}", (Object)result);
        rspBO = this.resolveReturnData(result, rspBO, reqBO.getPageSize(), reqBO.getPageNo());
        return rspBO;
    }

    private FscComInvoiceListPageQueryBusiRspBO resolveReturnData(String result, FscComInvoiceListPageQueryBusiRspBO rspBO, Integer pageSize, Integer pageNo) {
        rspBO.setRespCode("0000");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        JSONObject totalObj = (JSONObject)hitsObj.get((Object)"total");
        Integer total = totalObj.getInteger("value");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject == null || listObject.size() < 1) {
            rspBO.setPageNo(Integer.valueOf(1));
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setRecordsTotal(total);
            rspBO.setRows(new ArrayList());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u53d1\u7968\u5217\u8868\u4fe1\u606f!");
            return rspBO;
        }
        ArrayList<InvoiceBO> rows = new ArrayList<InvoiceBO>();
        for (int i = 0; i < listObject.size(); ++i) {
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            String objJsonStr = data.getString("objJson");
            JSONObject objJson = JSONObject.parseObject((String)objJsonStr);
            InvoiceBO invoiceBO = (InvoiceBO)JSON.toJavaObject((JSON)objJson, InvoiceBO.class);
            rows.add(invoiceBO);
        }
        Integer totalPageNo = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        rspBO.setTotal(totalPageNo);
        rspBO.setRecordsTotal(total);
        rspBO.setPageNo(pageNo);
        rspBO.setRespDesc("\u67e5\u8be2\u53d1\u7968\u5217\u8868\u4fe1\u606f\u6210\u529f");
        rspBO.setRows(rows);
        return rspBO;
    }
}

