/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.consumer;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.busibase.busi.api.FscSystemBusiLogBusiService;
import com.tydic.fsc.busibase.busi.bo.FscSystemBusiLogBusiServiceReqBo;
import com.tydic.fsc.common.busi.api.FscAccountShouldPaySuccessBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountShouldPaySuccessBusiReqBo;
import com.tydic.fsc.common.busi.bo.FscAccountShouldPaySuccessBusiRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FscAccountShouldPayConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscAccountShouldPayConsumer.class);
    @Autowired
    private FscAccountShouldPaySuccessBusiService fscAccountShouldPaySuccessBusiService;
    @Autowired
    private FscSystemBusiLogBusiService fscSystemBusiLogBusiService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        JSONObject jsonObject = JSON.parseObject((String)message.getContent());
        Date createTime = jsonObject.getDate("createTime");
        String sendService = jsonObject.getString("sendService");
        FscAccountShouldPaySuccessBusiRspBo fscAccountShouldPaySuccessBusiRspBo = null;
        try {
            log.debug("\u53d1\u9001\u8d26\u671f\u652f\u4ed8\u5b8c\u6210\u6d88\u606f");
            List fscOrderIds = JSON.parseArray((String)JSON.toJSONString((Object)jsonObject.getJSONArray("busiParam")), Long.class);
            if (CollectionUtils.isNotEmpty((Collection)fscOrderIds)) {
                FscAccountShouldPaySuccessBusiReqBo reqBo = new FscAccountShouldPaySuccessBusiReqBo();
                reqBo.setFscOrderIds(fscOrderIds);
                fscAccountShouldPaySuccessBusiRspBo = this.fscAccountShouldPaySuccessBusiService.dealAccountShouldPaySuccess(reqBo);
                if (!"0000".equals(fscAccountShouldPaySuccessBusiRspBo.getRespCode())) {
                    throw new FscBusinessException(fscAccountShouldPaySuccessBusiRspBo.getRespCode(), fscAccountShouldPaySuccessBusiRspBo.getRespDesc());
                }
                this.systemBusiLog(FscConstants.SystemLogFlag.SUCCESS, JSON.toJSONString((Object)jsonObject.getJSONArray("busiParam")), JSON.toJSONString((Object)((Object)fscAccountShouldPaySuccessBusiRspBo)), createTime, null, sendService);
            }
        }
        catch (Exception e) {
            this.systemBusiLog(FscConstants.SystemLogFlag.FAIL, JSON.toJSONString((Object)jsonObject.getJSONArray("busiParam")), JSON.toJSONString(fscAccountShouldPaySuccessBusiRspBo), createTime, ExceptionUtil.stacktraceToString((Throwable)e), sendService);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void systemBusiLog(Integer logFlag, String reqStr, String rspStr, Date createTime, String failureReason, String sendService) {
        FscSystemBusiLogBusiServiceReqBo logBusiServiceReqBo = new FscSystemBusiLogBusiServiceReqBo();
        logBusiServiceReqBo.setSystemType(FscConstants.SystemType.EXT);
        logBusiServiceReqBo.setLogType(FscConstants.SystemLogType.FORWARD);
        logBusiServiceReqBo.setLogFlag(logFlag);
        logBusiServiceReqBo.setBusiType(FscConstants.SystemLogBusiType.SYNC_TODO_OR_NOTICE);
        logBusiServiceReqBo.setCallService("FscAccountShouldPaySuccessBusiService");
        logBusiServiceReqBo.setSendService(sendService);
        logBusiServiceReqBo.setReqParam(reqStr);
        logBusiServiceReqBo.setRspParam(rspStr);
        logBusiServiceReqBo.setCreateTime(createTime);
        logBusiServiceReqBo.setFailureReason(failureReason);
        this.fscSystemBusiLogBusiService.systemBusiLog(logBusiServiceReqBo);
    }
}

