/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.consumer;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.busibase.busi.api.FscSystemBusiLogBusiService;
import com.tydic.fsc.busibase.busi.bo.FscSystemBusiLogBusiServiceReqBo;
import com.tydic.fsc.busibase.config.FscEsConfig;
import com.tydic.fsc.common.consumer.bo.FscInvoiceDeleteSyncReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.utils.FscElasticsearchUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FscInvoiceDeleteEsSyncServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscInvoiceDeleteEsSyncServiceConsumer.class);
    @Autowired
    private FscEsConfig fscEsConfig;
    @Autowired
    private FscElasticsearchUtil fscElasticsearchUtil;
    @Autowired
    private FscSystemBusiLogBusiService fscSystemBusiLogBusiService;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        try {
            log.debug("---------------\u53d1\u7968\u5220\u9664\u5f00\u59cb---------------");
            FscInvoiceDeleteSyncReqBO fscInvoiceDeleteSyncReqBO = (FscInvoiceDeleteSyncReqBO)JSON.parseObject((String)proxyMessage.getContent(), (TypeReference)new TypeReference<FscInvoiceDeleteSyncReqBO>(){}, (Feature[])new Feature[0]);
            String endPoint = "/" + this.fscEsConfig.getInvoiceIndexName() + "/_delete_by_query";
            JSONObject deleteConditionJson = new JSONObject();
            deleteConditionJson.put("fscOrderId", (Object)fscInvoiceDeleteSyncReqBO.getFscOrderId());
            JSONObject termJson = new JSONObject();
            termJson.put("term", (Object)deleteConditionJson);
            JSONObject qryJson = new JSONObject();
            qryJson.put("query", (Object)termJson);
            Boolean aBoolean = this.fscElasticsearchUtil.deleteDataByCondition(endPoint, qryJson);
            if (!aBoolean.booleanValue()) {
                this.systemBusiLog(FscConstants.SystemLogFlag.FAIL, proxyMessage.getContent(), null, new Date(), null);
                log.debug("---------------\u5220\u9664\u5931\u8d25---------------");
            }
            this.systemBusiLog(FscConstants.SystemLogFlag.SUCCESS, proxyMessage.getContent(), null, new Date(), null);
        }
        catch (Exception e) {
            this.systemBusiLog(FscConstants.SystemLogFlag.FAIL, proxyMessage.getContent(), null, new Date(), ExceptionUtil.stacktraceToString((Throwable)e));
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        log.debug("---------------\u53d1\u7968\u5220\u9664\u7ed3\u675f---------------");
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void systemBusiLog(Integer logFlag, String reqStr, String rspStr, Date createTime, String failureReason) {
        FscSystemBusiLogBusiServiceReqBo logBusiServiceReqBo = new FscSystemBusiLogBusiServiceReqBo();
        logBusiServiceReqBo.setSystemType(FscConstants.SystemType.INNER);
        logBusiServiceReqBo.setLogType(FscConstants.SystemLogType.FORWARD);
        logBusiServiceReqBo.setLogFlag(logFlag);
        logBusiServiceReqBo.setBusiType(FscConstants.SystemLogBusiType.INVOICE_DELETE);
        logBusiServiceReqBo.setCallService("FscElasticsearchUtil");
        logBusiServiceReqBo.setSendService("FscComInvoiceDeleteSyncAbilityService");
        logBusiServiceReqBo.setReqParam(reqStr);
        logBusiServiceReqBo.setRspParam(rspStr);
        logBusiServiceReqBo.setCreateTime(createTime);
        logBusiServiceReqBo.setFailureReason(failureReason);
        this.fscSystemBusiLogBusiService.systemBusiLog(logBusiServiceReqBo);
    }
}

