package com.tydic.dyc.oc.service.saleorder.bo;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocGetSaleOrderItemListServiceRspMainBo
 * 说明:销售单明细修改BO
 * 时间:2022/2/14 13:07
 * 作者:罗有
 */

@Data
@EqualsAndHashCode(callSuper=false)
public class UocUpdateSaleOrderItemServiceReqMainBo implements Serializable {
    private static final long serialVersionUID = 6231544444925851101L;


    //订单id")
    private Long orderId;

    //销售明细id")
    private Long saleOrderItemId;

    //销售单id")
    private Long saleOrderId;

    //订单明细id")
    private Long orderItemId;

    //明细类型             1 商品sku             2 物资             3 项目")
    private Integer itemType;

    //明细状态")
    private String saleItemState;

    //单品ID")
    private String skuId;

    //供应商ID")
    private String supplierId;

    //店铺ID")
    private String supplierShopId;

    //采购金额")
    private BigDecimal purchasePrice;

    //采购金额")
    private BigDecimal salePrice;

    //采购数量")
    private BigDecimal purchaseCount;

    //运费")
    private BigDecimal transFee;

    //采购金额")
    private BigDecimal purchaseFee;

    //应付金额")
    private BigDecimal payFee;

    //积分优惠金额")
    private BigDecimal integralDisFee;

    //活动优惠金额")
    private BigDecimal actDisFee;

    //其它优惠金额")
    private BigDecimal otherDisFee;

    //实付金额")
    private BigDecimal usedFee;

    //实付积分")
    private BigDecimal usedIntegral;

    //币种")
    private String currencyType;

    //税金")
    private String taxPrice;

    //税率")
    private String tax;

    //税务编码")
    private String taxId;

    //预计发货时间")
    private Date preSendTime;

    //预计交货时间")
    private Date preOfferTime;

    //计量单位")
    private String unitName;

    //结算计量单位")
    private String settleUnit;

    //售后在途数量")
    private BigDecimal afterServingCount;

    //外部电商主订单id")
    private String lmOrderId;

    //外部电商子订单id")
    private String lmSubOrderId;

    //到货周期")
    private String arrivalTime;

    //加价率")
    private Double markUpRate;

    //商品服务费 ")
    private String serPrice;

    //计划id")
    private String planId;

    //计划明细id ")
    private String planItemId;

    //计划明细编号")
    private String planItemNo;

    //超验百分比，下单时保存（协议、无协议）")
    private Integer inspectionExcessPercent;

    //扩展字段")
    private String extField1;

    //扩展字段")
    private String extField2;

    //扩展字段")
    private String extField3;

    //扩展字段")
    private String extField4;

    //扩展字段")
    private String extField5;

    

    //销售明细拓展信息")
    private List<UocUpdateSaleOrderItemServiceReqMainExtBo> uocUpdateSaleOrderItemServiceReqMainExtBoList;


}
