package com.tydic.dyc.oc.service.saleorder.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述：临时验收明细表
 **/
@Data
public class UocInspOrderItemTemporarilyBO implements Serializable {
	private static final long serialVersionUID =  2302859121656758241L;

	/**
	 * 商品名称
	 */
	private String commodityName;
	/**
	 * 单品名称
	 */
	private String skuName;
	/**
	 * skuId
	 */
	private String skuId;
	/**
	 * sku编码
	 */
	private String skuCode;
	/**
	 * 商品主图
	 */
	private String skuMainPic;
	/**
	 * 采购数量
	 */
	private BigDecimal purchaseCount;
	/**
	 * 第三方商品编码
	 */
	private String skuExtSkuId;
	/**
	 * 物料类型 id
	 */
	private String materialTypeId;
	/**
	 * 物料分类名称
	 */
	private String materialTypeName;
	/**
	 * 物料编码
	 */
	private String materialCode;
	/**
	 * 物料名称
	 */
	private String materialName;
	/**
	 * 单位转换倍率
	 */
	private BigDecimal planConversionRate;
	/**
	 * 临时验收单号
	 */
	private Long tempInspOrderItemId;
	/**
	 * 临时验收单id
	 */
	private Long tempInspOrderId;
	/**
	 * 销售明细id
	 */
	private Long saleOrderItemId;
	/**
	 * 销售单id
	 */
	private Long saleOrderId;
	/**
	 * 订单id
	 */
	private Long orderId;
	/**
	 * sap订单编号
	 */
	private String sapOrderNo;
	/**
	 * sap订单明细编号
	 */
	private String sapOrderItemNo;
	/**
	 * 发货数量
	 */
	private BigDecimal sendCount;
	/**
	 * 验收数量
	 */
	private BigDecimal inspCount;
	/**
	 * 退货数量
	 */
	private BigDecimal returnCount;
	/**
	 * 状态0 异常验收  1 已验收
	 */
	private Integer status;
	/**
	 * 创建时间
	 */
	private Date createTime;
	/**
	 * 更新时间
	 */
	private Date updateTime;
	/**
	 * 备注
	 */
	private String remark;
	/**
	 * 排序
	 */
	private String orderBy;

	//供应商ID")
	private String supplierId;

	//店铺ID")
	private String supplierShopId;

	/**
	 * 销售明细ID集合
	 */
	private List<Long> saleOrderItemIdList;
	//税率")
	private BigDecimal tax;
	//销售金额")
	private BigDecimal salePrice;
	//计量单位")
	private String unitName;
	/**
	 * 协议价格明细执行时间
	 */
	private Date agrItemActiveTime;
	/**
	 * 协议价格明细创建时间
	 */
	private Date agrItemCreateTime;
	/**
	 * 协议价格明细不含税单价
	 */
	private BigDecimal agrItemNoTaxPrice;
	/**
	 * 计划明细编号
	 */
	private String planItemNo;
}
