package com.tydic.dyc.oc.service.snaporder.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 描述：快照销售订单明细同款BO
 **/
@Data
public class UocSnapSaleOrderItemSameBo implements Serializable {

	private static final long serialVersionUID =  5259811905018091463L;

	/**
	 * 同款ID
	 */
	private Long sameId;

	/**
	 * 快照明细ID
	 */
	private Long snapshotItemId;

	/**
	 * 单品ID
	 */
	private Long skuId;

	/**
	 * 单品编码
	 */
	private String skuCode;

	/**
	 * 单品名称
	 */
	private String skuName;

	/**
	 * 单品图片URL
	 */
	private String skuPicUrl;

	/**
	 * 协议价
	 */
	private BigDecimal salePrice;

	/**
	 * 推送价
	 */
	private BigDecimal marketPrice;

	/**
	 * 商品69码
	 */
	private String upcCode;

	/**
	 * 供应商ID
	 */
	private String supplierId;

	/**
	 * 供应商名称
	 */
	private String supplierName;

	/**
	 * 店铺ID
	 */
	private String supplierShopId;

	/**
	 * 是否同款最低价 1是 0否
	 */
	private Integer isLowPrice;

	/**
	 * 最小起订量
	 */
	private BigDecimal moq;

}
