package com.tydic.dyc.oc.service.snaporder.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 描述：订单快照列表分页查询BO
 */
@Data
public class UocSnapshotOrderListQryBo implements Serializable {

    private static final long serialVersionUID = -1443805504598519156L;

    /*--------------------------------------------------快照销售订单明细--------------------------------------------------*/

    /**
     * 快照明细ID
     */
    private Long snapshotItemId;

    /**
     * 快照ID
     */
    private Long snapshotId;

    /**
     * 单品ID
     */
    private Long skuId;

    /**
     * 单品编码
     */
    private String skuCode;

    /**
     * 单品名称
     */
    private String skuName;

    /**
     * 单品图片URL
     */
    private String skuPicUrl;

    /**
     * 协议价
     */
    private BigDecimal salePrice;

    /**
     * 推送价
     */
    private BigDecimal marketPrice;

    /**
     * 数量
     */
    private BigDecimal purchaseCount;

    /**
     * 商品总金额
     */
    private BigDecimal commodityTotalFee;

    /**
     * 商品69码
     */
    private String upcCode;

    /**
     * 第三方指导价
     */
    private BigDecimal tripartitePrice;

    /**
     * 官网价
     */
    private BigDecimal officialPrice;

    /**
     * 供应商ID
     */
    private String supplierId;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 店铺ID
     */
    private String supplierShopId;

    /**
     * 是否同款最低价 1是 0否
     */
    private Integer isLowPrice;

    /**
     * 是否同款最低价转义
     */
    private String isLowPriceStr;

    /**
     * 是否存在同款 1是 0否
     */
    private Integer isExistSame;

    /**
     * 最近一次变价时间
     */
    private Date latestPriceTime;

    /*--------------------------------------------------快照销售订单--------------------------------------------------*/

    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 销售单ID
     */
    private Long saleOrderId;

    /**
     * 销售单编码
     */
    private String saleOrderNo;

    /**
     * 订单总金额
     */
    private BigDecimal orderTotalFee;

    /**
     * 订单来源 1自营单品 2电商导入 3协议生成
     */
    private Integer orderSource;

    /**
     * 专区类型
     */
    private Integer areaType;

    /**
     * 专区类型转义
     */
    private String areaTypeStr;

    /**
     * 创建人机构ID
     */
    private String createOrgId;

    /**
     * 创建人机构名称
     */
    private String createOrgName;

    /**
     * 创建人公司ID
     */
    private String createCompanyId;

    /**
     * 创建人公司名称
     */
    private String createCompanyName;

    /**
     * 创建人工号
     */
    private String createUserId;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 创建时间
     */
    private Date createTime;

}


