package com.tydic.dyc.oc.service.common.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 描述: 〈领域服务-查询供应商配置出参〉
 * @author : yuhao
 * @date : 2022/8/1 11:06
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocQryConfSupplierRspBO extends BaseRspBo {
    private static final long serialVersionUID = -6418855514303399222L;
    
    /**
     * 供应商ID主键(必填项)
     */
    private Long supNo;
    /**
     * 供应商名称
     */
    private String supName;
    /**
     * 供应商标识
     */
    private String supType;
    /**
     * 是否一次性发货
     * //            0 否
     * //            1 是
     */
    private Integer isOnceSendAll;
    /**
     * 订单超限额度
     */
    private Long orderQuota;
    /**
     * 订单超限额度 开始
     */
    private Long orderQuotaStart;
    /**
     * 订单超限额度 结束
     */
    private Long orderQuotaEnd;
    /**
     * 校验模式
     */
    private Integer checkFlag;
    /**
     * 接收消息类型
     */
    private String dealType;
    /**
     * 是否完结通知
     * //                        0 否
     * //                        1 是
     */
    private Integer completionFlag;
    /**
     * 业务类型编码
     */
    private String businessTypeCode;
    /**
     * 操作时间
     */
    private Date operatingTime;
    /**
     * 操作时间 开始
     */
    private Date operatingTimeStart;
    /**
     * 操作时间 结束
     */
    private Date operatingTimeEnd;
    /**
     * 操作人ID
     */
    private String operatorId;
    /**
     * 操作人名称
     */
    private String operatorName;
    /**
     * 订单限额额度
     */
    private Long orderLimit;
    /**
     * 订单限额状态：0：生效；1：失效
     */
    private Integer limitStatus;
    /**
     * 排序
     */
    private String orderBy;
    
    /**
     * 供应商编号列表
     */
    private List<Long> supplierNos;
}
