package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocQryShipOrderDetailsRspDetailBo
 * 说明:发货主体详情
 * 时间:2022/3/14 14:51
 * 作者:罗有
 */

@Data
@EqualsAndHashCode(callSuper=false)
public class UocQryShipOrderDetailsRspDetailBo implements Serializable {
	private static final long serialVersionUID = -1652309153678385798L;


	//发货单id")
	private Long shipOrderId;

	//销售单id")
	private Long saleOrderId;

	//销售单编号")
	private String saleOrderNo;

	//订单id")
	private Long orderId;

	//发货单编码")
	private String shipOrderNo;

	//外部发货单编码")
	private String shipOrderNoExt;

	//发货单名称")
	private String shipOrderName;

	//发货单类型")
	private Integer shipOrderType;

	//发货单状态")
	private String shipOrderState;

	//发货单状态翻译")
	private String shipOrderStateStr;

	//供应商编码")
	private String supNo;

	//供应商ID")
	private String supId;

	//供应商名称")
	private String supName;

	//供应商账户")
	private String supAccount;

	//采购方公司id")
	private String purCompanyId;

	//采购公司编码")
	private String purCompanyNo;

	//采购方公司名称")
	private String purCompanyName;

	//采购方机构id")
	private String purOrgId;

	//采购方机构编码")
	private String purOrgNo;

	//采购方机构名称")
	private String purOrgName;

	//运营单位机构id")
	private String proId;

	//运营单位机构编码")
	private String proNo;

	//运营机构名称")
	private String proName;

	//物流公司id")
	private String shipCompanyId;

	//物流公司名称")
	private String shipCompanyName;

	//物流单号")
	private String shipCompanyNo;

	//车牌号")
	private String carNo;

	//运输方式")
	private Integer transportMode;

	//发货时间")
	private Date shipTime;

	//发货联系人姓名")
	private String shipName;

	//发货联系人电话")
	private String shipPhone;

	//发货工号")
	private String shipOperId;

	//预计到货时间")
	private Date estimateArrivalTime;

	//到货时间")
	private Date arriveTime;

	//验收时间-该发货单全部被验收")
	private Date inspTime;

	//验收人名称-该发货单全部被验收")
	private String inspOperName;

	//验收人工号-该发货单全部被验收")
	private String inspOperId;

	//验收人电话-该发货单全部被验收")
	private String inspOperPhone;

	//发货备注")
	private String shipRemark;

	//到货备注")
	private String arriveRemark;

	//收/拒收 货人")
	private String receiverUser;

	//收/拒收 货备注")
	private String receiverRemark;

	//收/拒收 联系人")
	private String receiverContact;

	//收/拒收 时间")
	private Date receiverTime;

	//是否可以异常变更：1：不允许；其他情况都可以")
	private Integer isAbnormal;

	//流转状态")
	private String procState;

	//创建时间")
	private Date createTime;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新工号")
	private String updateOperId;

	//撤单时间")
	private Date cancelTime;

	//撤单工号")
	private String cancelOperId;

	//撤单原因")
	private String cancelReason;

	//撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	//备注")
	private String remark;

	//发货单扩展")
	private List<UocBaseExtParallelBo> extParallelBoList;

	//发货单明细")
	private List<UocQryShipOrderDetailsRspDetailItemBo> shipOrderItemBoList;

	//附件")
	private List<UocBaseOrderAccessoryTypeDetailBo> orderAccessoryBoList;
}
