package com.tydic.dyc.oc.service.saleorder.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @Description:销售单编辑入参
 * @Copyright: Copyright (c) 2019
 * @author: Ren Wei
 * @date 2024/6/27 15:40
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocSaleOrderItemUpdatePlanReqBo extends BaseReqBo {

    private static final long serialVersionUID = -527230092463398818L;
    /**
     * 销售单ID
     */
    private Long saleOrderId;
    /**
     * 销售单明细 ID
     */
    private Long saleOrderItemId;
    /**
     * 计划ID
     */
    private String planId;
    private String planNo;
    /**
     * 计划明细ID
     */
    private String planItemId;
    private String planItemNo;
    /**
     * 计划单位
     */
    private String planUnit;
    /**
     * 物料编号
     */
    private String skuMaterialId;
    private String skuMaterialCode;
    /**
     * 物料名称
     */
    private String skuMaterialName;
    /**
     * 计划来源1SAP;3电商平台
     */
    private Integer planSource;
    /**
     * 单位转换倍率
     */
    private BigDecimal planConversionRate;



}


