package com.tydic.dyc.oc.service.implorder.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述: 〈领域服务-执行单详情查询 出参〉
 * @author : yuhao
 * @date : 2022/8/1 11:05
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocGetImplOrderDetailsServiceRspBo extends BaseRspBo {

    private static final long serialVersionUID = -2011667544475282433L;


    /**
     * 销售单id
     */
    private Long saleOrderId;

    /**
     * 销售单编号
     */
    private String saleOrderNo;

    /**
     * 销售单状态
     */
    private String saleOrderState;

    /**
     * 销售单状态翻译
     */
    private String saleOrderStateStr;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 执行单编码
     */
    private String implOrderNo;

    /**
     * 外部执行单编码
     */
    private String implOrderNoExt;

    /**
     * 执行单名称
     */
    private String implOrderName;

    /**
     * 执行单类型
     */
    private Integer implOrderType;

    /**
     * 执行单类型翻译
     */
    private String implOrderTypeStr;

    /**
     * 执行单状态
     */
    private String implOrderState;

    /**
     * 执行单状态翻译
     */
    private String implOrderStateStr;

    /**
     * 执行单说明
     */
    private String implOrderDesc;

    /**
     * 销售金额
     */
    private BigDecimal totalSaleFee;

    /**
     * 采购金额
     */
    private BigDecimal totalPurchaseFee;

    /**
     * 优惠金额
     */
    private BigDecimal totalActShareFee;

    /**
     * 运费
     */
    private BigDecimal totalTransFee;

    /**
     * 实付金额
     */
    private BigDecimal usedFee;

    /**
     * 实付积分
     */
    private BigDecimal usedIntegral;

    /**
     * 协议编号
     */
    private String agreementNo;

    /**
     * 合同编号
     */
    private String contractNo;

    /**
     * 流转状态
     */
    private String procState;

    /**
     * 流转状态翻译
     */
    private String procStateStr;

    /**
     * 对账状态
     */
    private String checkState;

    /**
     * 对账状态翻译
     */
    private String checkStateStr;

    /**
     * 税率
     */
    private String taxRate;

    /**
     * 采购账套ID
     */
    private String purAccount;

    /**
     * 采购方账套名称
     */
    private String purAccountName;

    /**
     * 采购方联系人
     */
    private String purContactName;

    /**
     * 采购方联系人电话
     */
    private String purMobile;

    /**
     * 采购方下单人用户id
     */
    private String purUserId;

    /**
     * 采购方下单人真实姓名
     */
    private String purName;

    /**
     * 采购方下单人登录名
     */
    private String purUserName;

    /**
     * 采购方公司id
     */
    private String purCompanyId;

    /**
     * 采购公司编码
     */
    private String purCompanyNo;

    /**
     * 采购方公司名称
     */
    private String purCompanyName;

    /**
     * 采购方机构id
     */
    private String purOrgId;

    /**
     * 采购方机构编码
     */
    private String purOrgNo;

    /**
     * 采购方机构名称
     */
    private String purOrgName;

    /**
     * 下单组织机构路径
     */
    private String purOrgPath;

    /**
     * 需方联系人名称
     */
    private String purNeedName;

    /**
     * 需方联系电话
     */
    private String purNeedMobile;

    /**
     * 供应商id
     */
    private String supId;

    /**
     * 供应商编码
     */
    private String supNo;

    /**
     * 供应商名称
     */
    private String supName;

    /**
     * 供应商联系人
     */
    private String supRelaName;

    /**
     * 供应商联系电话
     */
    private String supRelaMobile;

    /**
     * 运营单位机构id
     */
    private String proId;

    /**
     * 运营单位机构编码
     */
    private String proNo;

    /**
     * 运营机构名称
     */
    private String proName;

    /**
     * 运营机构机构树路径
     */
    private String proOrgPath;

    /**
     * 运营机构账户名称
     */
    private String proAccountName;

    /**
     * 运营机构账户
     */
    private String proAccount;

    /**
     * 运营机构联系人
     */
    private String proRelaName;

    /**
     * 运营机构联系电话
     */
    private String proRelaMobile;

    /**
     * 协议经办人id（配送专责）
     */
    private String proDeliveryId;

    /**
     * 协议经办人名字（配送专责）
     */
    private String proDeliveryName;

    /**
     * 竣工标志 1 竣工  0 在途
     */
    private Integer finishFlag;

    /**
     * 竣工标志翻译
     */
    private String finishFlagStr;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建工号
     */
    private String createOperId;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新工号
     */
    private String updateOperId;

    /**
     * 撤单时间
     */
    private Date cancelTime;

    /**
     * 撤单工号
     */
    private String cancelOperId;

    /**
     * 取消原因
     */
    private String cancelReason;

    /**
     * 备注
     */
    private String remark;

    /**
     * 竣工时间
     */
    private Date finishTime;

    /**
     * 逾期时间
     */
    private Date expTime;

    /**
     * 结算模式 2:撮合 1:贸易
     */
    private Integer modelSettle;

    /**
     * 结算模式翻译
     */
    private String modelSettleStr;

    /**
     * 采购类别             1 物资             2 施工             3 服务
     */
    private Integer purchaseType;

    /**
     * 采购类别翻译
     */
    private String purchaseTypeStr;

    /**
     * 订单备注
     */
    private String orderRemark;

    /**
     * 付款方式，0 预付款按比例支付,1 按协议约束支付,2 按账期支付
     */
    private String payType;

    /**
     * 付款方式翻译
     */
    private String payTypeStr;

    /**
     * 订单来源 1 自营单品  2 电商导入 3 协议生成
     */
    private Integer orderSource;

    /**
     * 订单来源翻译
     */
    private String orderSourceStr;

    /**
     * 执行单明细信息
     */
    private List<UocGetImplOrderDetailsServiceRspItemBo> implOrderDetailsServiceRspBoList;

    /**
     * 执行单拓展信息
     */
    private List<UocGetImplOrderDetailsServiceRspExtBo> implOrderDetailsServiceRspExtBoList;

    /**
     * 收货信息
     */
    private UocGetImplOrderDetailsServiceRspReceiverAddressBo receiverAddressBo;

    /**
     * 附件信息
     */
    private List<UocBaseOrderAccessoryTypeDetailBo> accessoryDetailBoList;
}


