package com.tydic.dyc.oc.service.saleorder.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class UocSapSendOrderLog implements Serializable {
    private static final long serialVersionUID = -376379269420538987L;
    /**
     * sap订单推送记录id
     */
    private Long sendInfoId;
    /**
     * 订单 id
     */
    private Long orderId;
    /**
     * 销售单 id
     */
    private Long saleOrderId;
    /**
     * 销售单编号
     */
    private String saleOrderNo;
    /**
     * 销售单名称
     */
    private String saleOrderName;
    /**
     * sap订单号
     */
    private String sapOrderNo;
    /**
     * 能力平台能力名
     */
    private String platformName;
    /**
     * 能力平台流水号
     */
    private String platformNo;
    /**
     * 状态 1 推送成功 2 推送失败 3 回调失败 4 回调成功
     */
    private Integer status;
    /**
     * 推送类型：1 sap订单创建推送 2 sap订单取消推送
     */
    private Integer pushType;
    /**
     * 推送sap回调报文
     */
    private String pushRspParam;
    /**
     * sap 回调报文
     */
    private String sapRspParam;
    /**
     * 失败原因/请求返回
     */
    private String reason;
    private String reasons;
    /**
     * 采购汇总人ID
     */
    private Long purchaseUserId;
    /**
     * 采购汇总人姓名
     */
    private String purchaseUserName;
    /**
     * 采购单位 Id
     */
    private Long purchaseOrgId;
    /**
     * 采购单位名称
     */
    private String purchaseOrgName;
    /**
     * 采购人名称
     **/
    private String purUserName;
    /**
     * 采购人 ID
     */
    private Long purUserId;
    /**
     * 供应商 ID
     */
    private Long supplierId;
    /**
     * 供应商名称
     */
    private String supplierName;
    /**
     * 采购公司 id
     */
    private String purCompanyId;
    /**
     * 采购公司编号
     */
    private String purCompanyNo;
    /**
     * 采购公司名称
     */
    private String purCompanyName;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 下单人名称
     */
    private String createOrderName;

    private String saleOrderState;

}
