package com.tydic.dyc.oc.service.saleorder.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 描述: 〈领域服务-销售单接单/拒单入参〉
 * @author : yuhao
 * @date : 2022/7/27 15:42
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocSaleOrderRefuseReqBo extends BaseReqBo {
    private static final long serialVersionUID = -8572950541521182768L;

    /**
     * 接单结果：1接单 0拒单 2采购员直接拒收整单（不基于发货单）
     */
    private Integer confirmResult;
    /**
     * 订单id
     */
    private Long orderId;
    /**
     *销售单id
     */
    private Long saleOrderId;
    /**
     *任务id
     */
    private String taskId;
    /**
     *拒单原因，采购员拒收时，代表拒收信息
     */
    private String refuseReason;
    /**
     * 当前登录人id
     */
    private Long userId;
    /**
     * 当前登录人名称
     */
    private String name;
    /**
     *附件
     */
    private List<UocBaseOrderAccessoryAddBo> orderAccessoryBoList;

}
