package com.tydic.dyc.oc.components.event;

import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;

import java.util.List;
import java.util.Map;

/**
 * 标题:EventConsumer
 * 说明:时间消费者,解析从事件上返回的参数，传递给索引同步manager，进行数据同步（主要是做数据转换）
 * 时间:2022/3/11 10:01
 * 作者:田桂银
 */
public interface EventConsumer {

    /**
     * 描述:根据数据同步推送入参map，解析数据查询参数
     * @param map 入参
     * @return com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo
     * @author tgy
     * @date 2022/3/10 0:35
     */
    List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map);


    /**
     * 描述:获取实现类的事件编码
     * @return java.lang.String
     * @author tgy
     * @date 2022/3/11 10:12
     */
    String getEvent();

}
