package com.tydic.dyc.oc.model.insporder.qrybo;

import com.tydic.dyc.base.bo.BasePageReqBo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocInspOrderItemQryBo
 * 说明:验收明细
 * 时间:2022-02-21 19:09
 * 作者:罗有
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class UocInspOrderItemQryBo extends BasePageReqBo {
	private static final long serialVersionUID =  -1062571604944774068L;

	//验收明细id")
	private Long inspOrderItemId;

	//订单id")
	private Long orderId;

	//销售单id")
	private Long saleOrderId;

	//执行明细id")
	private Long implOrderItemId;

	//销售明细id")
	private Long saleOrderItemId;


	//验收单id")
	private Long inspOrderId;

	//发货明细ID")
	private Long shipOrderItemId;

	//状态1 已验收 2 退货申请中             3 退货完成")
	private String inspItemStatus;

	//计量单位")
	private String unitName;

	//验收数量")
	private BigDecimal inspCount;

	//退货中数量")
	private BigDecimal returnCount;

	//已退货数量")
	private BigDecimal alreadyReturnCount;

	//异常变更在途数量")
	private BigDecimal chngingCount;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//备注")
	private String remark;

	//删除标志1已删除")
	private Integer delTag;

	//扩展字段")
	private String extField1;

	//扩展字段")
	private String extField2;

	//扩展字段")
	private String extField3;

	//扩展字段")
	private String extField4;

	//扩展字段")
	private String extField5;

	//排序")
	private String orderBy;

	//执行单idList")
	private List<Long> saleOrderIdList;

	//验收明细id List")
	private List<Long> inspOrderItemIdList;

	//发货明细List")
	private List<Long> shipOrderItemIdList;
    
    //验收单idList （打印验收单用）")
    private List<Long> inspOrderIdList;
}
