package com.tydic.dyc.oc.model.saleorder;

import com.tydic.dyc.base.bo.BaseExtendBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocSaleOrder
 * 说明:销售订单
 * 时间:2022-02-21 14:26
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocSaleOrderDo  extends BaseExtendBo {
	private static final long serialVersionUID =  -2623077385921898547L;

	//销售单id")
	private Long saleOrderId;

	//订单id")
	private Long orderId;

	//三方信息id")
	private Long stakeholderId;

	//销售单编码")
	private String saleOrderNo;

	//外部销售单编码")
	private String saleOrderNoExt;

	//销售单名称")
	private String saleOrderName;

	//销售单类型")
	private Integer saleOrderType;

	//订单状态")
	private String saleOrderState;

	//订单状态翻译")
	private String saleOrderStateStr;

	//销售单单说明")
	private String saleOrderDesc;

	//订单来源  1 自营单品   2 电商导入   3 协议生成    ")
	private Integer orderSource;

	//订单来源翻译")
	private String orderSourceStr;

	//支付类型")
	private Integer payMod;

	//支付类型翻译")
	private String payModStr;

	//支付方式")
	private String payType;

	//支付方式翻译")
	private String payTypeStr;

	//销售金额")
	private BigDecimal totalSaleFee;

	//采购金额")
	private BigDecimal totalPurchaseFee;

	//优惠金额")
	private BigDecimal totalActShareFee;

	//运费")
	private BigDecimal totalTransFee;

	//实付金额")
	private BigDecimal usedFee;

	//实付积分")
	private BigDecimal usedIntegral;

	//协议id")
	private String agreementId;

	//协议编号")
	private String agreementNo;

	//协议数据id")
	private Long agrDataId;

	//合同编号")
	private String contractNo;

	//支付状态")
	private Integer payState;

	//支付状态翻译")
	private String payStateStr;

	//流转状态")
	private String procState;

	//流转状态翻译")
	private String procStateStr;

	//税率")
	private String taxRate;

	//竣工标志             1 竣工             0 在途")
	private Integer finishFlag;

	//竣工标志翻译")
	private String finishFlagStr;

	//租户ID")
	private String tenantId;

	//送货时间")
	private Date sendTime;

	//创建时间")
	private Date createTime;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新工号")
	private String updateOperId;

	//撤单时间")
	private Date cancelTime;

	//撤单工号")
	private String cancelOperId;

	//撤单原因")
	private String cancelReason;
	//取消原因标识，0用户主动取消，1审批时限自动取消，2审批驳回取消，3供应商主动取消，4电商消息主动取消
	private Integer cancelReasonFlag;

	//取消订单申请同意拒绝原因")
	private String cancelReplyContent;

	//取消订单申请同意拒绝原因时间")
	private Date cancelReplyTime;

	//创建人名称")
	private String createOperName;

	//更新人名称")
	private String updateOperName;

	//撤单人名称")
	private String cancelOperName;

	//供应商拒单原因")
	private String rejectReason;

	//供应商拒单人")
	private String rejectOperId;

	//供应商拒单人名称")
	private String rejectOperName;

	//供应商拒单时间")
	private Date rejectTime;

	//撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	//撤单标志翻译")
	private String cancelFlagStr;

	//竣工时间")
	private Date finishTime;

	//逾期时间")
	private Date expTime;

	//结算模式 2:撮合 1:贸易")
	private Integer modelSettle;

	//结算模式翻译")
	private String modelSettleStr;

	//采购类别             1 物资             2 施工             3 服务             ")
	private Integer purchaseType;

	//采购类别翻译")
	private String purchaseTypeStr;

	//采购模式   1计划，2非计划")
	private Integer purchaseMode;

	//采购模式翻译")
	private String purchaseModeStr;

	//备注")
	private String remark;

	//总金额")
	private BigDecimal totalFee;

	//总数量")
	private Integer totalCount;

	//撤单申请时间")
	private Date cancelRequestTime;

	//是否已关闭尾差 1是 0否")
	private Integer closePennyDiff;

	//销售单扩展")
	private List<UocSaleOrderMap> saleOrderMapList;

	//销售单明细")
	private List<UocSaleOrderItem> saleOrderItems;

	//三方信息")
	private UocSaleStakeholder stakeholder;

	//销售单支付配置")
	private List<UocSaleOrderPayConf> saleOrderPayConfList;

	//销售单附件")
	private List<UocOrderAccessory> saleOrderAccessoryList;

	//是否收取成交服务费")
	private Boolean isCreateServiceFee = false;

	//订单IDList")
	private List<Long> orderIdList;


	//销售单IdList")
	private List<Long> saleOrderItemsIdList;

	//协议经办人id（配送专责）")
	private String proDeliveryId;

	//协议经办人名字（配送专责）")
	private String proDeliveryName;

	//调价机制：0：无，1：事前调价，2：事中调价 默认值：0")
	private Integer adjustPrice;

	//订单创建结果 0创建中，1成功，2失败")
	private Integer createdResult;

	//调价人id")
	private String adjustPriceOperId;

	//调价人名称")
	private String adjustPriceOperName;

	//调价时间")
	private Date adjustPriceTime;
	//是否京东长直，1是，0否，默认0")
	private Integer jdCz;

	//是否京东长直，1是，0否，默认0 翻译")
	private String jdCzStr;

	//删除标志1已删除")
	private Integer delTag;

	//异常变更在途数量")
	private BigDecimal chngingCount;
    
    //父订单id 销售订单id")
    private Long upperOrderId;

    //供应商编码")
	private Long supId;

	//任务id")
	private String taskId;
	
	//状态列表")
    private List<String> saleOrderStateList;
    
    //创建时间 开始")
    private Date createTimeStart;
    
    //创建时间 结束")
    private Date createTimeEnd;
    
    //流程实例id")
    private String procInstId;
    
    //是否拆单生成订单")
    private Boolean splitCreateOrder = false;
    
    //议价单id
    private Long bargainingId;
    
    //议价单编号
    private String bargainingNo;

	/**
	 * 铺货单位ID
	 */
	private String managementOrgId;
	/**
	 * 铺货单位名称
	 */
	private String managementOrgName;

	//销售订单idList")
	private List<Long> saleOrderIdList;
    
    
}
