package com.tydic.dyc.oc.repository;

import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;

import java.util.List;

/**
 * 标题:UocInspOrderRepository
 * 说明:验收单
 * 时间:2022-02-21 14:33
 * 作者:罗有
 **/
public interface UocInspOrderRepository {
    /**
     * 创建验收单
     *
     * @param uocInspOrderDo
     */
    void createInspOrder(UocInspOrderDo uocInspOrderDo);

    /**
     * 创建验收单明细
     *
     * @param uocInspOrderDo
     */
    void createInspOrderItem(UocInspOrderDo uocInspOrderDo);

    /**
     * 修改验收单明细
     *
     * @param uocInspOrderDo
     */
    void updateInspOrderItem(UocInspOrderDo uocInspOrderDo);

    /**
     * 查询验收单信息
     *
     * @param uocInspOrderQryBo
     * @return
     */
    UocInspOrderDo getInspOrderMain(UocInspOrderQryBo uocInspOrderQryBo);

    /**
     * 查询验收单明细列表
     *
     * @param uocInspOrderItemQryBo
     * @return
     */
    UocInspOrderDo getListInspOrderItem(UocInspOrderItemQryBo uocInspOrderItemQryBo);

    /**
     * 查询验收单明细列表
     * @param uocInspOrderItemQryBo
     * @return
     */
    UocInspOrderDo getInspOrderItemList(UocInspOrderItemQryBo uocInspOrderItemQryBo);

    /**
     * 查询验收单列表
     *
     * @param uocInspOrderQryBo
     * @return
     */
    List<UocInspOrderDo> getListInspOrder(UocInspOrderQryBo uocInspOrderQryBo);

    /**
     * 查询验收总金额总数量
     * @author wenle
     * @date 2022-04-02 10:07:39
     * @param uocInspOrderQryBo 入参
     * @return com.tydic.dyc.oc.model.insporder.UocInspOrderDo
     */
    UocInspOrderDo qryTotalFeeAndCount(UocInspOrderQryBo uocInspOrderQryBo);

    void modifySaleOrderItemReturningCount(UocInspOrderItem uocSaleOrderItem);

    void modifyInspOrderItemChngingCount(UocInspOrderDo convertInspOrderDo);

    void modifyItemChngCountRefuse(UocInspOrderDo convertInspOrderDo);

    void modifyItemChngCountConfirm(UocInspOrderDo convertInspOrderDo);

    void modifyBatchItemInspConfirm(UocInspOrderDo convertInspOrderDo);

    void modifyItemChngCountConfirmAdd(UocInspOrderDo convertInspOrderDo);

    void modifyItemChngCountConfirmReduce(UocInspOrderDo convertInspOrderDo);

    void modifyInsporderChngTotalFeeConfirm(UocInspOrderDo convertInspOrderDo);

    void updateInspPayStatus(UocInspOrderDo convertInspOrderDo);

    void batchSyncInsp();
    
    void modifyItemRemainCountAdd(UocInspOrderDo convertInspOrderDo);
    
    void modifyItemRemainCountReduce(UocInspOrderDo convertInspOrderDo);
    
    void updateInspRemark(UocInspOrderDo convertInspOrderDo);
    
    
}
