package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgSplitOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgSplitOrderRspBo;
import com.tydic.dyc.oc.transactionservice.UocMsgSplitOrderTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

@HTServiceImpl
@Slf4j
public class UocMsgSplitOrderServiceImpl implements UocMsgSplitOrderService {
    
    @Autowired
    private UocMsgSplitOrderTransaction uocMsgSplitOrderTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    
    @Override
    public UocMsgSplitOrderRspBo splitOrder(UocMsgSplitOrderReqBo reqBo) {
        UocMsgSplitOrderRspBo rspBo = uocMsgSplitOrderTransaction.splitOrder(reqBo);
        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }
        return rspBo;
    }
    
    private void syncEs(UocMsgSplitOrderReqBo reqBo, UocMsgSplitOrderRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
    
        for (UocCreateOrderServiceRspSaleOrderBo uocCreateOrderServiceRspSaleOrderBo : rspBo.getSaleOrderList()) {
            SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
            saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
            saleBo.setOrderId(rspBo.getOrderId());
            saleBo.setObjId(uocCreateOrderServiceRspSaleOrderBo.getSaleOrderId());
            saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(saleBo);
        }
        
        if(ObjectUtil.isNotEmpty(rspBo.getShipOrderIdList())){
            for (Long shipOrderId : rspBo.getShipOrderIdList()) {
                SyncEsRunnableBo shipBo = new SyncEsRunnableBo();
                shipBo.setIndexName(uocIndexConfig.getShipOrderIndex());
                shipBo.setOrderId(rspBo.getOrderId());
                shipBo.setObjId(shipOrderId);
                shipBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(shipBo);
            }
        }
        
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}
