/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.common;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.sub.UocOutLogSaveDo;
import com.tydic.dyc.oc.service.common.UocOutLogSaveService;
import com.tydic.dyc.oc.service.common.bo.UocOutLogSaveServiceReqBo;
import com.tydic.dyc.oc.service.common.bo.UocOutLogSaveServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.common.UocOutLogSaveService"})
public class UocOutLogSaveServiceImpl
implements UocOutLogSaveService {
    @Autowired
    private IUocCommonModel iUocCommonModel;

    @PostMapping(value={"saveOutLog"})
    public UocOutLogSaveServiceRspBo saveOutLog(@RequestBody UocOutLogSaveServiceReqBo reqBo) {
        this.validateArg(reqBo);
        UocOutLogSaveDo saveDo = new UocOutLogSaveDo();
        BeanUtils.copyProperties((Object)reqBo, (Object)saveDo);
        saveDo.setLogId(IdUtil.nextId());
        saveDo.setCreateTimeInner(new Date());
        this.iUocCommonModel.saveOutLog(saveDo);
        UocOutLogSaveServiceRspBo rspBo = UocRu.success(UocOutLogSaveServiceRspBo.class);
        rspBo.setLogId(saveDo.getLogId());
        return rspBo;
    }

    private void validateArg(UocOutLogSaveServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("102001", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getSystemType() == null) {
            throw new BaseBusinessException("102001", "\u7cfb\u7edf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getLogType() == null) {
            throw new BaseBusinessException("102001", "\u65e5\u5fd7\u65b9\u5411\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getLogFlag() == null) {
            throw new BaseBusinessException("102001", "\u65e5\u5fd7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getPartitionObjId() == null) {
            throw new BaseBusinessException("102001", "\u5206\u5e93\u952e\u5bf9\u8c61id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getBusiObjId() == null) {
            throw new BaseBusinessException("102001", "\u4e1a\u52a1\u5bf9\u8c61id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getBusiObjType() == null) {
            throw new BaseBusinessException("102001", "\u4e1a\u52a1\u5bf9\u8c61\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getReqParam() == null) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCreateTime() == null) {
            throw new BaseBusinessException("102001", "\u5916\u90e8\u4e1a\u52a1\u521b\u5efa\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

