/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocArrvalAcceptanceBySaleOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceBySaleOrderRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceBySaleOrderServiceReqBo;
import com.tydic.dyc.oc.transactionservice.UocArrvalAcceptanceBySaleOrderTransaction;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocArrvalAcceptanceBySaleOrderService"})
public class UocArrvalAcceptanceBySaleOrderServiceImpl
implements UocArrvalAcceptanceBySaleOrderService {
    private static final Logger log = LoggerFactory.getLogger(UocArrvalAcceptanceBySaleOrderServiceImpl.class);
    @Autowired
    private UocArrvalAcceptanceBySaleOrderTransaction uocArrvalAcceptanceBySaleOrderTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"dealArrvalAcceptance"})
    public UocArrvalAcceptanceBySaleOrderRspBo dealArrvalAcceptance(@RequestBody UocArrvalAcceptanceBySaleOrderServiceReqBo reqBo) {
        UocArrvalAcceptanceBySaleOrderRspBo rspBo = this.uocArrvalAcceptanceBySaleOrderTransaction.dealArrvalAcceptance(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocArrvalAcceptanceBySaleOrderServiceReqBo reqBo, UocArrvalAcceptanceBySaleOrderRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        SyncEsRunnableBo inspBo = new SyncEsRunnableBo();
        inspBo.setIndexName(this.uocIndexConfig.getInspOrderIndex());
        inspBo.setOrderId(reqBo.getOrderId());
        inspBo.setObjId(rspBo.getInspOrderId());
        inspBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleBo);
        list.add(inspBo);
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

