/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.saleorder.UocSaleOrderUpdateOaInfoService;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderUpdateOaInfoReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderUpdateOaInfoRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocSaleOrderUpdateOaInfoService"})
public class UocSaleOrderUpdateOaInfoServiceImpl
implements UocSaleOrderUpdateOaInfoService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @PostMapping(value={"updateSaleOrderOaInfo"})
    public UocSaleOrderUpdateOaInfoRspBo updateSaleOrderOaInfo(@RequestBody UocSaleOrderUpdateOaInfoReqBo reqBo) {
        this.validateArg(reqBo);
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOaAuditRemark(reqBo.getOaAuditRemark());
        uocSaleOrderDo.setOaAuditResult(reqBo.getOaAuditResult());
        this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        List attachmentUrlList = reqBo.getAttachmentUrlList();
        if (attachmentUrlList != null) {
            this.saveAccessoryInfo(attachmentUrlList.stream().map(e -> {
                UocBaseOrderAccessoryAddBo uocBaseOrderAccessoryAddBo = new UocBaseOrderAccessoryAddBo();
                uocBaseOrderAccessoryAddBo.setAccessoryUrl(e);
                return uocBaseOrderAccessoryAddBo;
            }).collect(ArrayList::new, ArrayList::add, ArrayList::addAll), reqBo);
        }
        return UocRu.success(UocSaleOrderUpdateOaInfoRspBo.class);
    }

    private void saveAccessoryInfo(List<UocBaseOrderAccessoryAddBo> orderAccessoryBoList, UocSaleOrderUpdateOaInfoReqBo reqBo) {
        ArrayList<UocOrderAccessory> uocOrderAccessoryList = new ArrayList<UocOrderAccessory>();
        for (UocBaseOrderAccessoryAddBo uocBaseOrderAccessoryAddBo : orderAccessoryBoList) {
            UocOrderAccessory uocOrderAccessory = new UocOrderAccessory();
            BeanUtils.copyProperties((Object)uocBaseOrderAccessoryAddBo, (Object)uocOrderAccessory);
            uocOrderAccessory.setId(IdUtil.nextId());
            uocOrderAccessory.setObjId(reqBo.getSaleOrderId());
            uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            uocOrderAccessory.setOrderId(reqBo.getOrderId());
            uocOrderAccessory.setCreateTime(new Date());
            uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.OA_APPROVAL_RESULT);
            uocOrderAccessoryList.add(uocOrderAccessory);
        }
        this.iUocOrderModel.createOrderAccessory(uocOrderAccessoryList);
    }

    private void validateArg(UocSaleOrderUpdateOaInfoReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException("100001", "\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

