package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderItemUpdatePlanReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderItemUpdatePlanRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderUpdatePlanStateReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderUpdatePlanStateRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * @Description:变更销售单计划实现
 * @Copyright: Copyright (c) 2019
 * @author: Ren Wei
 * @date 2024/6/27 16:37
 */
@HTServiceImpl
public class UocSaleOrderUpdatePlanStateServiceImpl implements UocSaleOrderUpdatePlanStateService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Override
    public UocSaleOrderUpdatePlanStateRspBo updateSaleOrderPlanState(UocSaleOrderUpdatePlanStateReqBo reqBo) {
        //参数校验
        this.validateArg(reqBo);
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setIsReducedPlan(reqBo.getIsReducedPlan());
        uocSaleOrderDo.setPurchaseMode(reqBo.getPurchaseMode());
        iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        return UocRu.success(UocSaleOrderUpdatePlanStateRspBo.class);
    }
    /**
     * 参数校验
     * @param reqBo
     */
    private void validateArg(UocSaleOrderUpdatePlanStateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单ID不能为空");
        }
    }



}
