package com.tydic.dyc.oc.model.order.sub;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题:UocTodo
 * 说明:待办
 * 时间:2022-10-27 10:02
 * 作者:王久鑫
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocTodo implements Serializable {

    private static final long serialVersionUID = -7313897616469607933L;
    /**
     * 待办ID
     */
    private Long todoId;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 业务ID
     */
    private String busiId;

    /**
     * 待办项编码
     */
    private String todoItemCode;

    /**
     * 待办名称
     */
    private String todoName;

    /**
     * 待办项名称
     */
    private String todoItemName;

    /**
     * 跳转链接
     */
    private String todoUrl;

    /**
     * 待办模块名称
     */
    private String todoModuleName;

    /**
     * 待办模块编码
     */
    private String todoModuleCode;

    /**
     * 待办状态 0待办 1已办 2他人已办
     */
    private Integer todoState;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 代办人ID
     */
    private String candidateOperId;

    /**
     * 代办人名称
     */
    private String candidateOperName;
}


