package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocQrySapSendOrderLogReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocQrySapSendOrderLogRspBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocSapSendOrderLog;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
/**
 * @description sap回调信息查询接口
 * @author Luokan
 * @date 2024/07/08
 **/

@HTServiceImpl
public class UocQrySapSendOrderLogServiceImpl implements UocQrySapSendOrderLogService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocQrySapSendOrderLogRspBO qrySapSendOrderLog(UocQrySapSendOrderLogReqBO reqBO) {
        UocQrySapSendOrderLogRspBO rspBO = new UocQrySapSendOrderLogRspBO();
        BasePageRspBo<UocSapSendOrderLog> result = this.iUocSaleOrderModel.getSapSendInfoListPage(reqBO);
        rspBO.setRows(result.getRows());
        rspBO.setPageNo(result.getPageNo());
        rspBO.setTotal(result.getTotal());
        rspBO.setRecordsTotal(result.getRecordsTotal());
        return rspBO;
    }
}
