package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.sub.UocInspOrderItemTemporarily;
import com.tydic.dyc.oc.model.saleorder.sub.UocInspOrderTemporarily;
import com.tydic.dyc.oc.service.saleorder.bo.UocInspOrderItemTemporarilyBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocInspOrderTemporarilyBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocQryTempInspListReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocQryTempInspListRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @description sap零时验收信息查询接口
 * @author Luokan
 * @date 2024/07/08
 **/
@HTServiceImpl
public class UocQryTempInspListServiceImpl implements UocQryTempInspListService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocQryTempInspListRspBO qryTempInspList(UocQryTempInspListReqBO reqBO) {
        UocQryTempInspListRspBO rspBO = UocRu.success(UocQryTempInspListRspBO.class);
        BasePageRspBo<UocInspOrderTemporarily> result = this.iUocSaleOrderModel.selectTempInspOrderListPage(reqBO);
        rspBO.setRows(UocRu.jsl(result.getRows(), UocInspOrderTemporarilyBO.class));
        if (!CollectionUtils.isEmpty(rspBO.getRows())) {
            //补全验收明细
            UocInspOrderItemTemporarily qryTempItem = new UocInspOrderItemTemporarily();
            qryTempItem.setTempInspOrderIds(rspBO.getRows().stream().map(UocInspOrderTemporarilyBO::getTempInspOrderId).collect(Collectors.toList()));
            List<UocInspOrderItemTemporarily> resultTempItemList = this.iUocSaleOrderModel.selectTempInspOrderItemList(qryTempItem);
            Map<Long, List<UocInspOrderItemTemporarily>> tempItemMap = resultTempItemList.stream().collect(Collectors.groupingBy(UocInspOrderItemTemporarily::getTempInspOrderId));
            for (UocInspOrderTemporarilyBO bo : rspBO.getRows()) {
                bo.setInspOrderItemTemporarilyBOList(UocRu.jsl(tempItemMap.get(bo.getTempInspOrderId()), UocInspOrderItemTemporarilyBO.class));
            }
        }
        rspBO.setPageNo(result.getPageNo());
        rspBO.setTotal(result.getTotal());
        rspBO.setRecordsTotal(result.getRecordsTotal());
        return rspBO;
    }
}
