package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderRelQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 标题:UocChngOrderConfirmOrRefuseForInspTransaction
 * 说明:
 * 时间:2023/8/26 17:33
 * 作者:田桂银
 */
@Slf4j
@Component
public class UocChngOrderConfirmOrRefuseForInspTransaction {

    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    private static final Integer OP_FLAG_CONFIRM = 1;

    private static final Integer OP_FLAG_REFUSE = 0;

    private static final Integer CHNG_TYPE_ADD = 1;

    private static final Integer CHNG_TYPE_SUBTRACT = 2;


    @Value("${updateChingNumFlag:false}")
    private boolean updateChingNumFlag;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocChngOrderConfirmOrRefuseForInspRspBo dealConfirmOrRefuse(UocChngOrderConfirmOrRefuseForInspReqBo reqBo) {
        UocChngOrderConfirmOrRefuseForInspRspBo rspBo = UocRu.success(UocChngOrderConfirmOrRefuseForInspRspBo.class);
        validateArg(reqBo);
        String operId = reqBo.getUserId().toString();
        Date now = new Date();
        //查询变更明细
        List<UocChngOrderItemObj> uocChngOrderItemObjList = getListChngOrderItemObj(reqBo);
        //批量更新变更主体信息:主要是uoc_chng_order状态
        iUocChngOrderModel.modifyBatchChngOrderState(convertChngOrderDo(reqBo, now, operId));
        Map<Integer, List<UocChngOrderItemObj>> chngItems = uocChngOrderItemObjList.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getChngType));

        List<UocChngOrderItemObj> uocChngNums = chngItems.get(UocConstant.BUSI_TYPE.NUM);
        List<UocChngOrderItemObj> uocChngState = chngItems.get(UocConstant.BUSI_TYPE.STATE);

        //数量变更
        if (!CollectionUtil.isEmpty(uocChngNums)) {
            if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) && !updateChingNumFlag) {
                confirm(reqBo, operId, now, uocChngNums);
            }
            if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
                refuse(reqBo, operId, now, uocChngNums);
            }
        }
        //状态变更
        List<String> inspOrderIds = null;
        if (!CollectionUtil.isEmpty(uocChngState)) {
            if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) && !updateChingNumFlag) {
                inspOrderIds = confirmStat(reqBo, operId, now, uocChngState);
                getShipTaskInsts(reqBo, rspBo);
                getSaleOrderInfo(reqBo, rspBo);
            }
            if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
                refuseState(reqBo, operId, now, uocChngState);
            }
        }
        //更新销售单状态
        updateSaleOrdersTate(reqBo);
        reqBo.getChngOrderList().forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            // 提交任务
            UocCommonDo uocCommonDo = new UocCommonDo();
            List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(uocChngOrderConfirmOrRefuseReqItemBo.getTaskId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            uocCommonDo.setUserId(11111L);
            uocCommonDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            iUocCommonModel.dealTask(uocCommonDo);
        });
        dealMap(reqBo, now);
        //封装出参对象 (查询销售单明细 ，验收单明细)
        buildSyncRsp(reqBo, rspBo, uocChngOrderItemObjList);
        if (!CollectionUtils.isEmpty(inspOrderIds)) {
            if (CollectionUtils.isEmpty(rspBo.getInspOrderIdList())) {
                rspBo.setInspOrderIdList(inspOrderIds);
            } else {
                rspBo.getInspOrderIdList().addAll(inspOrderIds);
            }
        }
        //更新验收单-结算单关联信息
        log.debug("更新完结关联信息开始：" + JSON.toJSONString(rspBo.getInspOrderIdList()));
        if (!CollectionUtil.isEmpty(uocChngNums) && !CollectionUtils.isEmpty(rspBo.getInspOrderIdList())) {
            this.updateRelState(rspBo.getInspOrderIdList());
        }
        log.debug("更新完结关联信息结束");
        return rspBo;
    }

    /**
     * 更新验收单-结算单关联信息
     *
     * @param inspOrderIdList
     */
    private void updateRelState(List<String> inspOrderIdList) {
        for (String inspOrderId : inspOrderIdList) {
            String[] split = inspOrderId.split("-");
            //先根据销售单查询uoc_order_rel表
            UocOrderRelQryBo uocOrderRelQryBo = new UocOrderRelQryBo();
            uocOrderRelQryBo.setObjId(Long.valueOf(split[0]));
            uocOrderRelQryBo.setOrderId(Long.valueOf(split[1]));
            uocOrderRelQryBo.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
            List<UocOrderRel> qryRelResult = this.iUocOrderModel.qryListRelInfo(uocOrderRelQryBo);
            if (CollectionUtils.isEmpty(qryRelResult)) {
                continue;
            }
            //查询验收单信息
            UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
            uocInspOrderQryBo.setOrderId(Long.valueOf(split[1]));
            uocInspOrderQryBo.setInspOrderId(Long.valueOf(split[0]));
            List<UocInspOrderDo> qryInspResult = this.iUocInspOrderModel.getListInspOrder(uocInspOrderQryBo);
            if (CollectionUtils.isEmpty(qryInspResult) || qryInspResult.size() != 1) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "查询验收单信息为空！");
            }
            //查询销售单
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setOrderId(qryInspResult.get(0).getOrderId());
            uocSaleOrderDo.setSaleOrderId(qryInspResult.get(0).getSaleOrderId());
            UocSaleOrderDo qrySaleResult = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
            if (null == qrySaleResult) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_NUM_CHNG_APPLY_ERROR, "查询销售单为空！");
            }
            //电商逻辑
            if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(qrySaleResult.getOrderSource())) {
                //贸易模式将relType为0和1的relState改为0未提交
                //撮合模式将relType为3的relState改为0未提交
                if (UocDicConstant.MODEL_SETTLE.TRADE.equals(qrySaleResult.getModelSettle())) {
                    List<UocOrderRel> updateRelList = qryRelResult.stream().filter(bo -> UocDicConstant.REL_TYPE.COMMON_INVOICE.equals(bo.getRelType()) || UocDicConstant.REL_TYPE.UP_INVOICE.equals(bo.getRelType())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(updateRelList)) {
                        this.updateRelStateData(updateRelList, UocDicConstant.REL_STATUS.UN_SUBMITTED);
                    }
                } else {
                    List<UocOrderRel> updateRelList = qryRelResult.stream().filter(bo -> UocDicConstant.REL_TYPE.CH_INVOICE.equals(bo.getRelType())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(updateRelList)) {
                        this.updateRelStateData(updateRelList, UocDicConstant.REL_STATUS.UN_SUBMITTED);
                    }
                }
                //协议/无协议逻辑
            } else {
                //贸易模式先查询relType为0和1对应的数据 如果relState 不等于 1，将relState改为0未提交
                //撮合模式先查询relType为3对应的数据 如果relState 不等于 1，的relState改为0未提交
                if (UocDicConstant.MODEL_SETTLE.TRADE.equals(qrySaleResult.getModelSettle())) {
                    List<UocOrderRel> updateRelList = qryRelResult.stream().filter(bo -> (UocDicConstant.REL_TYPE.COMMON_INVOICE.equals(bo.getRelType()) || UocDicConstant.REL_TYPE.UP_INVOICE.equals(bo.getRelType())) && !UocDicConstant.REL_STATUS.SUBMITTED.equals(bo.getRelStatus())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(updateRelList)) {
                        this.updateRelStateData(updateRelList, UocDicConstant.REL_STATUS.UN_SUBMITTED);
                    }
                } else {
                    List<UocOrderRel> updateRelList = qryRelResult.stream().filter(bo -> UocDicConstant.REL_TYPE.CH_INVOICE.equals(bo.getRelType()) && !UocDicConstant.REL_STATUS.SUBMITTED.equals(bo.getRelStatus())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(updateRelList)) {
                        this.updateRelStateData(updateRelList, UocDicConstant.REL_STATUS.UN_SUBMITTED);
                    }
                }
            }
        }
    }

    /**
     * 更新数据
     *
     * @param updateRelList
     * @param relStatus
     */
    private void updateRelStateData(List<UocOrderRel> updateRelList, Integer relStatus) {
        for (UocOrderRel updateRel : updateRelList) {
            UocOrderRel updateRelPO = new UocOrderRel();
            updateRelPO.setId(updateRel.getId());
            updateRelPO.setRelStatus(relStatus);
            this.iUocOrderModel.dealRelUpdate(updateRelPO);
        }
    }

    /**
     * 更新销售单状态
     *
     * @param reqBo
     */
    private void updateSaleOrdersTate(UocChngOrderConfirmOrRefuseForInspReqBo reqBo) {
        List<Long> chngOrderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList());
        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setChngOrderIdList(chngOrderIdList);
        List<UocChngOrderObj> chngOrderObjList = this.iUocChngOrderModel.getListChngOrderObjWithOutItem(uocChngOrderObjQryBo);
        if (ObjectUtil.isEmpty(chngOrderObjList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "查询变更单对象为空");
        }
        List<Long> saleOrderIdList = chngOrderObjList.stream().map(UocChngOrderObj::getSaleOrderId).collect(Collectors.toList());
        //查询销售单明细
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderIdList(saleOrderIdList);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (ObjectUtil.isEmpty(saleOrderItemList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "查询销售明细为空");
        }

        // 迪易采3.2版本，电商订单异常变更部分验收改成已验收
        List<UocSaleOrderItem> ecSaleOrderItemList = saleOrderItemList.stream().filter(bo -> UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(bo.getSkuSource())).collect(Collectors.toList());
        Boolean ecFlag = false;
        if (!CollectionUtils.isEmpty(ecSaleOrderItemList)) {
            ecFlag = true;
        }

        //按销售单分组
        Map<Long, List<UocSaleOrderItem>> saleOrderItemMapBySale = saleOrderItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getSaleOrderId));
        for (Long saleOrderId : saleOrderItemMapBySale.keySet()) {
            List<UocSaleOrderItem> itemList = saleOrderItemMapBySale.get(saleOrderId);
            BigDecimal totalPurchaseCount = itemList.stream().map(UocSaleOrderItem::getPurchaseCount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalInspCount = itemList.stream().map(UocSaleOrderItem::getAcceptanceCount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalArrivedCount = itemList.stream().map(UocSaleOrderItem::getArriveCount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalRefusedCount = itemList.stream().map(UocSaleOrderItem::getRefuseCount).reduce(BigDecimal.ZERO, BigDecimal::add);
            log.debug("saleOrderId=" + saleOrderId + ",totalInspCount:=" + totalInspCount + ",totalArrivedCount:=" + totalArrivedCount + ",totalRefusedCount:=" + totalRefusedCount);
            if (totalInspCount.compareTo(BigDecimal.ZERO) != 0 && totalRefusedCount.compareTo(BigDecimal.ZERO) != 0) {
                //验收数量，拒收数量都不为0，则为部分验收
                log.debug("saleOrderId=" + saleOrderId + ":XS_YS_BFYS");
                String saleOrderState = UocStateConstants.SaleOrder.XS_YS_BFYS;
                if (ecFlag) {
                    log.debug("saleOrderId=" + saleOrderId + ":XS_YS_YS,电商不存在部分验收");
                    saleOrderState = UocStateConstants.SaleOrder.XS_YS_YS;
                }
                this.updateSaleOrderMain(itemList.get(0).getOrderId(), saleOrderId, saleOrderState, reqBo.getUserId(), reqBo.getName());
            }
            if (totalInspCount.compareTo(BigDecimal.ZERO) == 0 && totalArrivedCount.compareTo(BigDecimal.ZERO) != 0 && totalRefusedCount.compareTo(BigDecimal.ZERO) != 0) {
                //到货数量，拒收数量都不为0，验收数量为0则为部分到货
                log.debug("saleOrderId=" + saleOrderId + ":XS_DH_BFDH");
                this.updateSaleOrderMain(itemList.get(0).getOrderId(), saleOrderId, UocStateConstants.SaleOrder.XS_DH_BFDH, reqBo.getUserId(), reqBo.getName());
            }
            if (totalInspCount.compareTo(BigDecimal.ZERO) == 0 && totalArrivedCount.compareTo(BigDecimal.ZERO) == 0 && totalRefusedCount.compareTo(BigDecimal.ZERO) != 0) {
                //拒收数量不为0，到货数量为0，验收数量为0则为拒收
                log.debug("saleOrderId=" + saleOrderId + ":XS_DH_JS");
                this.updateSaleOrderMain(itemList.get(0).getOrderId(), saleOrderId, UocStateConstants.SaleOrder.XS_DH_JS, reqBo.getUserId(), reqBo.getName());
            }
            if (totalInspCount.compareTo(BigDecimal.ZERO) != 0 && totalRefusedCount.compareTo(BigDecimal.ZERO) == 0) {
                //验收数量不为0，拒收数量为0，验收数量为0则为验收
                log.debug("saleOrderId=" + saleOrderId + ":XS_YS_YS");
                this.updateSaleOrderMain(itemList.get(0).getOrderId(), saleOrderId, UocStateConstants.SaleOrder.XS_YS_YS, reqBo.getUserId(), reqBo.getName());
            }
            if (totalInspCount.compareTo(BigDecimal.ZERO) == 0 && totalArrivedCount.compareTo(BigDecimal.ZERO) != 0 && totalRefusedCount.compareTo(BigDecimal.ZERO) == 0) {
                //到货数量不为0，拒收数量都为0，验收数量为0则为到货
                log.debug("saleOrderId=" + saleOrderId + ":XS_DH_DH");
                this.updateSaleOrderMain(itemList.get(0).getOrderId(), saleOrderId, UocStateConstants.SaleOrder.XS_DH_DH, reqBo.getUserId(), reqBo.getName());
            }
        }
    }

    /**
     * 更新销售单状态
     *
     * @param orderId
     * @param saleOrderId
     * @param saleOrderState
     * @param userId
     * @param name
     */
    private void updateSaleOrderMain(Long orderId, Long saleOrderId, String saleOrderState, Long userId, String name) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderState(saleOrderState);
        uocSaleOrderDo.setOrderId(orderId);
        uocSaleOrderDo.setSaleOrderId(saleOrderId);
        uocSaleOrderDo.setUpdateOperId(userId.toString());
        uocSaleOrderDo.setUpdateOperName(name);
        uocSaleOrderDo.setUpdateTime(new Date());
        this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
    }

    /**
     * 处理拒绝
     *
     * @param reqBo
     * @param operId
     * @param now
     * @param uocChngOrderItemObjList
     */
    private void refuse(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        iUocSaleOrderModel.modifyItemChngCountRefuse(convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
        // 验收单明细异常变更数量更新为0
        iUocInspOrderModel.modifyItemChngCountRefuse(convertInspOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
    }

    /**
     * 处理确认
     *
     * @param reqBo
     * @param operId
     * @param now
     * @param uocChngOrderItemObjList
     */
    private void confirm(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        for (UocChngOrderItemObj uocChngOrderItemObj : uocChngOrderItemObjList) {
            if (uocChngOrderItemObj.getAddOrSubtractType().equals(CHNG_TYPE_ADD)) {
                //验收单明细表：insp_count、remain_insp_count，chnging_count
                iUocInspOrderModel.modifyItemChngCountConfirmAdd(convertInspOrderDoForSingle(reqBo, now, operId, uocChngOrderItemObj));
                //销售单明细表：acceptance_count、chnging_count
                iUocSaleOrderModel.modifyItemChngCountConfirmAdd(convertSaleOrderDoForSingle(reqBo, now, operId, uocChngOrderItemObj));
                //变更单明细表：remain_insp_count
                iUocChngOrderModel.modifyItemChngCountConfirm(uocChngOrderItemObj);
            } else if (uocChngOrderItemObj.getAddOrSubtractType().equals(CHNG_TYPE_SUBTRACT)) {
                //减少验收数量
                iUocInspOrderModel.modifyItemChngCountConfirmReduce(convertInspOrderDoForSingle(reqBo, now, operId, uocChngOrderItemObj));
                iUocSaleOrderModel.modifyItemChngCountConfirmReduce(convertSaleOrderDoForSingle(reqBo, now, operId, uocChngOrderItemObj));
                iUocChngOrderModel.modifyItemChngCountConfirm(uocChngOrderItemObj);
            }
        }
        //验收单表：total_sale_fee、total_purchase_fee
        chngInspFee(uocChngOrderItemObjList, reqBo);
    }

    private void chngInspFee(List<UocChngOrderItemObj> uocChngOrderItemObjList, UocChngOrderConfirmOrRefuseForInspReqBo reqBO) {
        List<Long> inspItemIdList = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getInspOrderItemId).distinct().collect(Collectors.toList());
        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setInspOrderItemIdList(inspItemIdList);
        UocInspOrderDo uocInspOrderDo = iUocInspOrderModel.getInspOrderItemList(uocInspOrderItemQryBo);
        if (null == uocInspOrderDo || CollectionUtils.isEmpty(uocInspOrderDo.getUocInspOrderItemList())) {
            throw new ZTBusinessException("查询验收单明细信息失败");
        }
        Map<Long, List<UocChngOrderItemObj>> inspItemMap = uocChngOrderItemObjList.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getInspOrderItemId));

        Map<Long, List<UocInspOrderItem>> inspOrderMap = uocInspOrderDo.getUocInspOrderItemList().stream().collect(Collectors.groupingBy(UocInspOrderItem::getInspOrderId));
        inspOrderMap.forEach((k, v) -> {
            BigDecimal totalAddSaleFee = BigDecimal.ZERO;
            BigDecimal totalAddPurchaseFee = BigDecimal.ZERO;
            BigDecimal totalReduceSaleFee = BigDecimal.ZERO;
            BigDecimal totalReducePurchaseFee = BigDecimal.ZERO;
            for (UocInspOrderItem item : v) {
                UocChngOrderItemObj uocChngOrderItemObj = inspItemMap.get(item.getInspOrderItemId()).get(0);
                if (uocChngOrderItemObj.getAddOrSubtractType().equals(CHNG_TYPE_ADD)) {
                    totalAddSaleFee = totalAddSaleFee.add(uocChngOrderItemObj.getChngFee());
                    totalAddPurchaseFee = totalAddPurchaseFee.add(uocChngOrderItemObj.getChngPurchaseFee());
                } else if (uocChngOrderItemObj.getAddOrSubtractType().equals(CHNG_TYPE_SUBTRACT)) {
                    totalReduceSaleFee = totalReduceSaleFee.add(uocChngOrderItemObj.getChngFee());
                    totalReducePurchaseFee = totalReducePurchaseFee.add(uocChngOrderItemObj.getChngPurchaseFee());
                }
            }
            //变更的销售金额 = 变更减少的金额（退款）- 变更增加的金额（付款）
            BigDecimal totalSaleChngFee = totalReduceSaleFee.subtract(totalAddSaleFee);
            BigDecimal totalPurchaseChngFee = totalReducePurchaseFee.subtract(totalAddPurchaseFee);
            UocInspOrderDo orderDo = new UocInspOrderDo();
            orderDo.setInspOrderId(k);
            orderDo.setTotalSaleFee(totalSaleChngFee);
            orderDo.setTotalPurchaseFee(totalPurchaseChngFee);
            orderDo.setUpdateOperId(reqBO.getUserId().toString());
            orderDo.setUpdateTime(new Date());
            iUocInspOrderModel.modifyInsporderChngTotalFeeConfirm(orderDo);
        });
    }

    private UocInspOrderDo convertInspOrderDoForSingle(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, Date now, String operId, UocChngOrderItemObj uocChngOrderItemObj) {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setInspOrderItemsIdList(Arrays.asList(uocChngOrderItemObj.getInspOrderItemId()));
        uocInspOrderDo.setOrderIdList(Arrays.asList(uocChngOrderItemObj.getOrderId()));
        //验收变更数量
        uocInspOrderDo.setInspCount(uocChngOrderItemObj.getChngNum());
        uocInspOrderDo.setUpdateTime(now);
        uocInspOrderDo.setUpdateOperId(operId);
        return uocInspOrderDo;
    }

    private UocSaleOrderDo convertSaleOrderDoForSingle(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, Date now, String operId, UocChngOrderItemObj uocChngOrderItemObj) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setUpdateOperId(operId);
        uocSaleOrderDo.setUpdateTime(now);
        //验收变更数量
        uocSaleOrderDo.setChngingCount(uocChngOrderItemObj.getChngNum());
        uocSaleOrderDo.setOrderIdList(Collections.singletonList(uocChngOrderItemObj.getOrderId()));
        uocSaleOrderDo.setSaleOrderItemsIdList(Collections.singletonList(uocChngOrderItemObj.getSaleOrderItemId()));
        return uocSaleOrderDo;
    }

    /**
     * 查询验收单信息信息
     *
     * @param reqBo
     * @param now
     * @param operId
     * @param uocChngOrderItemObjList
     * @return
     */
    private UocInspOrderDo convertInspOrderDo(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setInspOrderItemsIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getInspOrderItemId).collect(Collectors.toList()));
        uocInspOrderDo.setOrderIdList(orderIdList);
        uocInspOrderDo.setUpdateTime(now);
        uocInspOrderDo.setUpdateOperId(operId);
        return uocInspOrderDo;
    }

    /**
     * 查询执行单信息
     */
    private UocSaleOrderDo convertSaleOrderDo(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setUpdateOperId(operId);
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList()));
        uocSaleOrderDo.setSaleOrderItemsIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList()));
        return uocSaleOrderDo;
    }

    /**
     * 组装变更单信息
     */
    private List<UocChngOrderDo> convertChngOrderDo(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, Date now, String operId) {
        String state = getState(reqBo);
        return reqBo.getChngOrderList().stream().map(uocChngOrderConfirmOrRefuseReqItemBo -> {
            UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
            uocChngOrderDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            uocChngOrderDo.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
            uocChngOrderDo.setChngOrderState(state);
            uocChngOrderDo.setUpdateTime(now);
            uocChngOrderDo.setUpdateOperId(operId);
            uocChngOrderDo.setUpdateOperName(reqBo.getName());
            uocChngOrderDo.setRejectReason(reqBo.getRejectRemark());
            return uocChngOrderDo;
        }).collect(Collectors.toList());
    }

    /**
     * 获取对应状态
     */
    private String getState(UocChngOrderConfirmOrRefuseForInspReqBo reqBo) {
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            return UocStateConstants.ChngOrder.NUM.CHNG_CHNG_JJ;
        }
        return UocStateConstants.ChngOrder.NUM.CHNG_CHNG_QR;
    }


    /**
     * 查询变更对象明细信息
     */
    private List<UocChngOrderItemObj> getListChngOrderItemObj(UocChngOrderConfirmOrRefuseForInspReqBo reqBo) {
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
        UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
        uocChngOrderItemObjQryBo.setChngOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList()));
        uocChngOrderItemObjQryBo.setOrderIdList(orderIdList);
        List<UocChngOrderItemObj> uocChngOrderItemObjList = iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
        if (CollectionUtils.isEmpty(uocChngOrderItemObjList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "查询变更明细对象为空");
        }
        return uocChngOrderItemObjList;
    }

    private void validateArg(UocChngOrderConfirmOrRefuseForInspReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (!OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) && !OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参操作只支持确认或拒绝为空");
        }
        if (CollectionUtils.isEmpty(reqBo.getChngOrderList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息列表不能为空");
        }
        reqBo.getChngOrderList().forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            if (null == uocChngOrderConfirmOrRefuseReqItemBo.getOrderId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息的订单ID不能为空");
            }
            if (null == uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息的变更单ID不能为空");
            }
        });
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID不能为空");
        }
        List<UocChngOrderConfirmOrRefuseReqItemBo> chngOrderList = reqBo.getChngOrderList();
        chngOrderList.forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {

            if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList())) {
                uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性对象ID不能为空");
                    }
                    if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性编码不能为空");
                    }
                });
            }
            if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList())) {
                uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
                    if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型不能为空");
                    }
                    if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型仅支持新增和修改");
                    }
                    if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                        if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，对象ID不能为空");
                        }
                        if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，属性编码不能为空");
                        }
                    }
                    if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                        if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，对象ID不能为空");
                        }
                        if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性编码不能为空");
                        }
                        if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldValue())) {
                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性值不能为空");
                        }
                    }
                });
            }
        });
    }

    /**
     * 扩展属性处理
     */
    private void dealMap(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, Date now) {
        List<UocChngOrderConfirmOrRefuseReqItemBo> chngOrderList = reqBo.getChngOrderList();
        chngOrderList.forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList())) {
                UocChngOrderDo delChngOrderDo = new UocChngOrderDo();
                List<UocChngOrderMap> extParallelBoList = new ArrayList<>();
                uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                    UocChngOrderMap uocChngOrderMap = new UocChngOrderMap();
                    uocChngOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
                    uocChngOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
                    uocChngOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
                    uocChngOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                    uocChngOrderMap.setUpdateTime(now);
                    extParallelBoList.add(uocChngOrderMap);
                });
                delChngOrderDo.setUocChngOrderMapList(extParallelBoList);
                iUocChngOrderModel.updateInvalid(delChngOrderDo);
            }
            if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList())) {
                UocChngOrderDo add = new UocChngOrderDo();
                UocChngOrderDo modify = new UocChngOrderDo();
                List<UocChngOrderMap> addList = new ArrayList<>();
                List<UocChngOrderMap> modifyList = new ArrayList<>();
                uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
                    if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
                        UocChngOrderMap addShipOrderMap = new UocChngOrderMap();
                        addShipOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
                        addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                        addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
                        addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                        addShipOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
                        addShipOrderMap.setId(IdUtil.nextId());
                        addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                        addShipOrderMap.setCreateTime(now);
                        addList.add(addShipOrderMap);
                    } else {
                        UocChngOrderMap updateShipOrderMap = new UocChngOrderMap();
                        updateShipOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
                        updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                        updateShipOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
                        updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                        updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                        updateShipOrderMap.setUpdateTime(now);
                        modifyList.add(updateShipOrderMap);
                    }
                });
                if (!CollectionUtils.isEmpty(addList)) {
                    add.setUocChngOrderMapList(addList);
                    iUocChngOrderModel.addChngOrderMap(add);
                }
                if (!CollectionUtils.isEmpty(modifyList)) {
                    modify.setUocChngOrderMapList(modifyList);
                    iUocChngOrderModel.updateBatchValue(modify);
                }
            }
            UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
            uocChngOrderDo.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
            uocChngOrderDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            uocChngOrderDo.setChngOrderState(OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) ? UocStateConstants.ChngOrder.NUM.CHNG_CHNG_QR : UocStateConstants.ChngOrder.NUM.CHNG_CHNG_JJ);
            uocChngOrderDo.setUpdateTime(now);
            uocChngOrderDo.setUpdateOperId(reqBo.getUserId().toString());
            iUocChngOrderModel.updateChngOrderMain(uocChngOrderDo);
        });
    }

    private void buildSyncRsp(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, UocChngOrderConfirmOrRefuseForInspRspBo rspBo, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> saleOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList());
        List<Long> inspOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getInspOrderItemId).collect(Collectors.toList());
        List<Long> shipOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getShipOrderItemId).collect(Collectors.toList());

        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIds);
        List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        rspBo.setSaleOrderItemList(UocRu.jsl(saleOrderItemList, UocSaleOrderItemBO.class));
        rspBo.getSaleOrderIdList().addAll(saleOrderItemList.stream().map(x -> x.getSaleOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));

        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderItemIdList(shipOrderItemIds);
        List<UocShipOrderItem> shipOrderItemList = iUocShipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);
        rspBo.getShipOrderIdList().addAll(shipOrderItemList.stream().map(x -> x.getShipOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));

        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setInspOrderItemIdList(inspOrderItemIds);
        UocInspOrderDo uocInspOrderDo = iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);

        Map<Long, List<UocInspOrderItem>> inspOrderMap = uocInspOrderDo.getUocInspOrderItemList().stream().collect(Collectors.groupingBy(UocInspOrderItem::getInspOrderId));
        rspBo.setInspOrderIdLists(uocInspOrderDo.getUocInspOrderItemList().stream().map(x -> x.getInspOrderId() + "").distinct().collect(Collectors.toList()));
        rspBo.getInspOrderIdList().addAll(uocInspOrderDo.getUocInspOrderItemList().stream().map(x -> x.getInspOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));

        reqBo.getChngOrderList().forEach(x -> {
            rspBo.getChngOrderIdList().add(x.getChngOrderId() + "-" + x.getOrderId());
        });

        List<UocInspOrderDo> inspOrderDoList = new ArrayList<>();
        List<Long> inspOrderIdList = uocInspOrderDo.getUocInspOrderItemList().stream().map(UocInspOrderItem::getInspOrderId).distinct().collect(Collectors.toList());

        for (Long inspOrderId : inspOrderIdList) {
            UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
            uocInspOrderQryBo.setInspOrderId(Long.valueOf(inspOrderId));
            uocInspOrderDo = iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);

            uocInspOrderDo.setUocInspOrderItemList(inspOrderMap.get(inspOrderId));
            inspOrderDoList.add(uocInspOrderDo);
        }

        List<Long> saleOrderIdList = saleOrderItemList.stream().map(UocSaleOrderItem::getSaleOrderId).distinct().collect(Collectors.toList());

        List<UocSaleOrderDo> saleOrderDoList = new ArrayList<>();
        for (Long saleOrderId : saleOrderIdList) {
            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            uocSaleOrderQryBo.setSaleOrderId(Long.valueOf(saleOrderId));
            UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);

            saleOrderDoList.add(uocSaleOrderDo);
        }
        rspBo.setInspOrderBoList(UocRu.jsl(inspOrderDoList, UocInspOrderBo.class));
        rspBo.setSaleOrderBOList(UocRu.jsl(saleOrderDoList, UocSaleOrderBO.class));
    }

    private List<String> confirmStat(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {

        // 要更新es的验收单集合
        List<String> inspOrderIds = new ArrayList<>();
        List<UocChngOrderObj> inspOrderList = new ArrayList<>();

        Map<String, List<UocChngOrderItemObj>> chngOrderItemMaps = uocChngOrderItemObjList.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getOtherChngValue));
        List<UocChngOrderItemObj> uocChngOrderItemObjsJS = chngOrderItemMaps.get(UocDicConstant.STATE_CHNG.JUSHOU);
        List<UocChngOrderItemObj> uocChngOrderItemObjsTT = chngOrderItemMaps.get(UocDicConstant.STATE_CHNG.TUOTOU);
        // 变拒收
        if (CollectionUtil.isNotEmpty(uocChngOrderItemObjsJS)) {
            UocShipOrderDo uocShipOrderDo = convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjsJS);
            UocSaleOrderDo uocSaleOrderDo = convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjsJS);
            // 增加sale_order_item中拒收的数量，变更中数量变为0
            iUocSaleOrderModel.modifyItemRefuseCountConfirm(uocSaleOrderDo);
            iUocShipOrderModel.modifyItemRefuseCountConfirm(uocShipOrderDo);
        }
        // 变妥投
        if (CollectionUtil.isNotEmpty(uocChngOrderItemObjsTT)) {
            UocShipOrderDo uocShipOrderDo = convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjsTT);
            UocSaleOrderDo uocSaleOrderDo = convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjsTT);
            // 增加到货的数量
            iUocSaleOrderModel.modifyItemArriveCountConfirm(uocSaleOrderDo);
            iUocShipOrderModel.modifyItemArriveCountConfirm(uocShipOrderDo);

            // 拒收变妥投，且销售单已经验收的特殊形况处理
            inspOrderList = dealSpecial(reqBo, uocChngOrderItemObjsTT);
            if (CollectionUtil.isNotEmpty(inspOrderList)) {
                inspOrderIds = inspOrderList.stream().map(e -> e.getInspOrderId() + "-" + e.getOrderId()).collect(Collectors.toList());
            }

        }

        //修改发货单状态
        List<Long> shipItemIdList = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getShipOrderItemId).distinct().collect(Collectors.toList());
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderItemIdList(shipItemIdList);
        List<UocShipOrderItem> shipOrderItemList = iUocShipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);
        // 去掉特殊处理的发货单，特殊处理的发货单不用再修改状态
        if (CollectionUtil.isNotEmpty(shipOrderItemList) && CollectionUtil.isNotEmpty(inspOrderList)) {
            List<Long> removeShipOrderIds = inspOrderList.stream().map(UocChngOrderObj::getShipOrderId).collect(Collectors.toList());
            shipOrderItemList.removeIf(e -> removeShipOrderIds.contains(e.getShipOrderId()));
        }

        // 改变发货单状态
        if (CollectionUtil.isNotEmpty(shipOrderItemList)) {
            log.info("状态异常变更确认需要改变发货单状态的列表，shipOrderItemList：" + JSON.toJSONString(shipOrderItemList));
            Map<Long, Long> shipItemToShipIdMaps = shipOrderItemList.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, UocShipOrderItem::getShipOrderId));
            uocChngOrderItemObjList.forEach(uocChngOrderItemObj -> {
                UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
                Long shipOrderItemId = uocChngOrderItemObj.getShipOrderItemId();
                Long shipOrderId = shipItemToShipIdMaps.get(shipOrderItemId);
                uocShipOrderDo.setOrderId(uocChngOrderItemObj.getOrderId());
                uocShipOrderDo.setShipOrderId(shipOrderId);
                iUocShipOrderModel.modifyStatChngShipStatus(uocShipOrderDo);
            });
        }

        return inspOrderIds;
    }

    private void getShipTaskInsts(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, UocChngOrderConfirmOrRefuseForInspRspBo rsp) {
        List<UocChngOrderConfirmOrRefuseShipTaskInstBo> shipTaskInstBoList = new ArrayList<>();
        List<Long> chngOrderIds = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList());
        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setChngOrderIdList(chngOrderIds);
        List<UocChngOrderObj> listChngOrderObjWithOutItem = iUocChngOrderModel.getListChngOrderObjWithOutItem(uocChngOrderObjQryBo);

        listChngOrderObjWithOutItem.forEach(x -> {
            UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
            uocOrderTaskInst.setOrderId(x.getOrderId());
            uocOrderTaskInst.setObjId(x.getShipOrderId());
            uocOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
//			uocOrderTaskInst.setFinishTag(0);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
            if (CollectionUtil.isEmpty(uocOrderTaskInsts)) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询发货单任务信息为空");
            }
            UocOrderTaskInst uocOrderTaskInst1 = uocOrderTaskInsts.get(0);
            String taskInstId = uocOrderTaskInst1.getTaskInstId();
            String procState = uocOrderTaskInst1.getProcState();
            UocChngOrderConfirmOrRefuseShipTaskInstBo uocChngOrderConfirmOrRefuseShipTaskInstBo = new UocChngOrderConfirmOrRefuseShipTaskInstBo();
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setShipOrderId(x.getShipOrderId());
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setTaskId(taskInstId);
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setStepId(procState);
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setChngOrderId(x.getChngOrderId());
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setOrderId(x.getOrderId());
            shipTaskInstBoList.add(uocChngOrderConfirmOrRefuseShipTaskInstBo);
        });
        rsp.setShipTaskInstList(shipTaskInstBoList);
    }

    private void getSaleOrderInfo(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, UocChngOrderConfirmOrRefuseForInspRspBo rsp) {
        List<UocChngOrderConfirmOrRefuseSaleTaskInstBo> saleOrderTaskInstBoList = new ArrayList<>();
        List<Long> chngOrderIds = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList());
        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setChngOrderIdList(chngOrderIds);
        UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
        uocChngOrderItemObjQryBo.setChngOrderIdList(chngOrderIds);
        List<UocChngOrderItemObj> listChngOrderItemObj = iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
        Map<Long, List<UocChngOrderItemObj>> chngOrderItemMaps = listChngOrderItemObj.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getChngOrderId));

        List<UocChngOrderObj> listChngOrderObjWithOutItem = iUocChngOrderModel.getListChngOrderObjWithOutItem(uocChngOrderObjQryBo);
        if (CollectionUtil.isEmpty(listChngOrderObjWithOutItem)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "查询变更对象为空");
        }
        for (UocChngOrderObj uocChngOrderObj : listChngOrderObjWithOutItem) {
            Long saleOrderId = uocChngOrderObj.getSaleOrderId();
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setSaleOrderId(saleOrderId);
            uocSaleOrderDo.setOrderId(uocChngOrderObj.getOrderId());
            UocSaleOrderDo saleOrderMain = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
            if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(saleOrderMain.getOrderSource()) && UocConstant.BUSI_TYPE.STATE.equals(uocChngOrderObj.getChngType())) {

                Boolean flag = null;
                UocOrderTaskInst uocSaleOrderTaskInst = new UocOrderTaskInst();
                uocSaleOrderTaskInst.setOrderId(uocChngOrderObj.getOrderId());
                uocSaleOrderTaskInst.setObjId(saleOrderId);
                uocSaleOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                uocSaleOrderTaskInst.setFinishTag(0);
                uocSaleOrderTaskInst.setOrderBy("create_time desc");
                List<UocOrderTaskInst> uocSaleOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(uocSaleOrderTaskInst);
                if (CollectionUtil.isEmpty(uocSaleOrderTaskInsts)) {
                    return;
                }
                UocOrderTaskInst uocSaleOrderTaskInst1 = uocSaleOrderTaskInsts.get(0);
                List<UocChngOrderItemObj> uocChngOrderItemObjs = chngOrderItemMaps.get(uocChngOrderObj.getChngOrderId());
                if (CollectionUtil.isEmpty(uocChngOrderItemObjs)) {
                    break;
                }
                // 妥投到拒收
                if (UocDicConstant.STATE_CHNG.JUSHOU.equals(uocChngOrderItemObjs.get(0).getOtherChngValue())) {
                    UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
                    uocShipOrderQryBo.setSaleOrderId(saleOrderId);
                    uocShipOrderQryBo.setOrderId(uocChngOrderObj.getOrderId());
                    List<UocShipOrderDo> listShipOrder = iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
                    if (CollectionUtil.isEmpty(listShipOrder)) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "通过销售单查询发货单列表为空");
                    }

                    for (UocShipOrderDo uocShipOrderDo : listShipOrder) {
                        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
                        uocOrderTaskInst.setOrderId(uocChngOrderObj.getOrderId());
                        uocOrderTaskInst.setObjId(uocShipOrderDo.getShipOrderId());
                        uocOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
                        uocOrderTaskInst.setFinishTag(0);
                        List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
                        if (CollectionUtil.isEmpty(uocOrderTaskInsts)) {
                            return;
                        }
                        UocOrderTaskInst uocOrderTaskInst1 = uocOrderTaskInsts.get(0);
                        String procState = uocOrderTaskInst1.getProcState();
                        if (UocStateConstants.SaleOrder.XS_YS_YS.equals(procState)) {
                            flag = true;
                        } else {
                            flag = false;
                            break;
                        }
                    }
                    flag = Optional.ofNullable(flag).orElse(Boolean.FALSE);
                    if (flag) {
                        String taskId = uocSaleOrderTaskInst1.getTaskInstId();
                        UocChngOrderConfirmOrRefuseSaleTaskInstBo saleTaskinfo = new UocChngOrderConfirmOrRefuseSaleTaskInstBo();
                        saleTaskinfo.setTaskId(taskId);
                        saleTaskinfo.setStepId(uocSaleOrderTaskInst1.getProcState());
                        saleTaskinfo.setSaleOrderId(saleOrderId);
                        saleTaskinfo.setOrderId(uocChngOrderObj.getOrderId());
                        saleOrderTaskInstBoList.add(saleTaskinfo);
                    }
                }
                // 拒收到妥投
                if (UocDicConstant.STATE_CHNG.TUOTOU.equals(uocChngOrderItemObjs.get(0).getOtherChngValue())) {
                    String procState = uocSaleOrderTaskInst1.getProcState();
                    if (UocStateConstants.SaleTachCode.XS_DH_JS.equals(procState)) {
                        String taskId = uocSaleOrderTaskInst1.getTaskInstId();
                        UocChngOrderConfirmOrRefuseSaleTaskInstBo saleTaskinfo = new UocChngOrderConfirmOrRefuseSaleTaskInstBo();
                        saleTaskinfo.setTaskId(taskId);
                        saleTaskinfo.setStepId(uocSaleOrderTaskInst1.getProcState());
                        saleTaskinfo.setSaleOrderId(saleOrderId);
                        saleTaskinfo.setOrderId(uocChngOrderObj.getOrderId());
                        saleOrderTaskInstBoList.add(saleTaskinfo);
                    }
                }
            }
        }
        rsp.setSaleOrderTaskInstList(saleOrderTaskInstBoList);
    }

    private void refuseState(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        iUocShipOrderModel.modifyItemChngCountRefuse(convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
        iUocSaleOrderModel.modifyBatchItemChngCountRefuse(convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
    }

    private UocShipOrderDo convertShipOrderDo(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setShipOrderItemIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getShipOrderItemId).collect(Collectors.toList()));
        uocShipOrderDo.setOrderIdList(orderIdList);
        uocShipOrderDo.setUpdateTime(now);
        uocShipOrderDo.setUpdateOperId(operId);
        return uocShipOrderDo;
    }


    /**
     * 判断当前销售单是否已验收，是则做以下逻辑:
     * 1.修改对应验收单明细，修改验收单上的数据（金额），同时注意外面要同步验收单es
     * 2.修改发货单状态为已验收，修改发货单明细的验收数量
     * 3.修改销售单明细上的验收数量
     */
    private List<UocChngOrderObj> dealSpecial(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, List<UocChngOrderItemObj> uocChngOrderItemObjsTT) {

        if (ObjectUtil.isEmpty(uocChngOrderItemObjsTT)) {
            return new ArrayList<>();
        }
        // 要更新es的验收单集合
        List<UocChngOrderObj> inspOrderList = new ArrayList<>();

        // 查询变更单对象列表
        List<Long> chngOrderIdList = uocChngOrderItemObjsTT.stream().map(UocChngOrderItemObj::getChngOrderId).collect(Collectors.toList());
        if (ObjectUtil.isEmpty(chngOrderIdList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "查询变更Id为空！！！");
        }
        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setChngOrderIdList(chngOrderIdList);
        List<UocChngOrderObj> chngOrderObjList = this.iUocChngOrderModel.getListChngOrderObjWithOutItem(uocChngOrderObjQryBo);
        if (ObjectUtil.isEmpty(chngOrderObjList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "查询变更单对象为空！！！");
        }
        List<Long> saleOrderIdList = chngOrderObjList.stream().map(UocChngOrderObj::getSaleOrderId).collect(Collectors.toList());
        // 查询销售单列表
        UocSaleOrderDo saleOrderDo = new UocSaleOrderDo();
        saleOrderDo.setSaleOrderIdList(saleOrderIdList);
        List<UocSaleOrderDo> saleOrderDoList = iUocSaleOrderModel.qrySaleOrderList(saleOrderDo);
        if (ObjectUtil.isEmpty(saleOrderDoList)) {
            return new ArrayList<>();
        }

        // 过滤出已验收的销售单
        List<UocSaleOrderDo> yysSaleOrderList = saleOrderDoList.stream().filter(e -> UocStateConstants.SaleOrder.XS_YS_YS.equals(e.getSaleOrderState())).collect(Collectors.toList());
        if (ObjectUtil.isEmpty(yysSaleOrderList)) {
            return new ArrayList<>();
        }

        // 存在销售单为已验收，继续走
        List<Long> yysSaleOrderIds = yysSaleOrderList.stream().map(UocSaleOrderDo::getSaleOrderId).collect(Collectors.toList());
        Map<Long, List<UocChngOrderObj>> chngOrderObjMap = chngOrderObjList.stream().collect(Collectors.groupingBy(UocChngOrderObj::getSaleOrderId));
        Map<Long, List<UocChngOrderItemObj>> uocChngOrderItemObjsTTMap = uocChngOrderItemObjsTT.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getChngOrderId));


        // 验收单明细
        List<Long> shipOrderItemIdList = uocChngOrderItemObjsTT.stream().map(UocChngOrderItemObj::getShipOrderItemId).collect(Collectors.toList());
        if (ObjectUtil.isEmpty(shipOrderItemIdList)) {
            log.error("变更单明细的发货单明细id为空");
            return new ArrayList<>();
        }
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderItemIdList(shipOrderItemIdList);
        List<UocShipOrderItem> shipOrderItemList = iUocShipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);
        Map<Long, UocShipOrderItem> shipOrderItemMap = shipOrderItemList.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, Function.identity()));
        // 销售单明细
        List<Long> saleOrderItemIdList = uocChngOrderItemObjsTT.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList());
        if (ObjectUtil.isEmpty(saleOrderItemIdList)) {
            log.error("变更单明细的销售单明细id为空");
            return new ArrayList<>();
        }
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIdList);
        List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        Map<Long, UocSaleOrderItem> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, Function.identity()));
        // 验收单明细，用发货单明细来查
        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setShipOrderItemIdList(shipOrderItemIdList);
        UocInspOrderDo inspOrderItemList = iUocInspOrderModel.getInspOrderItemList(uocInspOrderItemQryBo);
        Map<Long, UocInspOrderItem> inspOrderItemMap = inspOrderItemList.getUocInspOrderItemList().stream().collect(Collectors.toMap(UocInspOrderItem::getShipOrderItemId, Function.identity()));


        // 要创建的验收明细集合
        List<UocInspOrderItem> uocInspOrderItemList = new ArrayList<>();
        // 要更新的发货单集合
        List<Long> changeShipOrderIdList = new ArrayList<>();
        // 要更新的销售单明细集合
        List<Long> changeSaleOrderItemIdList = new ArrayList<>();


        // 以销售单维度循环操作，处理验收单明细修改数据，修改验收单主体的总金额
        for (Long yysSaleOrderId : yysSaleOrderIds) {
            if (chngOrderObjMap.containsKey(yysSaleOrderId)) {

                // 当前销售单下的变更单
                List<UocChngOrderObj> uocChngOrderObjs = chngOrderObjMap.get(yysSaleOrderId);
                // 当前销售单下的变更单明细
                for (UocChngOrderObj chngObj : uocChngOrderObjs) {
                    List<UocChngOrderItemObj> uocChngOrderItemObjs = uocChngOrderItemObjsTTMap.get(chngObj.getChngOrderId());
                    if (!ObjectUtil.isEmpty(uocChngOrderItemObjs)) {

                        changeShipOrderIdList.add(chngObj.getShipOrderId());

                        for (UocChngOrderItemObj chngItem : uocChngOrderItemObjs) {

                            changeSaleOrderItemIdList.add(chngItem.getSaleOrderItemId());

                            UocInspOrderItem updateInspOrderItem = new UocInspOrderItem();
                            //设置发货单明细id
                            updateInspOrderItem.setShipOrderItemId(chngItem.getShipOrderItemId());
                            //设置销售单明细id
                            updateInspOrderItem.setSaleOrderItemId(chngItem.getSaleOrderItemId());
                            //设置验收数量
                            updateInspOrderItem.setInspCount(shipOrderItemMap.get(chngItem.getShipOrderItemId()).getSendCount());
                            //设置剩余验收数量
                            updateInspOrderItem.setRemainInspCount(new BigDecimal(0));
                            //设置初始验收数量
//                            updateInspOrderItem.setInitInspCount(shipOrderItemMap.get(chngItem.getShipOrderItemId()).getSendCount());
                            //设置更新时间
                            updateInspOrderItem.setUpdateTime(new Date());
                            //设置更新人id
                            updateInspOrderItem.setUpdateOperId(String.valueOf(reqBo.getUserId()));
                            uocInspOrderItemList.add(updateInspOrderItem);

                            // 修改验收单上的总金额
                            BigDecimal totalSaleChngFee = saleOrderItemMap.get(chngItem.getSaleOrderItemId()).getSalePrice().multiply(updateInspOrderItem.getInspCount());
                            BigDecimal totalPurchaseChngFee = saleOrderItemMap.get(chngItem.getSaleOrderItemId()).getPurchasePrice().multiply(updateInspOrderItem.getInspCount());
                            UocInspOrderDo orderDo = new UocInspOrderDo();
                            orderDo.setInspOrderId(inspOrderItemMap.get(chngItem.getShipOrderItemId()).getInspOrderId());
                            orderDo.setTotalSaleFee(totalSaleChngFee.multiply(new BigDecimal(-1)));
                            orderDo.setTotalPurchaseFee(totalPurchaseChngFee.multiply(new BigDecimal(-1)));
                            orderDo.setUpdateOperId(reqBo.getUserId().toString());
                            orderDo.setUpdateTime(new Date());
                            iUocInspOrderModel.modifyInsporderChngTotalFeeConfirm(orderDo);

                            // 返回es的数据
                            UocChngOrderObj returnBO = new UocChngOrderObj();
                            returnBO.setShipOrderId(chngObj.getShipOrderId());
                            returnBO.setInspOrderId(inspOrderItemMap.get(chngItem.getShipOrderItemId()).getInspOrderId());
                            returnBO.setOrderId(chngObj.getOrderId());
                            inspOrderList.add(returnBO);
                        }
                    }
                }

            }
        }

        // 以发货单明细id修改对应验收单明细
        if (!CollectionUtils.isEmpty(uocInspOrderItemList)) {
            UocInspOrderDo createInspOrderDo = new UocInspOrderDo();
            createInspOrderDo.setUocInspOrderItemList(uocInspOrderItemList);
            iUocInspOrderModel.updateInspOrderItem(createInspOrderDo);
        }


        // 2.修改发货单状态为已验收，修改发货单明细的验收数量
        if (!CollectionUtils.isEmpty(changeShipOrderIdList)) {
            UocShipOrderDo uocShipOrderDo1 = new UocShipOrderDo();
            uocShipOrderDo1.setShipOrderIdList(changeShipOrderIdList);
            uocShipOrderDo1.setUpdateOperId(reqBo.getUserId().toString());
            uocShipOrderDo1.setUpdateTime(new Date(System.currentTimeMillis()));
            iUocShipOrderModel.batchModifyShipOrderItemInspCountEqualArrivalCount(uocShipOrderDo1);

            UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
            uocShipOrderDo.setShipOrderIdList(changeShipOrderIdList);
            uocShipOrderDo.setUpdateOperId(reqBo.getUserId().toString());
            uocShipOrderDo.setUpdateTime(new Date(System.currentTimeMillis()));
            uocShipOrderDo.setShipOrderState(UocStateConstants.ShipOrder.FH_FH_YS);
            iUocShipOrderModel.modifyShipOrderMain(uocShipOrderDo);
        }

        // 3.修改销售单明细上的验收数量
        if (!CollectionUtils.isEmpty(changeSaleOrderItemIdList)) {
            UocSaleOrderDo uocSaleOrderDo1 = new UocSaleOrderDo();
            uocSaleOrderDo1.setSaleOrderItemsIdList(changeSaleOrderItemIdList);
            uocSaleOrderDo1.setUpdateTime(new Date(System.currentTimeMillis()));
            uocSaleOrderDo1.setUpdateOperId(reqBo.getUserId().toString());
            iUocSaleOrderModel.batchModifySaleOrderItemInspCountEqualArrivalCount(uocSaleOrderDo1);
        }

        return inspOrderList;

    }


}


