package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderCheckAccountQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderCheckAccount;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.domainservice.UocOrderSyncCheckStatusService;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderSyncCheckStatusReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderSyncCheckStatusRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题：UocOrderSyncCheckStatusServiceImpl
 * 说明：订单对账状态更新
 * 时间：2022/4/1 19:38
 *
 * @author 文乐
 */
@Component
@Slf4j
public class UocOrderSyncCheckStatusTransaction{

    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private UocEsSyncManager uocEsSyncManager;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocInspOrderModel uocInspOrderModel;
    
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocOrderSyncCheckStatusRspBo dealSyncCheckStatus(UocOrderSyncCheckStatusReqBo reqBo) {
        validateArg(reqBo);
        UocOrderSyncCheckStatusRspBo rspBo = UocRu.success(UocOrderSyncCheckStatusRspBo.class);
        // 查询是否存在
        UocOrderCheckAccountQryBo uocOrderCheckAccountQryBo = new UocOrderCheckAccountQryBo();
//        uocOrderCheckAccountQryBo.setOrderId(reqBo.getOrderId());
        uocOrderCheckAccountQryBo.setObjId(reqBo.getObjId());
        uocOrderCheckAccountQryBo.setObjType(reqBo.getObjType());
        UocOrderCheckAccount uocOrderCheckAccount = iUocOrderModel.qryCheckInfo(uocOrderCheckAccountQryBo);
        
        if ( null != uocOrderCheckAccount ) {
            // 更新
            UocOrderCheckAccount update = new UocOrderCheckAccount();
            update.setId(uocOrderCheckAccount.getId());
            update.setCheckState(reqBo.getCheckState());
            iUocOrderModel.updateCheckInfo(update);
//
//            update.setOrderId(uocOrderCheckAccountQryBo.getOrderId());
//            update.setObjId(uocOrderCheckAccountQryBo.getObjId());
//            syncEs(update);
        } else {
            // 创建
            UocOrderCheckAccount insert = UocRu.js(reqBo, UocOrderCheckAccount.class);
            insert.setId(IdUtil.nextId());
            iUocOrderModel.createCheckInfo(insert);
//
//            syncEs(insert);
        }
        
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setInspOrderId(reqBo.getObjId());
        UocInspOrderDo uocInspOrderDo = uocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
    
        rspBo.setOrderId(uocInspOrderDo.getOrderId());
        return rspBo;
    }

    private void validateArg(UocOrderSyncCheckStatusReqBo reqBo) {
        if (null == reqBo.getCheckState()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "checkState不能为空");
        }
//        if (null == reqBo.getOrderId()) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "orderId不能为空");
//        }
        if (null == reqBo.getObjId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "objId不能为空");
        }
        if (null == reqBo.getObjType()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "objType不能为空");
        }
    }

    private Map<String, Map<String, String>> getDic() {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocDicConstant.CHECK_STATE.P_CODE);
        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    private void syncEs(UocOrderCheckAccount uocOrderCheckAccount) {
        UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        uocEsSyncManagerSaveDataReqBo.setObjId(uocOrderCheckAccount.getObjId());
        JSONObject jsonObj = new JSONObject();
        Map<String, Map<String, String>> dic = getDic();
        Map<String, String> checkStateMap = dic.get(UocDicConstant.CHECK_STATE.P_CODE);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.CHECK_STATE, uocOrderCheckAccount.getCheckState());
        jsonObj.put(UocConstant.ES_MAIN_OTHER.CHECK_STATE_STR, checkStateMap.get(Convert.toStr(uocOrderCheckAccount.getCheckState())));
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getInspOrderIndex());
        uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
    }
}
