package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocEventConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题:EventConsumerCreateOrder
 * 说明:订单创建同步
 * 时间:2022/3/11 10:05
 * 作者:田桂银
 */
@Component
@Slf4j

public class EventConsumerCreateOrder implements EventConsumer {
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerCreateOrder->{}", JSON.toJSONString(map));

        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Long orderId = Long.valueOf((String) map.get("orderId"));
        if (ObjectUtil.isNotEmpty(orderId)) {
            Object saleOrderListObj = map.get("saleOrderList");
            if (ObjectUtil.isNotEmpty(saleOrderListObj)) {
                // JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(map));
                // JSONArray saleOrderList = jsonObject.getJSONArray("saleOrderList");
                JSONArray saleOrderList = JSON.parseArray(JSON.toJSONString(saleOrderListObj));
                //销售单，执行单列表
                List<IUocEsSyncQryReqBo> saleList = new ArrayList<>();
                List<IUocEsSyncQryReqBo> implList = new ArrayList<>();

                if(ObjectUtil.isNotEmpty(saleOrderList)){
                    for (int i = 0; i < saleOrderList.size(); i++) {
                        JSONObject arrayJson = saleOrderList.getJSONObject(i);
                        Long saleOrderId = arrayJson.getLong("saleOrderId");
//                        Long implOrderId = arrayJson.getLong("implOrderId");
                        if (saleOrderId != null) {
                            IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
                            syncQryReqBo.setOrderId(orderId);
                            syncQryReqBo.setObjId(saleOrderId);
                            saleList.add(syncQryReqBo);
                        }
//                        if (implOrderId != null) {
//                            IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
//                            syncQryReqBo.setOrderId(orderId);
//                            syncQryReqBo.setObjId(implOrderId);
//                            implList.add(syncQryReqBo);
//                        }
                    }
                }

                //如果list不为空，则返给应用层
                if (ObjectUtil.isNotEmpty(saleList)) {
                    IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
                    eventReqBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
                    eventReqBo.setDataList(saleList);
                    retList.add(eventReqBo);
                }

//                if (ObjectUtil.isNotEmpty(implList)) {
//                    IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
//                    eventReqBo.setIndexName(uocIndexConfig.getImplOrderIndex());
//                    eventReqBo.setDataList(implList);
//                    retList.add(eventReqBo);
//                }
            }
        }
        return retList;
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOC_SALE_ORDER_SYNC;
    }
}


