package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocEventConstant;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题：类名称:EventConsumerSyncAfterOrder
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/18 16:20
 * 作者 @author 尹栋梁
 */
@Slf4j
@Component
public class EventConsumerSyncAfterOrderHR implements EventConsumer {
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerSyncAfterOrder->{}", JSON.toJSONString(map));

        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Object afOrderIdListObj = map.get("afOrderIdList");
        Object saleOrderIdListObj = map.get("saleOrderIdList");
        Object shipOrderIdListObj = map.get("shipOrderIdList");

        if (ObjectUtil.isNotEmpty(saleOrderIdListObj)) {
            List<String> saleOrderIdList = UocRu.jsl(saleOrderIdListObj, String.class);
            List<IUocEsSyncQryReqBo> saleList = new ArrayList<>();
            saleOrderIdList.forEach(x -> {
                IUocEsSyncQryReqBo sale = new IUocEsSyncQryReqBo();
                String[] xsplit = x.split("-");
                sale.setOrderId(Long.parseLong(xsplit[1]));
                sale.setObjId(Long.parseLong(xsplit[0]));
                saleList.add(sale);
            });
            IUocEsSyncQryEventReqBo shipEvent = new IUocEsSyncQryEventReqBo();
            shipEvent.setIndexName(uocIndexConfig.getSaleOrderIndex());
            shipEvent.setDataList(saleList);
            retList.add(shipEvent);
        }
        if (ObjectUtil.isNotEmpty(afOrderIdListObj)) {
            List<String> afOrderIdList = UocRu.jsl(afOrderIdListObj, String.class);
            List<IUocEsSyncQryReqBo> inspList = new ArrayList<>();
            afOrderIdList.forEach(x -> {
                IUocEsSyncQryReqBo insp = new IUocEsSyncQryReqBo();
                String[] xsplit = x.split("-");
                insp.setOrderId(Long.parseLong(xsplit[1]));
                insp.setObjId(Long.parseLong(xsplit[0]));
                inspList.add(insp);
            });
            IUocEsSyncQryEventReqBo shipEvent = new IUocEsSyncQryEventReqBo();
            shipEvent.setIndexName(uocIndexConfig.getAfOrderIndex());
            shipEvent.setDataList(inspList);
            retList.add(shipEvent);
        }
        if (ObjectUtil.isNotEmpty(shipOrderIdListObj)) {
            List<String> shipOrderIdList = UocRu.jsl(shipOrderIdListObj, String.class);
            List<IUocEsSyncQryReqBo> shipList = new ArrayList<>();
            shipOrderIdList.forEach(x -> {
                IUocEsSyncQryReqBo ship = new IUocEsSyncQryReqBo();
                String[] xsplit = x.split("-");
                ship.setOrderId(Long.parseLong(xsplit[1]));
                ship.setObjId(Long.parseLong(xsplit[0]));
                shipList.add(ship);
            });
            IUocEsSyncQryEventReqBo shipEvent = new IUocEsSyncQryEventReqBo();
            shipEvent.setIndexName(uocIndexConfig.getShipOrderIndex());
            shipEvent.setDataList(shipList);
            retList.add(shipEvent);
        }

        return retList;
    }
    @Override
    public String getEvent() {
        return UocEventConstant.UOCE_ORDER_AFTER_SYNC_HR;
    }
}
