package com.tydic.dyc.oc.components.notice.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.notice.UocNoticeContentReplaceBo;
import com.tydic.dyc.oc.components.notice.UocNoticeProcessor;
import com.tydic.dyc.oc.components.notice.UocNoticeReceiverQryConditionBo;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocNoticeConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题:UocNoticeCommonImpl
 * 说明:解析通知参数
 * 时间:2022/4/18 09:49
 * 作者:罗有
 */

@Service
public class UocNoticeCommonImpl implements UocNoticeProcessor {
	/**
	 * 结算模式
	 */
	public static final String MODEL_SETTLE = "modelSettle";
	/**
	 * 贸易角色ID
	 */
	public static final String MY_ROLE_IDS = "myRoleIds";
	/**
	 * 撮合角色ID
	 */
	public static final String CH_ROLE_IDS = "chRoleIds";
	/**
	 * 通用角色ID
	 */
	public static final String COMMON_ROLE_IDS = "commRoleIds";
	/**
	 * 机构ID
	 */
	public static final String ORG_ID = "orgId";
	/**
	 * 用户ID
	 */
	public static final String USER_ID_LIST = "userIdList";
	/**
	 * 机构向下穿透层级 1本级和子级 (默认) 2本级 3本级和下一级
	 */
	public static final String LEVEL_FLAG = "levelFlag";

	@Override
	public String noticeCode() {
		return UocNoticeConstant.COMMON_IMPL;
	}

	@Override
	public UocNoticeReceiverQryConditionBo qryCondition(Map<String, Object> keyMap) {
		Integer modelSettle = Convert.toInt(keyMap.get(MODEL_SETTLE));
		Long orgId = Convert.toLong(keyMap.get(ORG_ID));
		Integer levelFlag = Convert.toInt(keyMap.get(LEVEL_FLAG), 1);
		String users = Convert.toStr(keyMap.get(USER_ID_LIST));
		List<Long> userIdList = null;
		if (StringUtils.isNotBlank(users)) {
			userIdList = JSON.parseArray(users, Long.class);
		}
		List<Long> roleIdList;
		if (UocConstant.ModelSettle.MY.equals(modelSettle)) {
			String myRoleIds = Convert.toStr(keyMap.get(MY_ROLE_IDS));
			if (StringUtils.isBlank(myRoleIds)) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "撮合模式下对应的角色必填");
			}
			roleIdList = JSON.parseArray(myRoleIds, Long.class);
		} else if (UocConstant.ModelSettle.CH.equals(modelSettle)) {
			String chRoleIds = Convert.toStr(keyMap.get(CH_ROLE_IDS));
			if (StringUtils.isBlank(chRoleIds)) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "贸易模式下对应的角色必填");
			}
			roleIdList = JSON.parseArray(chRoleIds, Long.class);
		} else {
			String commRoleIds = Convert.toStr(keyMap.get(COMMON_ROLE_IDS));
			if (StringUtils.isBlank(commRoleIds)) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "通用模式下对应的角色必填");
			}
			roleIdList = JSON.parseArray(commRoleIds, Long.class);
		}
		UocNoticeReceiverQryConditionBo uocNoticeReceiverQryConditionBo = new UocNoticeReceiverQryConditionBo();
		uocNoticeReceiverQryConditionBo.setLevelFlag(levelFlag);
		uocNoticeReceiverQryConditionBo.setOrgId(orgId);
		uocNoticeReceiverQryConditionBo.setRoleIdList(roleIdList);
		uocNoticeReceiverQryConditionBo.setUserIdList(userIdList);
		return uocNoticeReceiverQryConditionBo;
	}

	@Override
	public List<UocNoticeContentReplaceBo> replaceContent(Map<String, Object> dataMap) {
		if (null == dataMap) {
			return new ArrayList<>();
		}
		return dataMap.entrySet().stream().map(kv -> {
			UocNoticeContentReplaceBo uocNoticeContentReplaceBo = new UocNoticeContentReplaceBo();
			uocNoticeContentReplaceBo.setKey(kv.getKey());
			if (null != kv.getValue()) {
				uocNoticeContentReplaceBo.setValue(kv.getValue().toString());
			}
			return uocNoticeContentReplaceBo;
		}).collect(Collectors.toList());
	}

}
