package com.tydic.dyc.oc.model.order.qrybo;

import com.tydic.dyc.base.bo.BaseReqBo;
 //import com.tydic.utils.generatedoc.annotation.DocField;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper=false)
public class UocDMsgPoolQryBo extends BaseReqBo {
    private static final long serialVersionUID = 4538392696412735044L;
    
    //ID")
    private Long id;
    
    private String msgId;
    
    //消息类型 1  代表订单拆分变更  2   代表商品价格变更   5 代表该订单已妥投（买断模式代表外单已妥投或外单已拒收 10 代表订单取消（不区分取消原因）")
    private Integer msgType;
    
    //消息内容")
    private String msgContent;
    
    //状态，1是妥投，2是拒收，3是部分妥投")
    private Integer msgState;
    
    //单据ID")
    private Long objId;
    
    //单据类型 1订单 2.销售单 3 发货单 4.收货单 5.售后服务单 99.其他")
    private Integer objType;
    
    //订单ID")
    private Long orderId;
    
    //供货商ID")
    private String supNo;
    
    //创建时间")
    private Date createTime;
    
    //创建时间 开始")
    private Date createTimeStart;
    
    //创建时间 结束")
    private Date createTimeEnd;
    
    //消息推送时间")
    private Date pushTime;
    
    //消息推送时间 开始")
    private Date pushTimeStart;
    
    //消息推送时间 结束")
    private Date pushTimeEnd;
    
    //修改时间")
    private Date chngTime;
    
    //修改时间 开始")
    private Date chngTimeStart;
    
    //修改时间 结束")
    private Date chngTimeEnd;
    
    //运行状态  0 失败 1成功 2 待处理")
    private Integer runResult;
    
    //失败次数")
    private Integer failureCount;
    
    //FAILURE_REASON")
    private String failureReason;
    
    //外部订单ID")
    private String outOrderId;
    
    //订单类型")
    private Integer orderType;
    
    //不识别类型记录")
    private String resultString;
    
    //发货单号")
    private String packageId;
    
    //售后单号")
    private String serviceId;
    
    //外部父订单")
    private String pOrderId;
    
    //排序")
    private String orderBy;
    //执行状态list
    List<Integer> runResultList;
    //外部消息类型list
    List<Integer> objTypeList;
    
}
