package com.tydic.dyc.oc.repository;

import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.UocInspTempAfProcessTaskDo;
import com.tydic.dyc.oc.model.aforder.qrybo.*;
import com.tydic.dyc.oc.model.aforder.sub.*;

import java.util.List;

/**
 * 标题:UocAfOrderRepository
 * 说明:售后单
 * 时间:2022-02-21 14:31
 * 作者:罗有
 **/
public interface UocAfOrderRepository {
	/**
	 * 查询售后单明细
	 *
	 * @param uocAfOrderItemQryBo
	 * @return  java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem></>
	 */
	List<UocAfOrderItem> getAfOrderItemList(UocAfOrderItemQryBo uocAfOrderItemQryBo);

	/**
	 * 根据售后单ID查询售后单信息
	 *
	 *@param uocAfOrderQryBo
	 * @return @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrder></>
	 */
	UocAfOrder getAfOrderById(UocAfOrderQryBo uocAfOrderQryBo);

	/**
	 * 售后单列表查询
	 *
	 * @param uocAfOrderQryBo
	 * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrder></>
	 */
	List<UocAfOrder> getAfOrderList(UocAfOrderQryBo uocAfOrderQryBo);

	/**
	 * 售后单对象列表查询
	 *
	 * @param uocAfOrderObjQryBo
	 * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj></>
	 */
	List<UocAfOrderObj> getAfOrderObjList(UocAfOrderObjQryBo uocAfOrderObjQryBo);

	/**
	 * 售后单扩展查询
	 *
	 * @param uocAfOrderMapQryBo
	 * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrderMap></>
	 */
	List<UocAfOrderMap> getAfOrderMapList(UocAfOrderMapQryBo uocAfOrderMapQryBo);

	/**
	 * 售后单明细扩展查询
	 *
	 * @param uocAfItemMapQryBo
	 * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfItemMap></>
	 */
	List<UocAfItemMap> getAfOrderItemMapList(UocAfItemMapQryBo uocAfItemMapQryBo);

	/**
	 * 售后运单信息查询
	 *
	 * @param uocAfOrderWaybillQryBo
	 * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrderWaybill></>
	 */
	List<UocAfOrderWaybill> getAfOrderWayBillList(UocAfOrderWaybillQryBo uocAfOrderWaybillQryBo);

	/***
	 * 保存售后单信息
	 * @param afOrderDo
	 * @return
	 */
	UocAfOrderDo saveAfterOder(UocAfOrderDo afOrderDo);

	/**
	 * 修改变更单状态
	 *
	 * @param uocAfOrderDoList
	 */
	void modifyBatchAfOrderRemark(List<UocAfOrderDo> uocAfOrderDoList);

	void modifyAfOrder(UocAfOrderDo uocAfOrderDo);


	/**
	 * 修改售后外部订单号
	 *
	 * @param afOrderDo
	 */
	void modifyAfOrderExtOrderId(UocAfOrderDo afOrderDo);

    void saveAfOrderWayBill(UocAfOrderWaybill uocAfOrderWaybill);

	/**
	 * 修改售后状态
	 *
	 * @param afOrderDo
	 */
	void modifyAfOrderState(UocAfOrderDo afOrderDo);

	List<UocAfOrderDo> getCheckAfOrders(UocAfOrderDo afOrderDo);

	/**
	 * 查询售后单明细
	 */
	UocAfOrderItem getAfOrderItem(UocAfOrderItemQryBo uocAfOrderItemQryBo);

	/**
	 * 新增临时验收售后处理任务
	 */
	void addInspTempAfProcessTask(UocInspTempAfProcessTaskDo uocInspTempAfProcessTaskDo);

	/**
	 * 分页查询临时验收售后处理任务列表
	 */
	UocInspTempAfProcessTaskQryRspPageBo getInspTempAfProcessTaskPageList(UocInspTempAfProcessTaskQryReqPageBo reqPageBo);

	/**
	 * 修改临时验收售后处理任务
	 */
	void updateInspTempAfProcessTask(UocInspTempAfProcessTaskDo uocInspTempAfProcessTaskDo);

}
