package com.tydic.dyc.oc.service.cmporder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.constants.UocCfcConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigDo;
import com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigItemDo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.UocSysDictionaryDo;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocMustCompareOrderConfigQryBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocMustCompareOrderConfigQryServiceReqBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocMustCompareOrderConfigQryServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocMustCompareOrderConfigQryServiceImpl
 * 说明:
 * 时间:2023/1/3 17:12
 * 作者:田桂银
 */
@HTServiceImpl
public class UocMustCompareOrderConfigQryServiceImpl implements UocMustCompareOrderConfigQryService {

    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Override
    public UocMustCompareOrderConfigQryServiceRspBo qryMustCompareOrderConfig(UocMustCompareOrderConfigQryServiceReqBo reqBo) {
        UocMustCompareOrderConfigQryServiceRspBo rspBo = UocRu.success(UocMustCompareOrderConfigQryServiceRspBo.class);
        //查询业务配置
        UocCfcParamConfigDo uocCfcParamConfigDo = iUocCommonModel.qryCfcParamByCode(UocCfcConstants.COMMODITY_MUST_COMPARE_ORDER_CONFIG.PARAM_CONFIG_CODE);
        if(ObjectUtil.isNotEmpty(uocCfcParamConfigDo.getItemList())){
            UocCfcParamConfigItemDo itemDo = uocCfcParamConfigDo.getItemList().get(0);
            UocSysDictionaryQryBo qryCodeBo = new UocSysDictionaryQryBo();
            qryCodeBo.setPCode(UocCfcConstants.COMMODITY_MUST_COMPARE_ORDER_CONFIG.PARAM_CONFIG_CODE);
            qryCodeBo.setCode(itemDo.getItemValue());
            //字典查询
            UocSysDictionaryDo dic = iUocSysDictionaryModel.getModelBy(qryCodeBo);
            //该业务响应数据要么只有一条，要么没有（前端需要这两个字段）
            if (ObjectUtil.isNotEmpty(dic)){
                rspBo.setTotal(1);
                rspBo.setRecordsTotal(1);
            }else {
                rspBo.setTotal(0);
                rspBo.setRecordsTotal(0);
            }
            //对应页数也只有一页
            rspBo.setPageNo(1);
            //rows对象赋值（只有一条数据）
            UocMustCompareOrderConfigQryBo bo = new UocMustCompareOrderConfigQryBo();
            bo.setNeedCompare(itemDo.getItemValue());
            bo.setNeedCompareStr(dic.getDescrip());
            bo.setOpDate(itemDo.getCreateTime());
            bo.setOpUserId(itemDo.getCreateId());
            bo.setOpUserName(itemDo.getCreateName());
            bo.setItemId(itemDo.getItemId());
            List<UocMustCompareOrderConfigQryBo> rows = new ArrayList<>();
            rows.add(bo);
            rspBo.setRows(rows);
            rspBo.setNeedCompare(itemDo.getItemValue());
            rspBo.setNeedCompareStr(dic.getDescrip());
            rspBo.setOpDate(itemDo.getCreateTime());
            rspBo.setOpUserId(itemDo.getCreateId());
            rspBo.setOpUserName(itemDo.getCreateName());
            rspBo.setItemId(itemDo.getItemId());
        }
        return rspBo;
    }
}


