package com.tydic.dyc.oc.service.cmporder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.cmporder.IUocCmpOrderModel;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocQryCmpOrderNoBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocQryCmpOrderNoBySkuServiceReqBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocQryCmpOrderNoBySkuServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:UocQryCmpOrderNoBySkuServiceImpl
 * 说明:
 * 时间:2023/1/4 16:37
 * 作者:田桂银
 */
@HTServiceImpl
public class UocQryCmpOrderNoBySkuServiceImpl implements UocQryCmpOrderNoBySkuService {

    @Autowired
    private IUocCmpOrderModel iUocCmpOrderModel;

    @Override
    public UocQryCmpOrderNoBySkuServiceRspBo qryCmpOrderBySku(UocQryCmpOrderNoBySkuServiceReqBo reqBo) {
        validateArg(reqBo);
        UocQryCmpOrderNoBySkuServiceRspBo rspBo = UocRu.success(UocQryCmpOrderNoBySkuServiceRspBo.class);
        UocQryCmpOrderNoBo qryBo = new UocQryCmpOrderNoBo();
        qryBo.setSkuId(reqBo.getSkuId());
        qryBo.setPurUserId(reqBo.getUserIdIn().toString());
        UocQryCmpOrderNoBo uocQryCmpOrderNoBo = iUocCmpOrderModel.qryCmpOrderNoBySkuIdAndUserId(qryBo);
        if (ObjectUtil.isNotEmpty(uocQryCmpOrderNoBo)) {
            rspBo.setCmpOrderNo(uocQryCmpOrderNoBo.getCmpOrderNo());
        }
        return rspBo;
    }

    private void validateArg(UocQryCmpOrderNoBySkuServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getUserIdIn())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[userIdIn]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSkuId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[skuId]不能为空");
        }
    }
}


