package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocAuditAdjustPriceOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAuditAdjustPriceOrderRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocAuditAdjustPriceOrderServiceImpl
 * 说明:TODO
 * 时间:2022/4/6 18:39
 * 作者:代愿愿
 */
@HTServiceImpl
public class UocAuditAdjustPriceOrderServiceImpl implements UocAuditAdjustPriceOrderService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Override
    public UocAuditAdjustPriceOrderRspBo dealAdjustPriceOrder(UocAuditAdjustPriceOrderReqBo reqBo) {
        // 入参校验
        validateArg(reqBo);
        // 查询变更单明细
        UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo() ;
        uocChngOrderItemObjQryBo.setOrderId(reqBo.getOrderId());
        uocChngOrderItemObjQryBo.setChngOrderId(reqBo.getChngOrderId());
        List<UocChngOrderItemObj> uocChngOrderItemObjList = iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
        if(CollectionUtils.isEmpty(uocChngOrderItemObjList)){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "查询变更明细对象为空");
        }
        // 修改销售单领域销售金额
        updateSaleOrderDomainSalePrice(reqBo,uocChngOrderItemObjList);
        // 修改订单领域销售金额
        updateOrderDomainSalePrice(reqBo,uocChngOrderItemObjList);
        // 修改销售单领域采购金额
        updateSaleOrderDomainPurchasePrice(reqBo,uocChngOrderItemObjList);
        // 修改订单领域采购金额
        updateOrderDomainPurchasePrice(reqBo,uocChngOrderItemObjList);

        UocAuditAdjustPriceOrderRspBo uocAdjustPriceOrderCreateRspBo = UocRu.success(UocAuditAdjustPriceOrderRspBo.class);
        return uocAdjustPriceOrderCreateRspBo;
    }
    /**
     * 修改销售单领域采购金额
     */
    private void updateSaleOrderDomainPurchasePrice(UocAuditAdjustPriceOrderReqBo reqBo,List<UocChngOrderItemObj> uocChngOrderItemObjList){
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItems = new ArrayList<>();
        Date updateTime = new Date();
        uocChngOrderItemObjList.forEach(uocChngOrderItemObj -> {
            if(uocChngOrderItemObj.getChngType().equals(UocConstant.BUSI_TYPE.PRICE_CHG)){
                UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setOrderId(reqBo.getOrderId());
                uocSaleOrderItem.setSaleOrderId(reqBo.getSaleOrderId());
                uocSaleOrderItem.setSaleOrderItemId(uocChngOrderItemObj.getSaleOrderItemId());
                uocSaleOrderItem.setPurchaseFee(uocChngOrderItemObj.getChngFee());
                uocSaleOrderItem.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocSaleOrderItem.setUpdateTime(updateTime);
                saleOrderItems.add(uocSaleOrderItem);
                uocSaleOrderDo.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocSaleOrderDo.setUpdateTime(updateTime);
            }
        });
        if(!CollectionUtils.isEmpty(saleOrderItems)){
            uocSaleOrderDo.setSaleOrderItems(saleOrderItems);
            iUocSaleOrderModel.modifyPurchasePrice(uocSaleOrderDo);
        }
    }
    /**
     * 修改销售单领域销售金额
     */
    private void updateSaleOrderDomainSalePrice(UocAuditAdjustPriceOrderReqBo reqBo,List<UocChngOrderItemObj> uocChngOrderItemObjList){
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItems = new ArrayList<>();
        Date updateTime = new Date();
        uocChngOrderItemObjList.forEach(uocChngOrderItemObj -> {
            if(uocChngOrderItemObj.getChngType().equals(UocConstant.BUSI_TYPE.PRICE_CHG)){
                UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setOrderId(reqBo.getOrderId());
                uocSaleOrderItem.setSaleOrderId(reqBo.getSaleOrderId());
                uocSaleOrderItem.setSaleOrderItemId(uocChngOrderItemObj.getSaleOrderItemId());
                uocSaleOrderItem.setSalePrice(uocChngOrderItemObj.getChngFee());
                uocSaleOrderItem.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocSaleOrderItem.setUpdateTime(updateTime);
                saleOrderItems.add(uocSaleOrderItem);
                uocSaleOrderDo.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocSaleOrderDo.setUpdateTime(updateTime);
            }
        });
        if(!CollectionUtils.isEmpty(saleOrderItems)){
            uocSaleOrderDo.setSaleOrderItems(saleOrderItems);
            iUocSaleOrderModel.modifySalePrice(uocSaleOrderDo);
        }
    }
    /**
     * 修改订单领域采购金额
     */
    private void updateOrderDomainPurchasePrice(UocAuditAdjustPriceOrderReqBo reqBo,List<UocChngOrderItemObj> uocChngOrderItemObjList){
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(reqBo.getOrderId());
        List<UocOrderItem> orderItems = new ArrayList<>();
        Date updateTime = new Date();
        uocChngOrderItemObjList.forEach(uocChngOrderItemObj -> {
            if(uocChngOrderItemObj.getChngType().equals(UocConstant.BUSI_TYPE.PRICE_CHG)){
                UocOrderItem uocOrderItem = new UocOrderItem();
                uocOrderItem.setOrderId(reqBo.getOrderId());
                uocOrderItem.setOrderItemId(uocChngOrderItemObj.getOrderItemId());
                uocOrderItem.setPurchasePrice(uocChngOrderItemObj.getChngFee());
                uocOrderItem.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocOrderItem.setUpdateTime(updateTime);
                orderItems.add(uocOrderItem);

                uocOrderDo.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocOrderDo.setUpdateTime(updateTime);
            }
        });
        if(!CollectionUtils.isEmpty(orderItems)){
            uocOrderDo.setOrderItems(orderItems);
            iUocOrderModel.modifyPurchasePrice(uocOrderDo);
        }
    }
    /**
     * 修改订单领域销售金额
     */
    private void updateOrderDomainSalePrice(UocAuditAdjustPriceOrderReqBo reqBo,List<UocChngOrderItemObj> uocChngOrderItemObjList){
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(reqBo.getOrderId());
        List<UocOrderItem> orderItems = new ArrayList<>();
        Date updateTime = new Date();
        uocChngOrderItemObjList.forEach(uocChngOrderItemObj -> {
            if(uocChngOrderItemObj.getChngType().equals(UocConstant.BUSI_TYPE.PRICE_CHG)){
                UocOrderItem uocOrderItem = new UocOrderItem();
                uocOrderItem.setOrderId(reqBo.getOrderId());
                uocOrderItem.setOrderItemId(uocChngOrderItemObj.getOrderItemId());
                uocOrderItem.setSalePrice(uocChngOrderItemObj.getChngFee());
                uocOrderItem.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocOrderItem.setUpdateTime(updateTime);
                orderItems.add(uocOrderItem);

                uocOrderDo.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocOrderDo.setUpdateTime(updateTime);
            }
        });
        if(!CollectionUtils.isEmpty(orderItems)){
            uocOrderDo.setOrderItems(orderItems);
            iUocOrderModel.modifySalePrice(uocOrderDo);
        }
    }


    /**
     * 入参校验
     */
    private void validateArg(UocAuditAdjustPriceOrderReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID为空");
        }
        if(reqBo.getChngOrderId()==null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更单ID为空");
        }
        if(reqBo.getSaleOrderId()==null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID为空");
        }
    }
}
