package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.transactionservice.UocChngOrderConfirmOrRefuseForInspTransaction;
import com.tydic.dyc.oc.transactionservice.UocChngOrderModifyStateTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author WangJiuXin
 * @date 2023/6/20
 * @decr  新变更确认/拒绝（验收单维度）服务实现
 **/
@HTServiceImpl
public class UocChngOrderModifyStateServiceImpl implements UocChngOrderModifyStateService{

    @Autowired
    private UocChngOrderModifyStateTransaction uocChngOrderModifyStateTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    
    /**
     * 用于更新变更单状态
     *
     * @param reqBo
     * @return
     */
    @Override
    public UocChngOrderModifyStateServiceRspBo dealConfirmOrRefuse(UocChngOrderModifyStateServiceReqBo reqBo) {
        UocChngOrderModifyStateServiceRspBo rspBo = uocChngOrderModifyStateTransaction.modifyState(reqBo);
        
        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }
        
        return rspBo;
        
    }
    
    private void syncEs(UocChngOrderModifyStateServiceReqBo reqBo, UocChngOrderModifyStateServiceRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        //同步变更单
        SyncEsRunnableBo chngBo = new SyncEsRunnableBo();
        chngBo.setIndexName(uocIndexConfig.getChngOrderIndex());
        chngBo.setOrderId(reqBo.getOrderId());
        chngBo.setObjId(reqBo.getChngOrderId());
        chngBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(chngBo);
        

        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
    
}
