package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalLog;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateApprovalOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateApprovalOrderServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderApprovalObjBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;


/*
 * @Author lsl
 * @Description //TODO 创建审批单（新 交行）实现
 * @Date 16:01 2023/8/3
 * @Param
 * @return
 */

@Slf4j
@HTServiceImpl
public class UocCreateApprovalOrderServiceImpl implements UocCreateApprovalOrderService {
    
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    
    @Autowired
    private UocCommonRepository uocCommonRepository;
    
    @Override
    public UocCreateApprovalOrderServiceRspBo createApprovalOrder(UocCreateApprovalOrderServiceReqBo reqBo) {
        UocCreateApprovalOrderServiceRspBo rspBo = UocRu.success(UocCreateApprovalOrderServiceRspBo.class);
        //入参校验
        validateParm(reqBo);
        //0、 先判断该销售单有没有对应得审批单，如果有，则不用再生成一次 (防止一个销售单对应多个审批单的情况)
        getUocCreateApprovalOrderServiceRspBo(reqBo, rspBo);
        
        if (!UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            return rspBo;
        }
    
        //1.查询订单(orderId)下所有的销售单列表
        List<UocSaleOrderDo> saleOrderDoList = getUocSaleOrderDos(reqBo);
        
        //2.查询订单(orderId)下所有的销售单是否都在 "审批中" 或者 "已取消"
        checkSaleOrderState(rspBo, saleOrderDoList);
        
        log.info("审批中销售订单列表：{}", JSON.toJSONString(saleOrderDoList));
        
        //3.根据审批单组装规则组装审批单数据：根据归口部门将“审批中”的销售单列表分组
        List<List<UocSaleOrderDo>> list = calculcateData(saleOrderDoList);
        
        log.info("创建数据列表：{}", JSON.toJSONString(list));
        List<Long> approvalOrderIdList = new ArrayList<>();
        List<String> approvalOrderCodeList = new ArrayList<>();
        List<UocSaleOrderApprovalObjBO> approvalObjBOList = new ArrayList<>();
        for (List<UocSaleOrderDo> saleOrderDos : list) {
            long auditId = IdUtil.nextId();
            
            UocAuditOrderDo auditDo = new UocAuditOrderDo();
            auditDo.setOrderId(reqBo.getOrderId());
            auditDo.setAuditOrderId(auditId);
            auditDo.setAuditOrderStatus(UocStateConstants.AUDIT_PLUS_ORDER_STATUS.AUDITING);
            String auditCode = genRequestCode();
            auditDo.setAuditOrderCode(auditCode);
//            auditDo.setAuditOrderCode("审批测试单号");
            auditDo.setCreateTime(new Date());
            auditDo.setCreateOperId(reqBo.getUserId());
            auditDo.setCreateOperName(reqBo.getUserName());
            
            List<UocApprovalObj> objList = new ArrayList<>();
            auditDo.setApprovalObjs(objList);
            
            List<UocApprovalLog> uocApprovalLogList = new ArrayList<>();
            auditDo.setUocApprovalLogList(uocApprovalLogList);
            
            for (UocSaleOrderDo uocSaleOrderDo : saleOrderDos) {
                
                UocApprovalObj approvalObj = new UocApprovalObj();
                approvalObj.setObjId(uocSaleOrderDo.getSaleOrderId().toString());
                approvalObj.setId(IdUtil.nextId());
                approvalObj.setAuditOrderId(auditDo.getAuditOrderId());
                approvalObj.setOrderId(reqBo.getOrderId());
                approvalObj.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                approvalObj.setObjBusiType(UocDicConstant.OBJ_TYPE.SALE);
                objList.add(approvalObj);
                
                UocApprovalLog uocApprovalLog = new UocApprovalLog();
                uocApprovalLog.setAuditOrderId(auditId);
                uocApprovalLog.setId(IdUtil.nextId());
                uocApprovalLog.setCreateTime(new Date());
                uocApprovalLog.setObjNum(objList.size());
                uocApprovalLog.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                uocApprovalLog.setAuditResult(UocConstant.AUDIT_TYPE.CREATE);
                uocApprovalLogList.add(uocApprovalLog);
    
    
                approvalObjBOList.add(UocRu.js(approvalObj,UocSaleOrderApprovalObjBO.class));
            }
            
            iUocAuditOrderModel.saveAudit(auditDo);
            approvalOrderIdList.add(auditId);
            approvalOrderCodeList.add(auditCode);
        }
        rspBo.setApprovalOrderIdList(approvalOrderIdList);
        rspBo.setApprovalOrderCodeList(approvalOrderCodeList);
        rspBo.setApprovalObjBOList(approvalObjBOList);
        return rspBo;
    }
    
    private void getUocCreateApprovalOrderServiceRspBo(UocCreateApprovalOrderServiceReqBo reqBo, UocCreateApprovalOrderServiceRspBo rspBo) {
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        uocApprovalObjQryBo.setObjId(String.valueOf(reqBo.getSaleOrderId()));
        uocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        
        if(ObjectUtil.isNotEmpty(uocApprovalObjs)){
            rspBo.setRespCode(UocRspConstants.RSP_CODE_FAIL);
            rspBo.setRespDesc("该销售单已有对应的审批单，不再生成审批单");
        }
    }
    
    private String genRequestCode() {
        return uocCommonRepository.getOrderNoSingle(UocObjNoConstants.AUDIT_ORDER_NO);
    }
    
    private List<List<UocSaleOrderDo>> calculcateData(List<UocSaleOrderDo> saleOrderDoList) {
        
        List<UocSaleOrderDo> relevantSaleOrderList = new ArrayList<>();
        List<UocSaleOrderDo> noRelevantSaleOrderList = new ArrayList<>();
        
        // 过滤出所有状态为审批中的销售订单，用来生成审批单
        List<UocSaleOrderDo> auditingSaleOrderList = saleOrderDoList.stream().filter(e -> {
            if (UocStateConstants.SaleOrder.XS_SP_SPZ.equals(e.getSaleOrderState())) {
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        
        if (CollectionUtils.isEmpty(auditingSaleOrderList)) {
            throw new ZTBusinessException("该订单下没有对应的“审批中”状态的销售单,暂不创建审批单");
        }
        log.info("待生成审批得订单列表:{}", JSON.toJSONString(auditingSaleOrderList));
        
        for (UocSaleOrderDo saleOrderDo : auditingSaleOrderList) {
            UocSaleOrderMapQryBo uocSaleOrderMapQryBo = new UocSaleOrderMapQryBo();
            
            uocSaleOrderMapQryBo.setSaleOrderId(saleOrderDo.getSaleOrderId());
            //查询销售单扩展
            List<UocSaleOrderMap> uocSaleOrderMapList = iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
            
            log.info("订单扩展列表:{}", JSON.toJSONString(uocSaleOrderMapList));
            
            Iterator<UocSaleOrderMap> iterator = uocSaleOrderMapList.iterator();
            boolean releFalg = false;
            
            while (iterator.hasNext()) {
                UocSaleOrderMap uocSaleOrderMap = iterator.next();
                if ("relevantDeptId".equals(uocSaleOrderMap.getFieldCode()) && ObjectUtil.isNotEmpty(uocSaleOrderMap.getFieldValue())) {
                    releFalg = true;
                    List<BaseExtendFieldBo> extFields = new ArrayList<>();
                    
                    BaseExtendFieldBo extendFieldBo = new BaseExtendFieldBo();
                    extendFieldBo.setFieldCode(uocSaleOrderMap.getFieldCode());
                    extendFieldBo.setFieldValue(uocSaleOrderMap.getFieldValue());
                    extFields.add(extendFieldBo);
                    saleOrderDo.setExtFields(extFields);
                }
            }
            if (releFalg) {
                relevantSaleOrderList.add(saleOrderDo);
            } else {
                noRelevantSaleOrderList.add(saleOrderDo);
            }
        }
        log.info("没有归口部门的销售单列表:{}", JSON.toJSONString(noRelevantSaleOrderList));
        log.info("有归口部门的销售单列表:{}", JSON.toJSONString(relevantSaleOrderList));
        
        List<List<UocSaleOrderDo>> list = new ArrayList<>();
        
        if(ObjectUtil.isNotEmpty(noRelevantSaleOrderList)){
            list.add(noRelevantSaleOrderList);
        }
        
       Map<String,List<UocSaleOrderDo>> saleOrderListMap =  relevantSaleOrderList.stream().collect(Collectors.groupingBy(e->e.getExtFields().get(0).getFieldValue()));
    
        for (Map.Entry<String,List<UocSaleOrderDo>> entry : saleOrderListMap.entrySet()) {
            list.add(entry.getValue());
        }
        return list;
        
    }
    
    private List<UocSaleOrderDo> getUocSaleOrderDos(UocCreateApprovalOrderServiceReqBo reqBo) {
        UocSaleOrderDo qryDo = new UocSaleOrderDo();
        qryDo.setOrderId(reqBo.getOrderId());
        qryDo.setOrderSource(reqBo.getOrderSource());
        List<UocSaleOrderDo> saleOrderDoList = iUocSaleOrderModel.qrySaleOrderList(qryDo);
        return saleOrderDoList;
    }
    
    private void checkSaleOrderState(UocCreateApprovalOrderServiceRspBo rspBo, List<UocSaleOrderDo> saleOrderDoList) {
        boolean allCancelOrAuditing = true;
        for (UocSaleOrderDo uocSaleOrderDo : saleOrderDoList) {
            if (!UocStateConstants.SaleOrder.XS_SP_SPZ.equals(uocSaleOrderDo.getSaleOrderState()) && !UocStateConstants
                    .SaleOrder.XS_QX_QX.equals(uocSaleOrderDo.getSaleOrderState())) {
                allCancelOrAuditing = false;
            }
        }
        if (!allCancelOrAuditing) {
            throw new ZTBusinessException("该订单(orderId)下有状态不是”审批中“或“已取消”的销售订单");
        }
    }
    
    private void validateParm(UocCreateApprovalOrderServiceReqBo reqBo) {
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new ZTBusinessException("订单id【orderId】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderId())) {
            throw new ZTBusinessException("销售订单id【saleOrderId】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderSource())) {
            throw new ZTBusinessException("订单来源【orderSource】不能为空");
        }
    }
}
