package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.date.DateUtil;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetCheckSaleOrdersReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetCheckSaleOrdersRspBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@HTServiceImpl
public class UocGetCheckSaleOrdersServiceImpl implements UocGetCheckSaleOrdersService {
    
    @Autowired
    private IUocSaleOrderModel saleOrderModel;
    
    @Override
    public UocGetCheckSaleOrdersRspBO getCheckOrders(UocGetCheckSaleOrdersReqBO reqBO) {
        UocGetCheckSaleOrdersRspBO rspBO = new UocGetCheckSaleOrdersRspBO();
        
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSupId(Long.valueOf(reqBO.getSupId()));
        uocSaleOrderQryBo.setCreateTimeStart(DateUtils.strToDate(reqBO.getCreateTimeStart(),"yyyy-MM-dd HH:mm:ss"));
        uocSaleOrderQryBo.setCreateTimeEnd(DateUtils.strToDate(reqBO.getCreateTimeEnd(),"yyyy-MM-dd HH:mm:ss"));
        
        List<UocSaleOrderDo> saleOrderDoList = saleOrderModel.getSaleOrders(uocSaleOrderQryBo);
        List<UocSaleOrderBO> saleOrderBOS = UocRu.jsl(saleOrderDoList, UocSaleOrderBO.class);
        rspBO.setSaleOrders(saleOrderBOS);
        return rspBO;
    }
}
