package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.transactionservice.UocPasteCancelApplySaleOrderTransaction;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.UocPasteCancelApplySaleOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocPasteCancelApplySaleOrderRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述: 〈领域服务-销售单取消申请撤回实现〉
 *
 * @author : yuhao
 * @date : 2022/8/1 10:00
 */
@HTServiceImpl
public class UocPasteCancelApplySaleOrderServiceImpl implements UocPasteCancelApplySaleOrderService {


    @Autowired
    private UocPasteCancelApplySaleOrderTransaction uocPasteCancelApplySaleOrderTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Override
    public UocPasteCancelApplySaleOrderRspBo dealPasteCancelApply(UocPasteCancelApplySaleOrderReqBo reqBo) {
        UocPasteCancelApplySaleOrderRspBo rspBo = uocPasteCancelApplySaleOrderTransaction.dealPasteCancelApply(reqBo);
        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocPasteCancelApplySaleOrderReqBo reqBo, UocPasteCancelApplySaleOrderRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo saleOrderBo = new SyncEsRunnableBo();
        saleOrderBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleOrderBo.setOrderId(reqBo.getOrderId());
        saleOrderBo.setObjId(reqBo.getSaleOrderId());
        saleOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleOrderBo);

        SyncEsRunnableBo chngBo = new SyncEsRunnableBo();
        chngBo.setIndexName(uocIndexConfig.getChngOrderIndex());
        chngBo.setOrderId(reqBo.getOrderId());
        chngBo.setObjId(reqBo.getChngOrderId());
        chngBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(chngBo);

        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}
